/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.commands;

import com.gmail.nossr50.commands.MHDCommand;
import com.gmail.nossr50.commands.McImportCommand;
import com.gmail.nossr50.commands.McabilityCommand;
import com.gmail.nossr50.commands.McconvertCommand;
import com.gmail.nossr50.commands.McgodCommand;
import com.gmail.nossr50.commands.McmmoCommand;
import com.gmail.nossr50.commands.McnotifyCommand;
import com.gmail.nossr50.commands.McrefreshCommand;
import com.gmail.nossr50.commands.McscoreboardCommand;
import com.gmail.nossr50.commands.XprateCommand;
import com.gmail.nossr50.commands.admin.McmmoReloadLocaleCommand;
import com.gmail.nossr50.commands.admin.PlayerDebugCommand;
import com.gmail.nossr50.commands.chat.AdminChatCommand;
import com.gmail.nossr50.commands.chat.McChatSpy;
import com.gmail.nossr50.commands.chat.PartyChatCommand;
import com.gmail.nossr50.commands.database.McpurgeCommand;
import com.gmail.nossr50.commands.database.McremoveCommand;
import com.gmail.nossr50.commands.database.MmoshowdbCommand;
import com.gmail.nossr50.commands.experience.AddlevelsCommand;
import com.gmail.nossr50.commands.experience.AddxpCommand;
import com.gmail.nossr50.commands.experience.MmoeditCommand;
import com.gmail.nossr50.commands.experience.SkillresetCommand;
import com.gmail.nossr50.commands.hardcore.HardcoreCommand;
import com.gmail.nossr50.commands.hardcore.VampirismCommand;
import com.gmail.nossr50.commands.party.PartyCommand;
import com.gmail.nossr50.commands.party.teleport.PtpCommand;
import com.gmail.nossr50.commands.player.InspectCommand;
import com.gmail.nossr50.commands.player.MccooldownCommand;
import com.gmail.nossr50.commands.player.McrankCommand;
import com.gmail.nossr50.commands.player.McstatsCommand;
import com.gmail.nossr50.commands.player.MctopCommand;
import com.gmail.nossr50.commands.skills.AcrobaticsCommand;
import com.gmail.nossr50.commands.skills.AlchemyCommand;
import com.gmail.nossr50.commands.skills.ArcheryCommand;
import com.gmail.nossr50.commands.skills.AxesCommand;
import com.gmail.nossr50.commands.skills.ExcavationCommand;
import com.gmail.nossr50.commands.skills.FishingCommand;
import com.gmail.nossr50.commands.skills.HerbalismCommand;
import com.gmail.nossr50.commands.skills.MiningCommand;
import com.gmail.nossr50.commands.skills.MmoInfoCommand;
import com.gmail.nossr50.commands.skills.RepairCommand;
import com.gmail.nossr50.commands.skills.SalvageCommand;
import com.gmail.nossr50.commands.skills.SmeltingCommand;
import com.gmail.nossr50.commands.skills.SwordsCommand;
import com.gmail.nossr50.commands.skills.TamingCommand;
import com.gmail.nossr50.commands.skills.UnarmedCommand;
import com.gmail.nossr50.commands.skills.WoodcuttingCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;

public final class CommandRegistrationManager {
    private static String permissionsMessage = LocaleLoader.getString("mcMMO.NoPermission");

    private CommandRegistrationManager() {
    }

    private static void registerSkillCommands() {
        block17: for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            String string = primarySkillType.toString().toLowerCase();
            String string2 = primarySkillType.getName().toLowerCase();
            PluginCommand pluginCommand = mcMMO.p.getCommand(string);
            pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.Skill", StringUtils.getCapitalized(string2)));
            pluginCommand.setPermission("mcmmo.commands." + string);
            pluginCommand.setPermissionMessage(permissionsMessage);
            pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", string2));
            pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", string2, "?", "[" + LocaleLoader.getString("Commands.Usage.Page") + "]"));
            switch (primarySkillType) {
                case ACROBATICS: {
                    pluginCommand.setExecutor((CommandExecutor)new AcrobaticsCommand());
                    continue block17;
                }
                case ALCHEMY: {
                    pluginCommand.setExecutor((CommandExecutor)new AlchemyCommand());
                    continue block17;
                }
                case ARCHERY: {
                    pluginCommand.setExecutor((CommandExecutor)new ArcheryCommand());
                    continue block17;
                }
                case AXES: {
                    pluginCommand.setExecutor((CommandExecutor)new AxesCommand());
                    continue block17;
                }
                case EXCAVATION: {
                    pluginCommand.setExecutor((CommandExecutor)new ExcavationCommand());
                    continue block17;
                }
                case FISHING: {
                    pluginCommand.setExecutor((CommandExecutor)new FishingCommand());
                    continue block17;
                }
                case HERBALISM: {
                    pluginCommand.setExecutor((CommandExecutor)new HerbalismCommand());
                    continue block17;
                }
                case MINING: {
                    pluginCommand.setExecutor((CommandExecutor)new MiningCommand());
                    continue block17;
                }
                case REPAIR: {
                    pluginCommand.setExecutor((CommandExecutor)new RepairCommand());
                    continue block17;
                }
                case SALVAGE: {
                    pluginCommand.setExecutor((CommandExecutor)new SalvageCommand());
                    continue block17;
                }
                case SMELTING: {
                    pluginCommand.setExecutor((CommandExecutor)new SmeltingCommand());
                    continue block17;
                }
                case SWORDS: {
                    pluginCommand.setExecutor((CommandExecutor)new SwordsCommand());
                    continue block17;
                }
                case TAMING: {
                    pluginCommand.setExecutor((CommandExecutor)new TamingCommand());
                    continue block17;
                }
                case UNARMED: {
                    pluginCommand.setExecutor((CommandExecutor)new UnarmedCommand());
                    continue block17;
                }
                case WOODCUTTING: {
                    pluginCommand.setExecutor((CommandExecutor)new WoodcuttingCommand());
                    continue block17;
                }
            }
        }
    }

    private static void registerAddlevelsCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("addlevels");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.addlevels"));
        pluginCommand.setPermission("mcmmo.commands.addlevels;mcmmo.commands.addlevels.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.3", "addlevels", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.Level") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new AddlevelsCommand());
    }

    private static void registerAddxpCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("addxp");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.addxp"));
        pluginCommand.setPermission("mcmmo.commands.addxp;mcmmo.commands.addxp.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.3", "addxp", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.XP") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new AddxpCommand());
    }

    private static void registerMcgodCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcgod");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcgod"));
        pluginCommand.setPermission("mcmmo.commands.mcgod;mcmmo.commands.mcgod.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcgod", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        pluginCommand.setExecutor((CommandExecutor)new McgodCommand());
    }

    private static void registerMmoInfoCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mmoinfo");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mmoinfo"));
        pluginCommand.setPermission("mcmmo.commands.mmoinfo");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mmoinfo", "[" + LocaleLoader.getString("Commands.Usage.SubSkill") + "]"));
        pluginCommand.setExecutor((CommandExecutor)new MmoInfoCommand());
    }

    private static void registerMmoDebugCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mmodebug");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mmodebug"));
        pluginCommand.setPermission(null);
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mmodebug"));
        pluginCommand.setExecutor((CommandExecutor)new PlayerDebugCommand());
    }

    private static void registerMcChatSpyCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcchatspy");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcchatspy"));
        pluginCommand.setPermission("mcmmo.commands.mcchatspy;mcmmo.commands.mcchatspy.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcchatspy", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        pluginCommand.setExecutor((CommandExecutor)new McChatSpy());
    }

    private static void registerMcrefreshCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcrefresh");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcrefresh"));
        pluginCommand.setPermission("mcmmo.commands.mcrefresh;mcmmo.commands.mcrefresh.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcrefresh", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        pluginCommand.setExecutor((CommandExecutor)new McrefreshCommand());
    }

    private static void registerMmoeditCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mmoedit");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mmoedit"));
        pluginCommand.setPermission("mcmmo.commands.mmoedit;mcmmo.commands.mmoedit.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.3", "mmoedit", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.Level") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new MmoeditCommand());
    }

    private static void registerSkillresetCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("skillreset");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.skillreset"));
        pluginCommand.setPermission("mcmmo.commands.skillreset;mcmmo.commands.skillreset.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.2", "skillreset", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new SkillresetCommand());
    }

    private static void registerXprateCommand() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mcxprate");
        PluginCommand pluginCommand = mcMMO.p.getCommand("xprate");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.xprate"));
        pluginCommand.setPermission("mcmmo.commands.xprate;mcmmo.commands.xprate.reset;mcmmo.commands.xprate.set");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.2", "xprate", "<" + LocaleLoader.getString("Commands.Usage.Rate") + ">", "<true|false>"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "xprate", "reset"));
        pluginCommand.setAliases(arrayList);
        pluginCommand.setExecutor((CommandExecutor)new XprateCommand());
    }

    private static void registerInspectCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("inspect");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.inspect"));
        pluginCommand.setPermission("mcmmo.commands.inspect;mcmmo.commands.inspect.far;mcmmo.commands.inspect.offline");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "inspect", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new InspectCommand());
    }

    private static void registerMccooldownCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mccooldown");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mccooldown"));
        pluginCommand.setPermission("mcmmo.commands.mccooldown");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mccooldowns"));
        pluginCommand.setExecutor((CommandExecutor)new MccooldownCommand());
    }

    private static void registerMcabilityCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcability");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcability"));
        pluginCommand.setPermission("mcmmo.commands.mcability;mcmmo.commands.mcability.others");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcability", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        pluginCommand.setExecutor((CommandExecutor)new McabilityCommand());
    }

    private static void registerMcmmoCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcmmo");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcmmo"));
        pluginCommand.setPermission("mcmmo.commands.mcmmo.description;mcmmo.commands.mcmmo.help");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcmmo"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "mcmmo", "help"));
        pluginCommand.setExecutor((CommandExecutor)new McmmoCommand());
    }

    private static void registerMcrankCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcrank");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcrank"));
        pluginCommand.setPermission("mcmmo.commands.mcrank;mcmmo.commands.mcrank.others;mcmmo.commands.mcrank.others.far;mcmmo.commands.mcrank.others.offline");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcrank", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        pluginCommand.setExecutor((CommandExecutor)new McrankCommand());
    }

    private static void registerMcstatsCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcstats");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcstats"));
        pluginCommand.setPermission("mcmmo.commands.mcstats");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcstats"));
        pluginCommand.setExecutor((CommandExecutor)new McstatsCommand());
    }

    private static void registerMctopCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mctop");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mctop"));
        pluginCommand.setPermission("mcmmo.commands.mctop");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.2", "mctop", "[" + LocaleLoader.getString("Commands.Usage.Skill") + "]", "[" + LocaleLoader.getString("Commands.Usage.Page") + "]"));
        pluginCommand.setExecutor((CommandExecutor)new MctopCommand());
    }

    private static void registerMcpurgeCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcpurge");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcpurge", Config.getInstance().getOldUsersCutoff()));
        pluginCommand.setPermission("mcmmo.commands.mcpurge");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcpurge"));
        pluginCommand.setExecutor((CommandExecutor)new McpurgeCommand());
    }

    private static void registerMcremoveCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcremove");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcremove"));
        pluginCommand.setPermission("mcmmo.commands.mcremove");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcremove", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new McremoveCommand());
    }

    private static void registerMmoshowdbCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mmoshowdb");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mmoshowdb"));
        pluginCommand.setPermission("mcmmo.commands.mmoshowdb");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mmoshowdb"));
        pluginCommand.setExecutor((CommandExecutor)new MmoshowdbCommand());
    }

    private static void registerMcconvertCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcconvert");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcconvert"));
        pluginCommand.setPermission("mcmmo.commands.mcconvert;mcmmo.commands.mcconvert.experience;mcmmo.commands.mcconvert.database");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.2", "mcconvert", "database", "<flatfile|sql>"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", "mcconvert", "experience", "<linear|exponential>"));
        pluginCommand.setExecutor((CommandExecutor)new McconvertCommand());
    }

    private static void registerAdminChatCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("adminchat");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.adminchat"));
        pluginCommand.setPermission("mcmmo.chat.adminchat");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "adminchat"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "adminchat", "<on|off>"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "adminchat", "<" + LocaleLoader.getString("Commands.Usage.Message") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new AdminChatCommand());
    }

    private static void registerPartyChatCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("partychat");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.partychat"));
        pluginCommand.setPermission("mcmmo.chat.partychat;mcmmo.commands.party");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "partychat"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "partychat", "<on|off>"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "partychat", "<" + LocaleLoader.getString("Commands.Usage.Message") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new PartyChatCommand());
    }

    private static void registerPartyCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("party");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.party"));
        pluginCommand.setPermission("mcmmo.commands.party;mcmmo.commands.party.accept;mcmmo.commands.party.create;mcmmo.commands.party.disband;mcmmo.commands.party.xpshare;mcmmo.commands.party.invite;mcmmo.commands.party.itemshare;mcmmo.commands.party.join;mcmmo.commands.party.kick;mcmmo.commands.party.lock;mcmmo.commands.party.owner;mcmmo.commands.party.password;mcmmo.commands.party.quit;mcmmo.commands.party.rename;mcmmo.commands.party.unlock");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setExecutor((CommandExecutor)new PartyCommand());
    }

    private static void registerPtpCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("ptp");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.ptp"));
        pluginCommand.setPermission("mcmmo.commands.ptp");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "ptp", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "ptp", "<toggle|accept|acceptall>"));
        pluginCommand.setExecutor((CommandExecutor)new PtpCommand());
    }

    private static void registerHardcoreCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("hardcore");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.hardcore"));
        pluginCommand.setPermission("mcmmo.commands.hardcore;mcmmo.commands.hardcore.toggle;mcmmo.commands.hardcore.modify");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "hardcore", "[on|off]"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "hardcore", "<" + LocaleLoader.getString("Commands.Usage.Rate") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new HardcoreCommand());
    }

    private static void registerVampirismCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("vampirism");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.vampirism"));
        pluginCommand.setPermission("mcmmo.commands.vampirism;mcmmo.commands.vampirism.toggle;mcmmo.commands.vampirism.modify");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "vampirism", "[on|off]"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "vampirism", "<" + LocaleLoader.getString("Commands.Usage.Rate") + ">"));
        pluginCommand.setExecutor((CommandExecutor)new VampirismCommand());
    }

    private static void registerMcnotifyCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcnotify");
        pluginCommand.setDescription(LocaleLoader.getString("Commands.Description.mcnotify"));
        pluginCommand.setPermission("mcmmo.commands.mcnotify");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcnotify"));
        pluginCommand.setExecutor((CommandExecutor)new McnotifyCommand());
    }

    private static void registerMHDCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mhd");
        pluginCommand.setDescription("Resets all mob health bar settings for all players to the default");
        pluginCommand.setPermission("mcmmo.commands.mhd");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mhd"));
        pluginCommand.setExecutor((CommandExecutor)new MHDCommand());
    }

    private static void registerMcscoreboardCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcscoreboard");
        pluginCommand.setDescription("Change the current mcMMO scoreboard being displayed");
        pluginCommand.setPermission("mcmmo.commands.mcscoreboard");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcscoreboard", "<CLEAR | KEEP>"));
        pluginCommand.setUsage(pluginCommand.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", "mcscoreboard", "time", "<seconds>"));
        pluginCommand.setExecutor((CommandExecutor)new McscoreboardCommand());
    }

    private static void registerMcImportCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcimport");
        pluginCommand.setDescription("Import mod config files");
        pluginCommand.setPermission("mcmmo.commands.mcimport");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcimport"));
        pluginCommand.setExecutor((CommandExecutor)new McImportCommand());
    }

    private static void registerReloadLocaleCommand() {
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcmmoreloadlocale");
        pluginCommand.setDescription("Reloads locale");
        pluginCommand.setPermission("mcmmo.commands.reloadlocale");
        pluginCommand.setPermissionMessage(permissionsMessage);
        pluginCommand.setUsage(LocaleLoader.formatString("Commands.Usage.0", "mcmmoreloadlocale"));
        pluginCommand.setExecutor((CommandExecutor)new McmmoReloadLocaleCommand());
    }

    public static void registerCommands() {
        CommandRegistrationManager.registerMmoInfoCommand();
        CommandRegistrationManager.registerMmoDebugCommand();
        CommandRegistrationManager.registerMcImportCommand();
        CommandRegistrationManager.registerMcabilityCommand();
        CommandRegistrationManager.registerMcgodCommand();
        CommandRegistrationManager.registerMcChatSpyCommand();
        CommandRegistrationManager.registerMcmmoCommand();
        CommandRegistrationManager.registerMcnotifyCommand();
        CommandRegistrationManager.registerMcrefreshCommand();
        CommandRegistrationManager.registerMcscoreboardCommand();
        CommandRegistrationManager.registerMHDCommand();
        CommandRegistrationManager.registerXprateCommand();
        CommandRegistrationManager.registerPartyChatCommand();
        CommandRegistrationManager.registerAdminChatCommand();
        CommandRegistrationManager.registerMcpurgeCommand();
        CommandRegistrationManager.registerMcremoveCommand();
        CommandRegistrationManager.registerMmoshowdbCommand();
        CommandRegistrationManager.registerMcconvertCommand();
        CommandRegistrationManager.registerAddlevelsCommand();
        CommandRegistrationManager.registerAddxpCommand();
        CommandRegistrationManager.registerMmoeditCommand();
        CommandRegistrationManager.registerSkillresetCommand();
        CommandRegistrationManager.registerHardcoreCommand();
        CommandRegistrationManager.registerVampirismCommand();
        CommandRegistrationManager.registerPartyCommand();
        CommandRegistrationManager.registerPtpCommand();
        CommandRegistrationManager.registerInspectCommand();
        CommandRegistrationManager.registerMccooldownCommand();
        CommandRegistrationManager.registerMcrankCommand();
        CommandRegistrationManager.registerMcstatsCommand();
        CommandRegistrationManager.registerMctopCommand();
        CommandRegistrationManager.registerSkillCommands();
        CommandRegistrationManager.registerReloadLocaleCommand();
    }
}

