/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.RankConfig;
import com.gmail.nossr50.datatypes.json.McMMOWebLinks;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class TextComponentFactory {
    public static TextComponent getNotificationMultipleValues(String string, String ... stringArray) {
        String string2 = LocaleLoader.getString(string, stringArray);
        TextComponent textComponent = new TextComponent(string2);
        return new TextComponent(textComponent);
    }

    public static TextComponent getNotificationTextComponentFromLocale(String string) {
        return TextComponentFactory.getNotificationTextComponent(LocaleLoader.getString(string));
    }

    public static TextComponent getNotificationLevelUpTextComponent(PrimarySkillType primarySkillType, int n, int n2) {
        TextComponent textComponent = new TextComponent(LocaleLoader.getString("Overhaul.Levelup", LocaleLoader.getString("Overhaul.Name." + StringUtils.getCapitalized(primarySkillType.toString())), n, n2));
        return textComponent;
    }

    private static TextComponent getNotificationTextComponent(String string) {
        return new TextComponent(string);
    }

    public static void sendPlayerSubSkillWikiLink(Player player, String string) {
        if (!Config.getInstance().getUrlLinksEnabled()) {
            return;
        }
        Player.Spigot spigot = player.spigot();
        TextComponent textComponent = new TextComponent(LocaleLoader.getString("Overhaul.mcMMO.MmoInfo.Wiki"));
        textComponent.setUnderlined(Boolean.valueOf(true));
        String string2 = "https://mcmmo.org/wiki/" + string;
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, string2));
        ComponentBuilder componentBuilder = new ComponentBuilder(string).append("\n").append(string2).color(ChatColor.GRAY).italic(true);
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, componentBuilder.create()));
        spigot.sendMessage(ChatMessageType.SYSTEM, (BaseComponent)textComponent);
    }

    public static void sendPlayerUrlHeader(Player player) {
        Player.Spigot spigot = player.spigot();
        TextComponent textComponent = new TextComponent(LocaleLoader.getString("Overhaul.mcMMO.Url.Wrap.Prefix") + " ");
        TextComponent textComponent2 = new TextComponent(" " + LocaleLoader.getString("Overhaul.mcMMO.Url.Wrap.Suffix"));
        TextComponent textComponent3 = new TextComponent(" ");
        BaseComponent[] baseComponentArray = new BaseComponent[]{new TextComponent(textComponent), TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.WEBSITE), textComponent3, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.DISCORD), textComponent3, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.PATREON), textComponent3, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.WIKI), textComponent3, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.SPIGOT), textComponent3, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.HELP_TRANSLATE), new TextComponent(textComponent2)};
        spigot.sendMessage(baseComponentArray);
    }

    public static void sendPlayerSubSkillList(Player player, List<TextComponent> list) {
        TextComponent textComponent = new TextComponent(" ");
        ArrayList<TextComponent> arrayList = new ArrayList<TextComponent>();
        int n = 0;
        for (TextComponent textComponent2 : list) {
            TextComponent[] textComponentArray;
            if (n > 2) {
                textComponentArray = new TextComponent[arrayList.size()];
                textComponentArray = arrayList.toArray(textComponentArray);
                player.spigot().sendMessage((BaseComponent[])textComponentArray);
                arrayList = new ArrayList();
                n = 0;
            }
            textComponentArray = textComponent2.getText();
            TextComponent textComponent3 = new TextComponent(LocaleLoader.getString("JSON.Hover.AtSymbolSkills"));
            TextComponentFactory.addChild(textComponent3, (String)textComponentArray);
            if (textComponent2.getHoverEvent() != null) {
                textComponent3.setHoverEvent(textComponent2.getHoverEvent());
            }
            if (textComponent2.getClickEvent() != null) {
                textComponent3.setClickEvent(textComponent2.getClickEvent());
            }
            arrayList.add(textComponent3);
            arrayList.add(textComponent);
            ++n;
        }
        TextComponent[] textComponentArray = new TextComponent[arrayList.size()];
        textComponentArray = arrayList.toArray(textComponentArray);
        player.spigot().sendMessage((BaseComponent[])textComponentArray);
    }

    private static TextComponent getWebLinkTextComponent(McMMOWebLinks mcMMOWebLinks) {
        TextComponent textComponent;
        switch (mcMMOWebLinks) {
            case WEBSITE: {
                textComponent = new TextComponent(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextComponentFactory.addChild(textComponent, "Web");
                textComponent.setClickEvent(TextComponentFactory.getUrlClickEvent("https://www.mcmmo.org"));
                break;
            }
            case SPIGOT: {
                textComponent = new TextComponent(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextComponentFactory.addChild(textComponent, "Spigot");
                textComponent.setClickEvent(TextComponentFactory.getUrlClickEvent("http://spigot.mcmmo.org"));
                break;
            }
            case DISCORD: {
                textComponent = new TextComponent(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextComponentFactory.addChild(textComponent, "Discord");
                textComponent.setClickEvent(TextComponentFactory.getUrlClickEvent("https://discord.gg/bJ7pFS9"));
                break;
            }
            case PATREON: {
                textComponent = new TextComponent(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextComponentFactory.addChild(textComponent, "Patreon");
                textComponent.setClickEvent(TextComponentFactory.getUrlClickEvent("https://www.patreon.com/nossr50"));
                break;
            }
            case WIKI: {
                textComponent = new TextComponent(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextComponentFactory.addChild(textComponent, "Wiki");
                textComponent.setClickEvent(TextComponentFactory.getUrlClickEvent("https://www.mcmmo.org/wiki/"));
                break;
            }
            case HELP_TRANSLATE: {
                textComponent = new TextComponent(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextComponentFactory.addChild(textComponent, "Lang");
                textComponent.setClickEvent(TextComponentFactory.getUrlClickEvent("https://www.mcmmo.org/translate/"));
                break;
            }
            default: {
                textComponent = new TextComponent("NOT DEFINED");
            }
        }
        TextComponentFactory.addNewHoverComponentToTextComponent(textComponent, TextComponentFactory.getUrlHoverEvent(mcMMOWebLinks));
        textComponent.setInsertion(mcMMOWebLinks.getUrl());
        return textComponent;
    }

    private static void addChild(TextComponent textComponent, String string) {
        TextComponent textComponent2 = new TextComponent(string);
        textComponent2.setColor(ChatColor.BLUE);
        textComponent.addExtra((BaseComponent)textComponent2);
    }

    private static BaseComponent[] getUrlHoverEvent(McMMOWebLinks mcMMOWebLinks) {
        ComponentBuilder componentBuilder = new ComponentBuilder(mcMMOWebLinks.getNiceTitle());
        switch (mcMMOWebLinks) {
            case WEBSITE: {
                TextComponentFactory.addUrlHeaderHover(mcMMOWebLinks, componentBuilder);
                componentBuilder.append("\n\n").italic(false);
                componentBuilder.append(mcMMOWebLinks.getLocaleDescription()).color(ChatColor.GREEN);
                componentBuilder.append("\nDev Blogs, and information related to mcMMO can be found here").color(ChatColor.GRAY);
                break;
            }
            case SPIGOT: {
                TextComponentFactory.addUrlHeaderHover(mcMMOWebLinks, componentBuilder);
                componentBuilder.append("\n\n").italic(false);
                componentBuilder.append(mcMMOWebLinks.getLocaleDescription()).color(ChatColor.GREEN);
                componentBuilder.append("\nI post regularly in the discussion thread here!").color(ChatColor.GRAY);
                break;
            }
            case PATREON: {
                TextComponentFactory.addUrlHeaderHover(mcMMOWebLinks, componentBuilder);
                componentBuilder.append("\n\n").italic(false);
                componentBuilder.append(mcMMOWebLinks.getLocaleDescription()).color(ChatColor.GREEN);
                componentBuilder.append("\n");
                componentBuilder.append("Show support by buying me a coffee :)").italic(false).color(ChatColor.GRAY);
                break;
            }
            case WIKI: {
                TextComponentFactory.addUrlHeaderHover(mcMMOWebLinks, componentBuilder);
                componentBuilder.append("\n\n").italic(false);
                componentBuilder.append(mcMMOWebLinks.getLocaleDescription()).color(ChatColor.GREEN);
                componentBuilder.append("\n");
                componentBuilder.append("I'm looking for more wiki staff, contact me on our discord!").italic(false).color(ChatColor.DARK_GRAY);
                break;
            }
            case DISCORD: {
                TextComponentFactory.addUrlHeaderHover(mcMMOWebLinks, componentBuilder);
                componentBuilder.append("\n\n").italic(false);
                componentBuilder.append(mcMMOWebLinks.getLocaleDescription()).color(ChatColor.GREEN);
                break;
            }
            case HELP_TRANSLATE: {
                TextComponentFactory.addUrlHeaderHover(mcMMOWebLinks, componentBuilder);
                componentBuilder.append("\n\n").italic(false);
                componentBuilder.append(mcMMOWebLinks.getLocaleDescription()).color(ChatColor.GREEN);
                componentBuilder.append("\n");
                componentBuilder.append("You can use this website to help translate mcMMO into your language!\nIf you want to know more contact me in discord.").italic(false).color(ChatColor.DARK_GRAY);
            }
        }
        return componentBuilder.create();
    }

    private static void addUrlHeaderHover(McMMOWebLinks mcMMOWebLinks, ComponentBuilder componentBuilder) {
        componentBuilder.append("\n");
        componentBuilder.append(mcMMOWebLinks.getUrl()).color(ChatColor.GRAY).italic(true);
    }

    private static ClickEvent getUrlClickEvent(String string) {
        return new ClickEvent(ClickEvent.Action.OPEN_URL, string);
    }

    private static TextComponent getSubSkillTextComponent(Player player, SubSkillType subSkillType) {
        String string = subSkillType.getLocaleName();
        boolean bl = RankUtils.hasUnlockedSubskill(player, subSkillType);
        TextComponent textComponent = TextComponentFactory.initNewSkillTextComponent(player, string, subSkillType, bl);
        TextComponentFactory.addNewHoverComponentToTextComponent(textComponent, TextComponentFactory.getSubSkillHoverComponent(player, subSkillType));
        textComponent.setInsertion(string);
        return textComponent;
    }

    private static void addNewHoverComponentToTextComponent(TextComponent textComponent, BaseComponent[] baseComponentArray) {
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, baseComponentArray));
    }

    private static TextComponent getSubSkillTextComponent(Player player, AbstractSubSkill abstractSubSkill) {
        String string = abstractSubSkill.getNiceName();
        SubSkillType subSkillType = abstractSubSkill.getSubSkillType();
        boolean bl = RankUtils.hasUnlockedSubskill(player, subSkillType);
        TextComponent textComponent = TextComponentFactory.initNewSkillTextComponent(player, string, subSkillType, bl);
        TextComponentFactory.addNewHoverComponentToTextComponent(textComponent, TextComponentFactory.getSubSkillHoverComponent(player, abstractSubSkill));
        textComponent.setInsertion(string);
        return textComponent;
    }

    private static TextComponent initNewSkillTextComponent(Player player, String string, SubSkillType subSkillType, boolean bl) {
        TextComponent textComponent;
        if (bl) {
            textComponent = RankUtils.getHighestRank(subSkillType) == RankUtils.getRank(player, subSkillType) && subSkillType.getNumRanks() > 1 ? new TextComponent(LocaleLoader.getString("JSON.Hover.MaxRankSkillName", string)) : new TextComponent(LocaleLoader.getString("JSON.Hover.SkillName", string));
            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mmoinfo " + subSkillType.getNiceNameNoSpaces(subSkillType)));
        } else {
            textComponent = new TextComponent(LocaleLoader.getString("JSON.Hover.Mystery", String.valueOf(RankUtils.getUnlockLevel(subSkillType))));
            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mmoinfo ???"));
        }
        return textComponent;
    }

    private static BaseComponent[] getSubSkillHoverComponent(Player player, AbstractSubSkill abstractSubSkill) {
        return TextComponentFactory.getSubSkillHoverEventJSON(abstractSubSkill, player);
    }

    private static BaseComponent[] getSubSkillHoverComponent(Player player, SubSkillType subSkillType) {
        return TextComponentFactory.getSubSkillHoverEventJSON(subSkillType, player);
    }

    private static BaseComponent[] getSubSkillHoverEventJSON(AbstractSubSkill abstractSubSkill, Player player) {
        String string = abstractSubSkill.getNiceName();
        ChatColor chatColor = ChatColor.GOLD;
        ChatColor chatColor2 = ChatColor.BLUE;
        ChatColor chatColor3 = ChatColor.GREEN;
        ChatColor chatColor4 = ChatColor.WHITE;
        ChatColor chatColor5 = chatColor3;
        ChatColor chatColor6 = ChatColor.DARK_GRAY;
        ChatColor chatColor7 = ChatColor.BLUE;
        ChatColor chatColor8 = ChatColor.RED;
        SubSkillType subSkillType = abstractSubSkill.getSubSkillType();
        ComponentBuilder componentBuilder = TextComponentFactory.setupSkillComponentNameStyle(player, string, subSkillType, RankUtils.hasUnlockedSubskill(player, abstractSubSkill));
        if (!RankUtils.hasUnlockedSubskill(player, abstractSubSkill)) {
            TextComponentFactory.addLocked(abstractSubSkill, chatColor6, chatColor7, chatColor8, componentBuilder);
        } else {
            TextComponentFactory.addSubSkillTypeToHoverEventJSON(abstractSubSkill, componentBuilder);
            int n = RankUtils.getRank(player, abstractSubSkill);
            int n2 = 0;
            if (n < abstractSubSkill.getNumRanks() && abstractSubSkill.getNumRanks() > 0) {
                n2 = RankUtils.getRankUnlockLevel(abstractSubSkill, n + 1);
            }
            TextComponentFactory.addRanked(chatColor2, chatColor3, chatColor4, chatColor5, componentBuilder, abstractSubSkill.getNumRanks(), RankUtils.getRank(player, abstractSubSkill), n2);
            componentBuilder.append(LocaleLoader.getString("JSON.DescriptionHeader"));
            componentBuilder.append("\n").append(abstractSubSkill.getDescription()).append("\n");
            componentBuilder.append("\n").bold(false);
            componentBuilder.append("\n");
            abstractSubSkill.addStats(componentBuilder, player);
        }
        return componentBuilder.create();
    }

    private static ComponentBuilder setupSkillComponentNameStyle(Player player, String string, SubSkillType subSkillType, boolean bl) {
        ComponentBuilder componentBuilder = bl ? (RankUtils.getHighestRank(subSkillType) == RankUtils.getRank(player, subSkillType) && subSkillType.getNumRanks() > 1 ? TextComponentFactory.getNewComponentBuilder(LocaleLoader.getString("JSON.Hover.MaxRankSkillName", string)) : TextComponentFactory.getNewComponentBuilder(LocaleLoader.getString("JSON.Hover.SkillName", string))) : TextComponentFactory.getNewComponentBuilder(LocaleLoader.getString("JSON.Hover.Mystery", String.valueOf(RankUtils.getUnlockLevel(subSkillType))));
        return componentBuilder;
    }

    private static ComponentBuilder getNewComponentBuilder(String string) {
        ComponentBuilder componentBuilder = new ComponentBuilder(string);
        componentBuilder.append("\n");
        return componentBuilder;
    }

    private static void addRanked(ChatColor chatColor, ChatColor chatColor2, ChatColor chatColor3, ChatColor chatColor4, ComponentBuilder componentBuilder, int n, int n2, int n3) {
        if (n > 0) {
            componentBuilder.append(LocaleLoader.getString("JSON.Hover.Rank", String.valueOf(n2))).append("\n").bold(false).italic(false).strikethrough(false).underlined(false);
            if (n3 > n2) {
                componentBuilder.append(LocaleLoader.getString("JSON.Hover.NextRank", String.valueOf(n3))).append("\n").bold(false).italic(false).strikethrough(false).underlined(false);
            }
        }
    }

    private static void addLocked(SubSkillType subSkillType, ChatColor chatColor, ChatColor chatColor2, ChatColor chatColor3, ComponentBuilder componentBuilder) {
        TextComponentFactory.addLocked(chatColor, chatColor2, componentBuilder);
        componentBuilder.append(String.valueOf(RankConfig.getInstance().getSubSkillUnlockLevel(subSkillType, 1))).color(chatColor3);
    }

    private static void addLocked(AbstractSubSkill abstractSubSkill, ChatColor chatColor, ChatColor chatColor2, ChatColor chatColor3, ComponentBuilder componentBuilder) {
        TextComponentFactory.addLocked(chatColor, chatColor2, componentBuilder);
        componentBuilder.append(String.valueOf(RankConfig.getInstance().getSubSkillUnlockLevel(abstractSubSkill, 1))).color(chatColor3);
    }

    private static void addLocked(ChatColor chatColor, ChatColor chatColor2, ComponentBuilder componentBuilder) {
        componentBuilder.append(LocaleLoader.getString("JSON.Locked")).color(chatColor).bold(true);
        componentBuilder.append("\n").append("\n").bold(false);
        componentBuilder.append(LocaleLoader.getString("JSON.LevelRequirement") + ": ").color(chatColor2);
    }

    @Deprecated
    private static BaseComponent[] getSubSkillHoverEventJSON(SubSkillType subSkillType, Player player) {
        String string = subSkillType.getLocaleName();
        ChatColor chatColor = ChatColor.GOLD;
        ChatColor chatColor2 = ChatColor.BLUE;
        ChatColor chatColor3 = ChatColor.GREEN;
        ChatColor chatColor4 = ChatColor.WHITE;
        ChatColor chatColor5 = chatColor3;
        ChatColor chatColor6 = ChatColor.DARK_PURPLE;
        ChatColor chatColor7 = ChatColor.DARK_GRAY;
        ChatColor chatColor8 = ChatColor.DARK_GRAY;
        ChatColor chatColor9 = ChatColor.BLUE;
        ChatColor chatColor10 = ChatColor.RED;
        ComponentBuilder componentBuilder = TextComponentFactory.setupSkillComponentNameStyle(player, string, subSkillType, RankUtils.hasUnlockedSubskill(player, subSkillType));
        if (!RankUtils.hasUnlockedSubskill(player, subSkillType)) {
            TextComponentFactory.addLocked(subSkillType, chatColor8, chatColor9, chatColor10, componentBuilder);
        } else {
            if (subSkillType.getNumRanks() > 0) {
                int n = RankUtils.getRank(player, subSkillType);
                int n2 = 0;
                if (n < subSkillType.getNumRanks() && subSkillType.getNumRanks() > 0) {
                    n2 = RankUtils.getRankUnlockLevel(subSkillType, n + 1);
                }
                TextComponentFactory.addRanked(chatColor2, chatColor3, chatColor4, chatColor5, componentBuilder, subSkillType.getNumRanks(), RankUtils.getRank(player, subSkillType), n2);
            }
            componentBuilder.append("\n").bold(false);
            componentBuilder.append(LocaleLoader.getString("JSON.DescriptionHeader"));
            componentBuilder.color(chatColor6);
            componentBuilder.append("\n");
            componentBuilder.append(subSkillType.getLocaleDescription());
            componentBuilder.color(chatColor7);
        }
        return componentBuilder.create();
    }

    private static void addSubSkillTypeToHoverEventJSON(AbstractSubSkill abstractSubSkill, ComponentBuilder componentBuilder) {
        if (abstractSubSkill.isSuperAbility()) {
            componentBuilder.append(LocaleLoader.getString("JSON.Type.SuperAbility")).color(ChatColor.LIGHT_PURPLE);
            componentBuilder.bold(true);
        } else if (abstractSubSkill.isActiveUse()) {
            componentBuilder.append(LocaleLoader.getString("JSON.Type.Active")).color(ChatColor.DARK_RED);
            componentBuilder.bold(true);
        } else {
            componentBuilder.append(LocaleLoader.getString("JSON.Type.Passive")).color(ChatColor.GREEN);
            componentBuilder.bold(true);
        }
        componentBuilder.append("\n");
    }

    public static void getSubSkillTextComponents(Player player, List<TextComponent> list, PrimarySkillType primarySkillType) {
        for (SubSkillType subSkillType : SubSkillType.values()) {
            if (subSkillType.getParentSkill() != primarySkillType || !Permissions.isSubSkillEnabled((Permissible)player, subSkillType) || InteractionManager.hasSubSkill(subSkillType)) continue;
            list.add(TextComponentFactory.getSubSkillTextComponent(player, subSkillType));
        }
        for (AbstractSubSkill abstractSubSkill : InteractionManager.getSubSkillList()) {
            if (abstractSubSkill.getPrimarySkill() != primarySkillType || !Permissions.isSubSkillEnabled((Permissible)player, abstractSubSkill)) continue;
            list.add(TextComponentFactory.getSubSkillTextComponent(player, abstractSubSkill));
        }
    }

    public static TextComponent getSubSkillUnlockedNotificationComponents(Player player, SubSkillType subSkillType) {
        TextComponent textComponent = new TextComponent("");
        textComponent.setText(LocaleLoader.getString("JSON.SkillUnlockMessage", subSkillType.getLocaleName(), RankUtils.getRank(player, subSkillType)));
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponentFactory.getSubSkillHoverComponent(player, subSkillType)));
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + subSkillType.getParentSkill().toString().toLowerCase()));
        return textComponent;
    }
}

