/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import org.bukkit.Material;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;

public class StringUtils {
    public static String getCapitalized(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String getPrettyItemString(Material material) {
        return StringUtils.createPrettyString(material.toString());
    }

    public static String getPrettyEntityTypeString(EntityType entityType) {
        return StringUtils.createPrettyString(entityType.toString());
    }

    public static String getPrettyAbilityString(SuperAbilityType superAbilityType) {
        return StringUtils.createPrettyString(superAbilityType.toString());
    }

    public static String getWildcardConfigBlockDataString(BlockData blockData) {
        return StringUtils.getWildcardConfigMaterialString(blockData.getMaterial());
    }

    public static String getWildcardConfigMaterialString(Material material) {
        return StringUtils.getPrettyItemString(material).replace(" ", "_") + "|*";
    }

    public static String getFriendlyConfigBlockDataString(BlockData blockData) {
        switch (blockData.getMaterial()) {
            case CHORUS_FLOWER: 
            case COCOA: 
            case WHEAT: 
            case BEETROOTS: 
            case CARROTS: 
            case POTATOES: 
            case NETHER_WART: {
                Ageable ageable;
                if (blockData instanceof Ageable && (ageable = (Ageable)blockData).getAge() == ageable.getMaximumAge()) {
                    return StringUtils.getPrettyItemString(blockData.getMaterial()).replace(" ", "_") + "_Ripe";
                }
                return StringUtils.getPrettyItemString(blockData.getMaterial()).replace(" ", "_") + "_Ungrown";
            }
        }
        return StringUtils.getPrettyItemString(blockData.getMaterial()).replace(" ", "_");
    }

    public static String getFriendlyConfigMaterialString(Material material) {
        return StringUtils.getPrettyItemString(material).replace(" ", "_");
    }

    public static String getExplicitConfigBlockDataString(BlockData blockData) {
        return StringUtils.getExplicitConfigMaterialString(blockData.getMaterial());
    }

    public static String getExplicitConfigMaterialString(Material material) {
        return StringUtils.getPrettyItemString(material).replace(" ", "_");
    }

    public static String getPrettyPartyFeatureString(PartyFeature partyFeature) {
        return StringUtils.createPrettyString(partyFeature.toString());
    }

    private static String createPrettyString(String string) {
        String[] stringArray = string.split("_");
        String string2 = "";
        int n = 1;
        for (String string3 : stringArray) {
            string2 = string2.concat(StringUtils.getCapitalized(string3));
            if (n < stringArray.length) {
                string2 = string2.concat(" ");
            }
            ++n;
        }
        return string2;
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

