/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.HardcoreManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.PerksUtils;
import java.text.DecimalFormat;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.PluginDescriptionFile;

public final class Motd {
    public static final String PERK_PREFIX = LocaleLoader.getString("MOTD.PerksPrefix") + " ";
    private static final PluginDescriptionFile pluginDescription = mcMMO.p.getDescription();

    private Motd() {
    }

    public static void displayAll(Player player) {
        Motd.displayVersion(player, pluginDescription.getVersion());
        Motd.displayHardcoreSettings(player);
        Motd.displayXpPerks(player);
        Motd.displayCooldownPerks(player);
        Motd.displayActivationPerks(player);
        Motd.displayLuckyPerks(player);
        Motd.displayWebsite(player, pluginDescription.getWebsite());
    }

    public static void displayVersion(Player player, String string) {
        if (Permissions.showversion((Permissible)player)) {
            player.sendMessage(LocaleLoader.getString("MOTD.Version.Overhaul", string));
        }
    }

    public static void displayHardcoreSettings(Player player) {
        boolean bl = HardcoreManager.isStatLossEnabled();
        boolean bl2 = HardcoreManager.isVampirismEnabled();
        if (!bl && !bl2) {
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        if (bl) {
            string = LocaleLoader.getString("Hardcore.DeathStatLoss.Name");
        }
        if (bl2) {
            string2 = LocaleLoader.getString("Hardcore.Vampirism.Name");
        }
        if (bl && bl2) {
            string3 = " & ";
        }
        player.sendMessage(LocaleLoader.getString("MOTD.Hardcore.Enabled", string + string3 + string2));
        if (bl) {
            player.sendMessage(LocaleLoader.getString("MOTD.Hardcore.DeathStatLoss.Stats", Config.getInstance().getHardcoreDeathStatPenaltyPercentage()));
        }
        if (bl2) {
            player.sendMessage(LocaleLoader.getString("MOTD.Hardcore.Vampirism.Stats", Config.getInstance().getHardcoreVampirismStatLeechPercentage()));
        }
    }

    public static void displayXpPerks(Player player) {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (!(PerksUtils.handleXpPerks(player, 1.0f, primarySkillType) > 1.0f)) continue;
            player.sendMessage(PERK_PREFIX + LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Perks.XP.Name"), LocaleLoader.getString("Perks.XP.Desc")));
            return;
        }
    }

    public static void displayCooldownPerks(Player player) {
        double d = 1.0 - (double)PerksUtils.handleCooldownPerks(player, 12) / 12.0;
        if (d > 0.0) {
            DecimalFormat decimalFormat = new DecimalFormat("##0.00%");
            player.sendMessage(PERK_PREFIX + LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Perks.Cooldowns.Name"), LocaleLoader.getString("Perks.Cooldowns.Desc", decimalFormat.format(d))));
        }
    }

    public static void displayActivationPerks(Player player) {
        int n = PerksUtils.handleActivationPerks(player, 0, 0);
        if (n > 0) {
            player.sendMessage(PERK_PREFIX + LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Perks.ActivationTime.Name"), LocaleLoader.getString("Perks.ActivationTime.Desc", n)));
        }
    }

    public static void displayLuckyPerks(Player player) {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (!Permissions.lucky((Permissible)player, primarySkillType)) continue;
            player.sendMessage(PERK_PREFIX + LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Perks.Lucky.Name"), LocaleLoader.getString("Perks.Lucky.Desc.Login")));
            return;
        }
    }

    public static void displayWebsite(Player player, String string) {
        player.sendMessage(LocaleLoader.getString("MOTD.Website", string));
    }
}

