/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.mods.CustomArmorConfig;
import com.gmail.nossr50.config.mods.CustomBlockConfig;
import com.gmail.nossr50.config.mods.CustomEntityConfig;
import com.gmail.nossr50.config.mods.CustomToolConfig;
import com.gmail.nossr50.datatypes.mods.CustomBlock;
import com.gmail.nossr50.datatypes.mods.CustomEntity;
import com.gmail.nossr50.datatypes.mods.CustomTool;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class ModManager {
    private List<Repairable> repairables = new ArrayList<Repairable>();
    private List<Material> customBoots = new ArrayList<Material>();
    private List<Material> customChestplates = new ArrayList<Material>();
    private List<Material> customHelmets = new ArrayList<Material>();
    private List<Material> customLeggings = new ArrayList<Material>();
    private List<Material> customExcavationBlocks = new ArrayList<Material>();
    private List<Material> customHerbalismBlocks = new ArrayList<Material>();
    private List<Material> customMiningBlocks = new ArrayList<Material>();
    private List<Material> customOres = new ArrayList<Material>();
    private List<Material> customLogs = new ArrayList<Material>();
    private List<Material> customLeaves = new ArrayList<Material>();
    private List<Material> customAbilityBlocks = new ArrayList<Material>();
    private HashMap<Material, CustomBlock> customBlockMap = new HashMap();
    private HashMap<String, CustomEntity> customEntityClassMap = new HashMap();
    private HashMap<String, CustomEntity> customEntityTypeMap = new HashMap();
    private List<Material> customAxes = new ArrayList<Material>();
    private List<Material> customBows = new ArrayList<Material>();
    private List<Material> customHoes = new ArrayList<Material>();
    private List<Material> customPickaxes = new ArrayList<Material>();
    private List<Material> customShovels = new ArrayList<Material>();
    private List<Material> customSwords = new ArrayList<Material>();
    private HashMap<Material, CustomTool> customToolMap = new HashMap();

    public void registerCustomArmor(CustomArmorConfig customArmorConfig) {
        this.customBoots.addAll(customArmorConfig.customBoots);
        this.customChestplates.addAll(customArmorConfig.customChestplates);
        this.customHelmets.addAll(customArmorConfig.customHelmets);
        this.customLeggings.addAll(customArmorConfig.customLeggings);
        this.repairables.addAll(customArmorConfig.repairables);
    }

    public void registerCustomBlocks(CustomBlockConfig customBlockConfig) {
        this.customExcavationBlocks.addAll(customBlockConfig.customExcavationBlocks);
        this.customHerbalismBlocks.addAll(customBlockConfig.customHerbalismBlocks);
        this.customMiningBlocks.addAll(customBlockConfig.customMiningBlocks);
        this.customOres.addAll(customBlockConfig.customOres);
        this.customLogs.addAll(customBlockConfig.customLogs);
        this.customLeaves.addAll(customBlockConfig.customLeaves);
        this.customAbilityBlocks.addAll(customBlockConfig.customAbilityBlocks);
        this.customBlockMap.putAll(customBlockConfig.customBlockMap);
    }

    public void registerCustomEntities(CustomEntityConfig customEntityConfig) {
        this.customEntityClassMap.putAll(customEntityConfig.customEntityClassMap);
        this.customEntityTypeMap.putAll(customEntityConfig.customEntityTypeMap);
    }

    public void registerCustomTools(CustomToolConfig customToolConfig) {
        this.customAxes.addAll(customToolConfig.customAxes);
        this.customBows.addAll(customToolConfig.customBows);
        this.customHoes.addAll(customToolConfig.customHoes);
        this.customPickaxes.addAll(customToolConfig.customPickaxes);
        this.customShovels.addAll(customToolConfig.customShovels);
        this.customSwords.addAll(customToolConfig.customSwords);
        this.customToolMap.putAll(customToolConfig.customToolMap);
        this.repairables.addAll(customToolConfig.repairables);
    }

    public boolean isCustomBoots(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customBoots.contains(material);
    }

    public boolean isCustomChestplate(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customChestplates.contains(material);
    }

    public boolean isCustomHelmet(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customHelmets.contains(material);
    }

    public boolean isCustomLeggings(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customLeggings.contains(material);
    }

    public boolean isCustomAxe(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customAxes.contains(material);
    }

    public boolean isCustomBow(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customBows.contains(material);
    }

    public boolean isCustomHoe(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customHoes.contains(material);
    }

    public boolean isCustomPickaxe(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customPickaxes.contains(material);
    }

    public boolean isCustomShovel(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customShovels.contains(material);
    }

    public boolean isCustomSword(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customSwords.contains(material);
    }

    public boolean isCustomOre(Material material) {
        return Config.getInstance().getBlockModsEnabled() && this.customOres.contains(material);
    }

    public boolean isCustomLog(BlockState blockState) {
        return Config.getInstance().getBlockModsEnabled() && this.customLogs.contains(blockState.getType());
    }

    public boolean isCustomLeaf(BlockState blockState) {
        return Config.getInstance().getBlockModsEnabled() && this.customLeaves.contains(blockState.getType());
    }

    public boolean isCustomAbilityBlock(BlockState blockState) {
        return Config.getInstance().getBlockModsEnabled() && this.customAbilityBlocks.contains(blockState.getType());
    }

    public boolean isCustomExcavationBlock(BlockState blockState) {
        return Config.getInstance().getBlockModsEnabled() && this.customExcavationBlocks.contains(blockState.getType());
    }

    public boolean isCustomHerbalismBlock(BlockState blockState) {
        return Config.getInstance().getBlockModsEnabled() && this.customHerbalismBlocks.contains(blockState.getType());
    }

    public boolean isCustomMiningBlock(BlockState blockState) {
        return Config.getInstance().getBlockModsEnabled() && this.customMiningBlocks.contains(blockState.getType());
    }

    public CustomBlock getBlock(BlockState blockState) {
        return this.customBlockMap.get(blockState.getType());
    }

    public CustomBlock getBlock(Material material) {
        return this.customBlockMap.get(material);
    }

    public boolean isCustomTool(ItemStack itemStack) {
        return Config.getInstance().getToolModsEnabled() && itemStack != null && this.customToolMap.containsKey(itemStack.getType());
    }

    public CustomTool getTool(ItemStack itemStack) {
        return itemStack == null ? null : this.customToolMap.get(itemStack.getType());
    }

    public List<Repairable> getLoadedRepairables() {
        return this.repairables;
    }

    public boolean isCustomEntity(Entity entity) {
        if (!Config.getInstance().getEntityModsEnabled()) {
            return false;
        }
        if (this.customEntityTypeMap.containsKey(entity.getType().toString())) {
            return true;
        }
        try {
            return this.customEntityClassMap.containsKey(((Class)entity.getClass().getDeclaredField("entityClass").get(entity)).getName());
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchFieldException || exception instanceof IllegalArgumentException || exception instanceof IllegalAccessException) {
                return this.customEntityClassMap.containsKey(entity.getClass().getName());
            }
            exception.printStackTrace();
            return false;
        }
    }

    public CustomEntity getEntity(Entity entity) {
        CustomEntity customEntity = this.customEntityTypeMap.get(entity.getType().toString());
        if (customEntity == null) {
            try {
                customEntity = this.customEntityClassMap.get(((Class)entity.getClass().getDeclaredField("entityClass").get(entity)).getName());
            }
            catch (Exception exception) {
                if (exception instanceof NoSuchFieldException || exception instanceof IllegalArgumentException || exception instanceof IllegalAccessException) {
                    customEntity = this.customEntityClassMap.get(entity.getClass().getName());
                }
                exception.printStackTrace();
            }
        }
        return customEntity;
    }

    public void addCustomEntity(Entity entity) {
        if (!Config.getInstance().getEntityModsEnabled()) {
            return;
        }
        File file = new File(mcMMO.p.getDataFolder(), "mods" + File.separator + "entities.default.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        String string = entity.getType().toString();
        String string2 = string.replace(".", "_");
        if (yamlConfiguration.getKeys(false).contains(string2)) {
            return;
        }
        yamlConfiguration.set(string2 + ".XP_Multiplier", (Object)1.0);
        yamlConfiguration.set(string2 + ".Tameable", (Object)false);
        yamlConfiguration.set(string2 + ".Taming_XP", (Object)0);
        yamlConfiguration.set(string2 + ".CanBeSummoned", (Object)false);
        yamlConfiguration.set(string2 + ".COTW_Material", (Object)"");
        yamlConfiguration.set(string2 + ".COTW_Material_Data", (Object)0);
        yamlConfiguration.set(string2 + ".COTW_Material_Amount", (Object)0);
        String string3 = "";
        try {
            string3 = ((Class)entity.getClass().getDeclaredField("entityClass").get(entity)).getName();
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchFieldException || exception instanceof IllegalArgumentException || exception instanceof IllegalAccessException) {
                string3 = entity.getClass().getName();
            }
            exception.printStackTrace();
        }
        CustomEntity customEntity = new CustomEntity(1.0, false, 0, false, null, 0);
        this.customEntityTypeMap.put(string, customEntity);
        this.customEntityClassMap.put(string3, customEntity);
        try {
            yamlConfiguration.save(file);
            mcMMO.p.debug(entity.getType().toString() + " was added to the custom entities file!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

