/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.meta.OldName;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.MobHealthDisplayUpdaterTask;
import com.gmail.nossr50.util.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class MobHealthbarUtils {
    private MobHealthbarUtils() {
    }

    public static String fixDeathMessage(String string, Player player) {
        EntityDamageEvent entityDamageEvent = player.getLastDamageCause();
        String string2 = entityDamageEvent instanceof EntityDamageByEntityEvent ? StringUtils.getPrettyEntityTypeString(((EntityDamageByEntityEvent)entityDamageEvent).getDamager().getType()) : "a mob";
        return string.replaceAll("(?:\u00a7(?:[0-9A-FK-ORa-fk-or]){1}(?:[\u2764\u25a0]{1,10})){1,2}", string2);
    }

    public static void handleMobHealthbars(LivingEntity livingEntity, double d, mcMMO mcMMO2) {
        if (mcMMO.isHealthBarPluginEnabled() || !Config.getInstance().getMobHealthbarEnabled()) {
            return;
        }
        if (MobHealthbarUtils.isBoss(livingEntity)) {
            return;
        }
        String string = livingEntity.getName();
        String string2 = livingEntity.getCustomName();
        if (livingEntity.getMetadata("mcMMO_oldName").size() <= 0 && string != null) {
            livingEntity.setMetadata("mcMMO_oldName", (MetadataValue)new OldName(string, mcMMO2));
        }
        if (string2 == null) {
            string2 = "";
        } else if (string2.equalsIgnoreCase(AdvancedConfig.getInstance().getKrakenName())) {
            return;
        }
        boolean bl = livingEntity.isCustomNameVisible();
        String string3 = MobHealthbarUtils.createHealthDisplay(Config.getInstance().getMobHealthbarDefault(), livingEntity, d);
        livingEntity.setCustomName(string3);
        livingEntity.setCustomNameVisible(true);
        int n = Config.getInstance().getMobHealthbarTime();
        if (n != -1) {
            boolean bl2;
            boolean bl3 = bl2 = !ChatColor.stripColor((String)string2).equalsIgnoreCase(ChatColor.stripColor((String)string3));
            if (bl2) {
                livingEntity.setMetadata("mcMMO: Custom Name", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)string2));
                livingEntity.setMetadata("mcMMO: Name Visibility", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)bl));
            } else if (!livingEntity.hasMetadata("mcMMO: Custom Name")) {
                livingEntity.setMetadata("mcMMO: Custom Name", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)""));
                livingEntity.setMetadata("mcMMO: Name Visibility", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)false));
            }
            new MobHealthDisplayUpdaterTask(livingEntity).runTaskLater((Plugin)mcMMO.p, n * 20);
        }
    }

    private static String createHealthDisplay(MobHealthbarType mobHealthbarType, LivingEntity livingEntity, double d) {
        int n;
        String string;
        int n2;
        double d2 = livingEntity.getMaxHealth();
        double d3 = Math.max(livingEntity.getHealth() - d, 0.0);
        double d4 = d3 / d2 * 100.0;
        ChatColor chatColor = ChatColor.BLACK;
        switch (mobHealthbarType) {
            case HEARTS: {
                n2 = Math.min((int)(d2 / 2.0), 10);
                chatColor = ChatColor.DARK_RED;
                string = "\u2764";
                break;
            }
            case BAR: {
                n2 = 10;
                if (d4 >= 85.0) {
                    chatColor = ChatColor.DARK_GREEN;
                } else if (d4 >= 70.0) {
                    chatColor = ChatColor.GREEN;
                } else if (d4 >= 55.0) {
                    chatColor = ChatColor.GOLD;
                } else if (d4 >= 40.0) {
                    chatColor = ChatColor.YELLOW;
                } else if (d4 >= 25.0) {
                    chatColor = ChatColor.RED;
                } else if (d4 >= 0.0) {
                    chatColor = ChatColor.DARK_RED;
                }
                string = "\u25a0";
                break;
            }
            default: {
                return null;
            }
        }
        int n3 = (int)Math.ceil((double)n2 * (d4 / 100.0));
        int n4 = n2 - n3;
        String string2 = chatColor + "";
        for (n = 0; n < n3; ++n) {
            string2 = string2 + string;
        }
        string2 = string2 + ChatColor.GRAY;
        for (n = 0; n < n4; ++n) {
            string2 = string2 + string;
        }
        return string2;
    }

    private static boolean isBoss(LivingEntity livingEntity) {
        switch (livingEntity.getType()) {
            case ENDER_DRAGON: 
            case WITHER: {
                return true;
            }
        }
        return false;
    }
}

