/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.events.items.McMMOItemSpawnEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public final class Misc {
    private static Random random = new Random();
    public static final int TIME_CONVERSION_FACTOR = 1000;
    public static final int TICK_CONVERSION_FACTOR = 20;
    public static final int PLAYER_RESPAWN_COOLDOWN_SECONDS = 5;
    public static final double SKILL_MESSAGE_MAX_SENDING_DISTANCE = 10.0;
    public static final Set<String> modNames = ImmutableSet.of((Object)"LOTR", (Object)"BUILDCRAFT", (Object)"ENDERIO", (Object)"ENHANCEDBIOMES", (Object)"IC2", (Object)"METALLURGY", (Object[])new String[]{"FORESTRY", "GALACTICRAFT", "RAILCRAFT", "TWILIGHTFOREST", "THAUMCRAFT", "GRAVESTONEMOD", "GROWTHCRAFT", "ARCTICMOBS", "DEMONMOBS", "INFERNOMOBS", "SWAMPMOBS", "MARICULTURE", "MINESTRAPPOLATION"});

    private Misc() {
    }

    public static boolean isNPCEntityExcludingVillagers(Entity entity) {
        return !Misc.isVillager(entity) && Misc.isNPCIncludingVillagers(entity);
    }

    public static boolean isNPCClassType(Entity entity) {
        return entity instanceof NPC;
    }

    public static boolean hasNPCMetadataTag(Entity entity) {
        return entity.hasMetadata("NPC");
    }

    public static boolean isVillager(Entity entity) {
        String string = entity.getType().toString();
        return string.equalsIgnoreCase("wandering_trader") || entity instanceof Villager;
    }

    public static boolean isNPCIncludingVillagers(Entity entity) {
        return entity == null || Misc.hasNPCMetadataTag(entity) || Misc.isNPCClassType(entity) || entity.getClass().getName().equalsIgnoreCase("cofh.entity.PlayerFake");
    }

    public static boolean isNear(Location location, Location location2, double d) {
        return location.getWorld() == location2.getWorld() && (location.distanceSquared(location2) < d * d || d == 0.0);
    }

    public static Location getBlockCenter(BlockState blockState) {
        return blockState.getLocation().add(0.5, 0.5, 0.5);
    }

    public static void dropItems(Location location, Collection<ItemStack> collection) {
        for (ItemStack itemStack : collection) {
            Misc.dropItem(location, itemStack);
        }
    }

    public static void dropItems(Location location, ItemStack itemStack, int n) {
        for (int i = 0; i < n; ++i) {
            Misc.dropItem(location, itemStack);
        }
    }

    public static Item dropItem(Location location, ItemStack itemStack) {
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        McMMOItemSpawnEvent mcMMOItemSpawnEvent = new McMMOItemSpawnEvent(location, itemStack);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOItemSpawnEvent);
        if (mcMMOItemSpawnEvent.isCancelled()) {
            return null;
        }
        return location.getWorld().dropItem(location, itemStack);
    }

    public static void spawnItemsTowardsLocation(Location location, Location location2, ItemStack itemStack, int n, double d) {
        for (int i = 0; i < n; ++i) {
            Misc.spawnItemTowardsLocation(location, location2, itemStack, d);
        }
    }

    public static Item spawnItemTowardsLocation(Location location, Location location2, ItemStack itemStack, double d) {
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        ItemStack itemStack2 = itemStack.clone();
        Location location3 = location.clone();
        Location location4 = location2.clone();
        McMMOItemSpawnEvent mcMMOItemSpawnEvent = new McMMOItemSpawnEvent(location3, itemStack2);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOItemSpawnEvent);
        if (mcMMOItemSpawnEvent.isCancelled() || mcMMOItemSpawnEvent.getItemStack() == null) {
            return null;
        }
        Item item = location3.getWorld().dropItem(location3, itemStack2);
        Vector vector = location3.clone().toVector().clone();
        Vector vector2 = location4.clone().toVector().clone();
        Vector vector3 = vector2.subtract(vector).normalize();
        vector3 = vector3.multiply(d);
        item.setVelocity(vector3);
        return item;
    }

    public static void profileCleanup(String string) {
        Player player = mcMMO.p.getServer().getPlayerExact(string);
        if (player != null) {
            UserManager.remove(player);
            new PlayerProfileLoadingTask(player).runTaskLaterAsynchronously((Plugin)mcMMO.p, 1L);
        }
    }

    public static void printProgress(int n, int n2, long l) {
        if (n % n2 == 0) {
            mcMMO.p.getLogger().info(String.format("Conversion progress: %d users at %.2f users/second", n, (double)n / (double)((System.currentTimeMillis() - l) / 1000L)));
        }
    }

    public static String getModName(String string) {
        for (String string2 : modNames) {
            if (!string.contains(string2)) continue;
            return string2;
        }
        String[] stringArray = string.split("_");
        if (stringArray.length > 1) {
            return stringArray[0].toLowerCase();
        }
        return "UnknownMods";
    }

    public static Location getLocationOffset(Location location, double d) {
        double d2 = location.getBlockX();
        double d3 = location.getBlockZ();
        double d4 = d * random.nextDouble();
        d2 = random.nextBoolean() ? d2 + d4 : d2 - d4;
        d4 = d * random.nextDouble();
        d3 = random.nextBoolean() ? d3 + d4 : d3 - d4;
        return new Location(location.getWorld(), d2, location.getY(), d3);
    }

    public static Random getRandom() {
        return random;
    }
}

