/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import java.util.HashSet;
import org.bukkit.Material;

public class MaterialMapStore {
    private HashSet<String> abilityBlackList = new HashSet();
    private HashSet<String> toolBlackList = new HashSet();
    private HashSet<String> mossyWhiteList = new HashSet();
    private HashSet<String> leavesWhiteList = new HashSet();
    private HashSet<String> herbalismAbilityBlackList = new HashSet();
    private HashSet<String> blockCrackerWhiteList = new HashSet();
    private HashSet<String> canMakeShroomyWhiteList = new HashSet();
    private HashSet<String> multiBlockPlant = new HashSet();
    private HashSet<String> foodItemWhiteList = new HashSet();

    public MaterialMapStore() {
        this.fillHardcodedHashSets();
    }

    public boolean isMultiBlockPlant(Material material) {
        return this.multiBlockPlant.contains(material.getKey().getKey());
    }

    public boolean isAbilityActivationBlackListed(Material material) {
        return this.abilityBlackList.contains(material.getKey().getKey());
    }

    public boolean isToolActivationBlackListed(Material material) {
        return this.toolBlackList.contains(material.getKey().getKey());
    }

    public boolean isMossyWhiteListed(Material material) {
        return this.mossyWhiteList.contains(material.getKey().getKey());
    }

    public boolean isLeavesWhiteListed(Material material) {
        return this.leavesWhiteList.contains(material.getKey().getKey());
    }

    public boolean isHerbalismAbilityWhiteListed(Material material) {
        return this.herbalismAbilityBlackList.contains(material.getKey().getKey());
    }

    public boolean isBlockCrackerWhiteListed(Material material) {
        return this.blockCrackerWhiteList.contains(material.getKey().getKey());
    }

    public boolean isShroomyWhiteListed(Material material) {
        return this.canMakeShroomyWhiteList.contains(material.getKey().getKey());
    }

    private void fillHardcodedHashSets() {
        this.fillAbilityBlackList();
        this.fillToolBlackList();
        this.fillMossyWhiteList();
        this.fillLeavesWhiteList();
        this.fillHerbalismAbilityBlackList();
        this.fillBlockCrackerWhiteList();
        this.fillShroomyWhiteList();
        this.fillMultiBlockPlantSet();
        this.fillFoodWhiteList();
    }

    private void fillFoodWhiteList() {
        this.foodItemWhiteList.add("apple");
        this.foodItemWhiteList.add("baked_potato");
        this.foodItemWhiteList.add("beetroot");
        this.foodItemWhiteList.add("beetroot_soup");
        this.foodItemWhiteList.add("bread");
        this.foodItemWhiteList.add("cake");
        this.foodItemWhiteList.add("carrot");
        this.foodItemWhiteList.add("chorus_fruit");
        this.foodItemWhiteList.add("cooked_chicken");
        this.foodItemWhiteList.add("cooked_cod");
        this.foodItemWhiteList.add("cooked_mutton");
        this.foodItemWhiteList.add("cooked_porkchop");
        this.foodItemWhiteList.add("cooked_rabbit");
        this.foodItemWhiteList.add("cooked_salmon");
        this.foodItemWhiteList.add("cookie");
        this.foodItemWhiteList.add("dried_kelp");
        this.foodItemWhiteList.add("golden_apple");
        this.foodItemWhiteList.add("enchanted_golden_apple");
        this.foodItemWhiteList.add("golden_carrot");
        this.foodItemWhiteList.add("melon_slice");
        this.foodItemWhiteList.add("mushroom_stew");
        this.foodItemWhiteList.add("poisonous_potato");
        this.foodItemWhiteList.add("potato");
        this.foodItemWhiteList.add("pumpkin_pie");
        this.foodItemWhiteList.add("rabbit_stew");
        this.foodItemWhiteList.add("raw_beef");
        this.foodItemWhiteList.add("raw_chicken");
        this.foodItemWhiteList.add("raw_cod");
        this.foodItemWhiteList.add("raw_mutton");
        this.foodItemWhiteList.add("raw_porkchop");
        this.foodItemWhiteList.add("raw_rabbit");
        this.foodItemWhiteList.add("raw_salmon");
        this.foodItemWhiteList.add("rotten_flesh");
        this.foodItemWhiteList.add("suspicious_stew");
        this.foodItemWhiteList.add("sweet_berries");
        this.foodItemWhiteList.add("tropical_fish");
    }

    public boolean isFood(Material material) {
        return this.foodItemWhiteList.contains(material.getKey().getKey());
    }

    private void fillMultiBlockPlantSet() {
        this.multiBlockPlant.add("cactus");
        this.multiBlockPlant.add("chorus_plant");
        this.multiBlockPlant.add("chorus_flower");
        this.multiBlockPlant.add("sugar_cane");
        this.multiBlockPlant.add("kelp_plant");
        this.multiBlockPlant.add("kelp");
        this.multiBlockPlant.add("tall_seagrass");
        this.multiBlockPlant.add("large_fern");
        this.multiBlockPlant.add("tall_grass");
        this.multiBlockPlant.add("bamboo");
    }

    private void fillShroomyWhiteList() {
        this.canMakeShroomyWhiteList.add("dirt");
        this.canMakeShroomyWhiteList.add("grass");
        this.canMakeShroomyWhiteList.add("grass_path");
    }

    private void fillBlockCrackerWhiteList() {
        this.blockCrackerWhiteList.add("stone_bricks");
    }

    private void fillHerbalismAbilityBlackList() {
        this.herbalismAbilityBlackList.add("dirt");
        this.herbalismAbilityBlackList.add("grass");
        this.herbalismAbilityBlackList.add("grass_path");
        this.herbalismAbilityBlackList.add("farmland");
    }

    private void fillLeavesWhiteList() {
        this.leavesWhiteList.add("oak_leaves");
        this.leavesWhiteList.add("acacia_leaves");
        this.leavesWhiteList.add("birch_leaves");
        this.leavesWhiteList.add("dark_oak_leaves");
        this.leavesWhiteList.add("jungle_leaves");
        this.leavesWhiteList.add("spruce_leaves");
    }

    private void fillMossyWhiteList() {
        this.mossyWhiteList.add("cobblestone");
        this.mossyWhiteList.add("dirt");
        this.mossyWhiteList.add("grass_path");
        this.mossyWhiteList.add("stone_bricks");
        this.mossyWhiteList.add("cobblestone_wall");
    }

    private void fillAbilityBlackList() {
        this.abilityBlackList.add("black_bed");
        this.abilityBlackList.add("blue_bed");
        this.abilityBlackList.add("brown_bed");
        this.abilityBlackList.add("cyan_bed");
        this.abilityBlackList.add("gray_bed");
        this.abilityBlackList.add("green_bed");
        this.abilityBlackList.add("light_blue_bed");
        this.abilityBlackList.add("light_gray_bed");
        this.abilityBlackList.add("lime_bed");
        this.abilityBlackList.add("magenta_bed");
        this.abilityBlackList.add("orange_bed");
        this.abilityBlackList.add("pink_bed");
        this.abilityBlackList.add("purple_bed");
        this.abilityBlackList.add("red_bed");
        this.abilityBlackList.add("white_bed");
        this.abilityBlackList.add("yellow_bed");
        this.abilityBlackList.add("brewing_stand");
        this.abilityBlackList.add("bookshelf");
        this.abilityBlackList.add("cake");
        this.abilityBlackList.add("chest");
        this.abilityBlackList.add("dispenser");
        this.abilityBlackList.add("enchanting_table");
        this.abilityBlackList.add("ender_chest");
        this.abilityBlackList.add("oak_fence_gate");
        this.abilityBlackList.add("acacia_fence_gate");
        this.abilityBlackList.add("dark_oak_fence_gate");
        this.abilityBlackList.add("spruce_fence_gate");
        this.abilityBlackList.add("birch_fence_gate");
        this.abilityBlackList.add("jungle_fence_gate");
        this.abilityBlackList.add("furnace");
        this.abilityBlackList.add("jukebox");
        this.abilityBlackList.add("lever");
        this.abilityBlackList.add("note_block");
        this.abilityBlackList.add("stone_button");
        this.abilityBlackList.add("oak_button");
        this.abilityBlackList.add("birch_button");
        this.abilityBlackList.add("acacia_button");
        this.abilityBlackList.add("dark_oak_button");
        this.abilityBlackList.add("jungle_button");
        this.abilityBlackList.add("spruce_button");
        this.abilityBlackList.add("acacia_trapdoor");
        this.abilityBlackList.add("birch_trapdoor");
        this.abilityBlackList.add("dark_oak_trapdoor");
        this.abilityBlackList.add("jungle_trapdoor");
        this.abilityBlackList.add("oak_trapdoor");
        this.abilityBlackList.add("spruce_trapdoor");
        this.abilityBlackList.add("acacia_sign");
        this.abilityBlackList.add("acacia_wall_sign");
        this.abilityBlackList.add("birch_sign");
        this.abilityBlackList.add("birch_wall_sign");
        this.abilityBlackList.add("dark_oak_sign");
        this.abilityBlackList.add("dark_oak_wall_sign");
        this.abilityBlackList.add("jungle_sign");
        this.abilityBlackList.add("jungle_wall_sign");
        this.abilityBlackList.add("spruce_sign");
        this.abilityBlackList.add("spruce_wall_sign");
        this.abilityBlackList.add("oak_sign");
        this.abilityBlackList.add("oak_wall_sign");
        this.abilityBlackList.add("crafting_table");
        this.abilityBlackList.add("beacon");
        this.abilityBlackList.add("anvil");
        this.abilityBlackList.add("dropper");
        this.abilityBlackList.add("hopper");
        this.abilityBlackList.add("trapped_chest");
        this.abilityBlackList.add("iron_door");
        this.abilityBlackList.add("iron_trapdoor");
        this.abilityBlackList.add("oak_door");
        this.abilityBlackList.add("acacia_door");
        this.abilityBlackList.add("spruce_door");
        this.abilityBlackList.add("birch_door");
        this.abilityBlackList.add("jungle_door");
        this.abilityBlackList.add("dark_oak_door");
        this.abilityBlackList.add("oak_fence");
        this.abilityBlackList.add("acacia_fence");
        this.abilityBlackList.add("dark_oak_fence");
        this.abilityBlackList.add("birch_fence");
        this.abilityBlackList.add("jungle_fence");
        this.abilityBlackList.add("spruce_fence");
        this.abilityBlackList.add("armor_stand");
        this.abilityBlackList.add("black_shulker_box");
        this.abilityBlackList.add("blue_shulker_box");
        this.abilityBlackList.add("brown_shulker_box");
        this.abilityBlackList.add("cyan_shulker_box");
        this.abilityBlackList.add("gray_shulker_box");
        this.abilityBlackList.add("green_shulker_box");
        this.abilityBlackList.add("light_blue_shulker_box");
        this.abilityBlackList.add("lime_shulker_box");
        this.abilityBlackList.add("magenta_shulker_box");
        this.abilityBlackList.add("orange_shulker_box");
        this.abilityBlackList.add("pink_shulker_box");
        this.abilityBlackList.add("purple_shulker_box");
        this.abilityBlackList.add("red_shulker_box");
        this.abilityBlackList.add("light_gray_shulker_box");
        this.abilityBlackList.add("white_shulker_box");
        this.abilityBlackList.add("yellow_shulker_box");
        this.abilityBlackList.add("shulker_box");
        this.abilityBlackList.add("wall_sign");
        this.abilityBlackList.add("sign");
        this.abilityBlackList.add("cartography_table");
        this.abilityBlackList.add("grindstone");
        this.abilityBlackList.add("lectern");
        this.abilityBlackList.add("loom");
        this.abilityBlackList.add("scaffolding");
        this.abilityBlackList.add("smoker");
        this.abilityBlackList.add("stonecutter");
        this.abilityBlackList.add("sweet_berry_bush");
    }

    private void fillToolBlackList() {
        this.toolBlackList.add("black_bed");
        this.toolBlackList.add("blue_bed");
        this.toolBlackList.add("brown_bed");
        this.toolBlackList.add("cyan_bed");
        this.toolBlackList.add("gray_bed");
        this.toolBlackList.add("green_bed");
        this.toolBlackList.add("light_blue_bed");
        this.toolBlackList.add("light_gray_bed");
        this.toolBlackList.add("lime_bed");
        this.toolBlackList.add("magenta_bed");
        this.toolBlackList.add("orange_bed");
        this.toolBlackList.add("pink_bed");
        this.toolBlackList.add("purple_bed");
        this.toolBlackList.add("red_bed");
        this.toolBlackList.add("white_bed");
        this.toolBlackList.add("yellow_bed");
        this.toolBlackList.add("brewing_stand");
        this.toolBlackList.add("bookshelf");
        this.toolBlackList.add("cake");
        this.toolBlackList.add("chest");
        this.toolBlackList.add("dispenser");
        this.toolBlackList.add("enchanting_table");
        this.toolBlackList.add("ender_chest");
        this.toolBlackList.add("oak_fence_gate");
        this.toolBlackList.add("acacia_fence_gate");
        this.toolBlackList.add("dark_oak_fence_gate");
        this.toolBlackList.add("spruce_fence_gate");
        this.toolBlackList.add("birch_fence_gate");
        this.toolBlackList.add("jungle_fence_gate");
        this.toolBlackList.add("furnace");
        this.toolBlackList.add("jukebox");
        this.toolBlackList.add("lever");
        this.toolBlackList.add("note_block");
        this.toolBlackList.add("stone_button");
        this.toolBlackList.add("oak_button");
        this.toolBlackList.add("birch_button");
        this.toolBlackList.add("acacia_button");
        this.toolBlackList.add("dark_oak_button");
        this.toolBlackList.add("jungle_button");
        this.toolBlackList.add("spruce_button");
        this.toolBlackList.add("acacia_trapdoor");
        this.toolBlackList.add("birch_trapdoor");
        this.toolBlackList.add("dark_oak_trapdoor");
        this.toolBlackList.add("jungle_trapdoor");
        this.toolBlackList.add("oak_trapdoor");
        this.toolBlackList.add("spruce_trapdoor");
        this.toolBlackList.add("crafting_table");
        this.toolBlackList.add("beacon");
        this.toolBlackList.add("anvil");
        this.toolBlackList.add("dropper");
        this.toolBlackList.add("hopper");
        this.toolBlackList.add("trapped_chest");
        this.toolBlackList.add("iron_door");
        this.toolBlackList.add("iron_trapdoor");
        this.toolBlackList.add("oak_door");
        this.toolBlackList.add("acacia_door");
        this.toolBlackList.add("spruce_door");
        this.toolBlackList.add("birch_door");
        this.toolBlackList.add("jungle_door");
        this.toolBlackList.add("dark_oak_door");
        this.toolBlackList.add("oak_fence");
        this.toolBlackList.add("acacia_fence");
        this.toolBlackList.add("dark_oak_fence");
        this.toolBlackList.add("birch_fence");
        this.toolBlackList.add("jungle_fence");
        this.toolBlackList.add("spruce_fence");
        this.toolBlackList.add("armor_stand");
        this.toolBlackList.add("black_shulker_box");
        this.toolBlackList.add("blue_shulker_box");
        this.toolBlackList.add("brown_shulker_box");
        this.toolBlackList.add("cyan_shulker_box");
        this.toolBlackList.add("gray_shulker_box");
        this.toolBlackList.add("green_shulker_box");
        this.toolBlackList.add("light_blue_shulker_box");
        this.toolBlackList.add("lime_shulker_box");
        this.toolBlackList.add("magenta_shulker_box");
        this.toolBlackList.add("orange_shulker_box");
        this.toolBlackList.add("pink_shulker_box");
        this.toolBlackList.add("purple_shulker_box");
        this.toolBlackList.add("red_shulker_box");
        this.toolBlackList.add("light_gray_shulker_box");
        this.toolBlackList.add("white_shulker_box");
        this.toolBlackList.add("yellow_shulker_box");
        this.toolBlackList.add("shulker_box");
        this.toolBlackList.add("acacia_sign");
        this.toolBlackList.add("acacia_wall_sign");
        this.toolBlackList.add("birch_sign");
        this.toolBlackList.add("birch_wall_sign");
        this.toolBlackList.add("dark_oak_sign");
        this.toolBlackList.add("dark_oak_wall_sign");
        this.toolBlackList.add("jungle_sign");
        this.toolBlackList.add("jungle_wall_sign");
        this.toolBlackList.add("spruce_sign");
        this.toolBlackList.add("spruce_wall_sign");
        this.toolBlackList.add("oak_sign");
        this.toolBlackList.add("oak_wall_sign");
        this.toolBlackList.add("stripped_acacia_log");
        this.toolBlackList.add("stripped_acacia_wood");
        this.toolBlackList.add("stripped_birch_log");
        this.toolBlackList.add("stripped_birch_wood");
        this.toolBlackList.add("stripped_dark_oak_log");
        this.toolBlackList.add("stripped_dark_oak_wood");
        this.toolBlackList.add("stripped_jungle_log");
        this.toolBlackList.add("stripped_jungle_wood");
        this.toolBlackList.add("stripped_oak_log");
        this.toolBlackList.add("stripped_oak_wood");
        this.toolBlackList.add("stripped_spruce_log");
        this.toolBlackList.add("stripped_spruce_wood");
        this.toolBlackList.add("acacia_log");
        this.toolBlackList.add("acacia_wood");
        this.toolBlackList.add("birch_log");
        this.toolBlackList.add("birch_wood");
        this.toolBlackList.add("dark_oak_log");
        this.toolBlackList.add("dark_oak_wood");
        this.toolBlackList.add("jungle_log");
        this.toolBlackList.add("jungle_wood");
        this.toolBlackList.add("oak_log");
        this.toolBlackList.add("oak_wood");
        this.toolBlackList.add("spruce_log");
        this.toolBlackList.add("spruce_wood");
        this.toolBlackList.add("iron_block");
        this.toolBlackList.add("gold_block");
    }

    private void addToHashSet(String string, HashSet<String> hashSet) {
        hashSet.add(string.toLowerCase());
    }
}

