/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.party.ItemWeightConfig;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.MaterialUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;

public final class ItemUtils {
    private ItemUtils() {
    }

    public static boolean isBow(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case BOW: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomBow(material);
    }

    public static boolean hasItemInEitherHand(Player player, Material material) {
        return player.getInventory().getItemInMainHand().getType() == material || player.getInventory().getItemInOffHand().getType() == material;
    }

    public static boolean isSword(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_SWORD: 
            case GOLDEN_SWORD: 
            case IRON_SWORD: 
            case STONE_SWORD: 
            case WOODEN_SWORD: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomSword(material);
    }

    public static boolean isHoe(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_HOE: 
            case GOLDEN_HOE: 
            case IRON_HOE: 
            case STONE_HOE: 
            case WOODEN_HOE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomHoe(material);
    }

    public static boolean isShovel(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_SHOVEL: 
            case GOLDEN_SHOVEL: 
            case IRON_SHOVEL: 
            case STONE_SHOVEL: 
            case WOODEN_SHOVEL: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomShovel(material);
    }

    public static boolean isAxe(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_AXE: 
            case GOLDEN_AXE: 
            case IRON_AXE: 
            case STONE_AXE: 
            case WOODEN_AXE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomAxe(material);
    }

    public static boolean isPickaxe(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_PICKAXE: 
            case GOLDEN_PICKAXE: 
            case IRON_PICKAXE: 
            case STONE_PICKAXE: 
            case WOODEN_PICKAXE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomPickaxe(material);
    }

    public static boolean isUnarmed(ItemStack itemStack) {
        if (Config.getInstance().getUnarmedItemsAsUnarmed()) {
            return !ItemUtils.isMinecraftTool(itemStack);
        }
        return itemStack.getType() == Material.AIR;
    }

    public static boolean isHelmet(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_HELMET: 
            case GOLDEN_HELMET: 
            case IRON_HELMET: 
            case CHAINMAIL_HELMET: 
            case LEATHER_HELMET: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomHelmet(material);
    }

    public static boolean isChestplate(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_CHESTPLATE: 
            case GOLDEN_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case LEATHER_CHESTPLATE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomChestplate(material);
    }

    public static boolean isLeggings(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_LEGGINGS: 
            case GOLDEN_LEGGINGS: 
            case IRON_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case LEATHER_LEGGINGS: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomLeggings(material);
    }

    public static boolean isBoots(ItemStack itemStack) {
        Material material = itemStack.getType();
        switch (material) {
            case DIAMOND_BOOTS: 
            case GOLDEN_BOOTS: 
            case IRON_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case LEATHER_BOOTS: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomBoots(material);
    }

    public static boolean isArmor(ItemStack itemStack) {
        return ItemUtils.isHelmet(itemStack) || ItemUtils.isChestplate(itemStack) || ItemUtils.isLeggings(itemStack) || ItemUtils.isBoots(itemStack);
    }

    public static boolean isMinecraftArmor(ItemStack itemStack) {
        return ItemUtils.isLeatherArmor(itemStack) || ItemUtils.isGoldArmor(itemStack) || ItemUtils.isIronArmor(itemStack) || ItemUtils.isDiamondArmor(itemStack) || ItemUtils.isChainmailArmor(itemStack);
    }

    public static boolean isLeatherArmor(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGoldArmor(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case GOLDEN_HELMET: 
            case GOLDEN_CHESTPLATE: 
            case GOLDEN_LEGGINGS: 
            case GOLDEN_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIronArmor(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case IRON_HELMET: 
            case IRON_CHESTPLATE: 
            case IRON_LEGGINGS: 
            case IRON_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDiamondArmor(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case DIAMOND_HELMET: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isChainmailArmor(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_LEGGINGS: 
            case CHAINMAIL_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMinecraftTool(ItemStack itemStack) {
        return ItemUtils.isStoneTool(itemStack) || ItemUtils.isWoodTool(itemStack) || ItemUtils.isGoldTool(itemStack) || ItemUtils.isIronTool(itemStack) || ItemUtils.isDiamondTool(itemStack) || ItemUtils.isStringTool(itemStack) || itemStack.getType() == Material.TRIDENT;
    }

    public static boolean isStoneTool(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case STONE_SWORD: 
            case STONE_HOE: 
            case STONE_SHOVEL: 
            case STONE_AXE: 
            case STONE_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWoodTool(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case WOODEN_SWORD: 
            case WOODEN_HOE: 
            case WOODEN_SHOVEL: 
            case WOODEN_AXE: 
            case WOODEN_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringTool(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case BOW: 
            case CARROT_ON_A_STICK: 
            case FISHING_ROD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGoldTool(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case GOLDEN_SWORD: 
            case GOLDEN_HOE: 
            case GOLDEN_SHOVEL: 
            case GOLDEN_AXE: 
            case GOLDEN_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIronTool(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case IRON_SWORD: 
            case IRON_HOE: 
            case IRON_SHOVEL: 
            case IRON_AXE: 
            case IRON_PICKAXE: 
            case BUCKET: 
            case FLINT_AND_STEEL: 
            case SHEARS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDiamondTool(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case DIAMOND_SWORD: 
            case DIAMOND_HOE: 
            case DIAMOND_SHOVEL: 
            case DIAMOND_AXE: 
            case DIAMOND_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEnchantable(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case CARROT_ON_A_STICK: 
            case FISHING_ROD: 
            case FLINT_AND_STEEL: 
            case SHEARS: 
            case ENCHANTED_BOOK: 
            case TRIDENT: {
                return true;
            }
        }
        return ItemUtils.isArmor(itemStack) || ItemUtils.isSword(itemStack) || ItemUtils.isAxe(itemStack) || ItemUtils.isShovel(itemStack) || ItemUtils.isPickaxe(itemStack) || ItemUtils.isBow(itemStack);
    }

    public static boolean isSmeltable(ItemStack itemStack) {
        return itemStack != null && itemStack.getType().isBlock() && MaterialUtils.isOre(itemStack.getType());
    }

    public static boolean isSmelted(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (Recipe recipe : mcMMO.p.getServer().getRecipesFor(itemStack)) {
            if (!(recipe instanceof FurnaceRecipe) || !((FurnaceRecipe)recipe).getInput().getType().isBlock() || !MaterialUtils.isOre(((FurnaceRecipe)recipe).getInput().getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSharable(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return false;
        }
        return ItemUtils.isMiningDrop(itemStack) || ItemUtils.isWoodcuttingDrop(itemStack) || ItemUtils.isMobDrop(itemStack) || ItemUtils.isHerbalismDrop(itemStack) || ItemUtils.isMiscDrop(itemStack);
    }

    public static boolean isMiningDrop(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case COAL: 
            case COAL_ORE: 
            case DIAMOND: 
            case DIAMOND_ORE: 
            case EMERALD: 
            case EMERALD_ORE: 
            case GOLD_ORE: 
            case IRON_ORE: 
            case LAPIS_ORE: 
            case REDSTONE_ORE: 
            case REDSTONE: 
            case GLOWSTONE_DUST: 
            case QUARTZ: 
            case NETHER_QUARTZ_ORE: 
            case LAPIS_LAZULI: {
                return true;
            }
        }
        return false;
    }

    public static boolean isHerbalismDrop(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case WHEAT: 
            case WHEAT_SEEDS: 
            case CARROT: 
            case CHORUS_FRUIT: 
            case CHORUS_FLOWER: 
            case POTATO: 
            case BEETROOT: 
            case BEETROOT_SEEDS: 
            case NETHER_WART: 
            case BROWN_MUSHROOM: 
            case RED_MUSHROOM: 
            case ROSE_BUSH: 
            case DANDELION: 
            case CACTUS: 
            case SUGAR_CANE: 
            case MELON: 
            case MELON_SEEDS: 
            case PUMPKIN: 
            case PUMPKIN_SEEDS: 
            case LILY_PAD: 
            case VINE: 
            case TALL_GRASS: 
            case COCOA_BEANS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMobDrop(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case COAL: 
            case ROSE_BUSH: 
            case STRING: 
            case FEATHER: 
            case CHICKEN: 
            case COOKED_CHICKEN: 
            case LEATHER: 
            case BEEF: 
            case COOKED_BEEF: 
            case PORKCHOP: 
            case COOKED_PORKCHOP: 
            case WHITE_WOOL: 
            case BLACK_WOOL: 
            case BLUE_WOOL: 
            case BROWN_WOOL: 
            case CYAN_WOOL: 
            case GRAY_WOOL: 
            case GREEN_WOOL: 
            case LIGHT_BLUE_WOOL: 
            case LIGHT_GRAY_WOOL: 
            case LIME_WOOL: 
            case MAGENTA_WOOL: 
            case ORANGE_WOOL: 
            case PINK_WOOL: 
            case PURPLE_WOOL: 
            case RED_WOOL: 
            case YELLOW_WOOL: 
            case IRON_INGOT: 
            case SNOWBALL: 
            case BLAZE_ROD: 
            case SPIDER_EYE: 
            case GUNPOWDER: 
            case ENDER_PEARL: 
            case GHAST_TEAR: 
            case MAGMA_CREAM: 
            case BONE: 
            case ARROW: 
            case SLIME_BALL: 
            case NETHER_STAR: 
            case ROTTEN_FLESH: 
            case GOLD_NUGGET: 
            case EGG: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWoodcuttingDrop(ItemStack itemStack) {
        switch (itemStack.getType()) {
            case ACACIA_LOG: 
            case BIRCH_LOG: 
            case DARK_OAK_LOG: 
            case JUNGLE_LOG: 
            case OAK_LOG: 
            case SPRUCE_LOG: 
            case STRIPPED_ACACIA_LOG: 
            case STRIPPED_BIRCH_LOG: 
            case STRIPPED_DARK_OAK_LOG: 
            case STRIPPED_JUNGLE_LOG: 
            case STRIPPED_OAK_LOG: 
            case STRIPPED_SPRUCE_LOG: 
            case ACACIA_SAPLING: 
            case SPRUCE_SAPLING: 
            case BIRCH_SAPLING: 
            case DARK_OAK_SAPLING: 
            case JUNGLE_SAPLING: 
            case OAK_SAPLING: 
            case ACACIA_LEAVES: 
            case BIRCH_LEAVES: 
            case DARK_OAK_LEAVES: 
            case JUNGLE_LEAVES: 
            case OAK_LEAVES: 
            case SPRUCE_LEAVES: 
            case APPLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMiscDrop(ItemStack itemStack) {
        return ItemWeightConfig.getInstance().getMiscItems().contains(itemStack.getType());
    }

    public static boolean isMcMMOItem(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        return itemMeta.hasLore() && itemMeta.getLore().contains("mcMMO Item");
    }

    public static boolean isChimaeraWing(ItemStack itemStack) {
        if (!ItemUtils.isMcMMOItem(itemStack)) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        return itemMeta.hasDisplayName() && itemMeta.getDisplayName().equals(ChatColor.GOLD + LocaleLoader.getString("Item.ChimaeraWing.Name"));
    }
}

