/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.commands.skills.AprilCommand;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Statistic;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;

public final class HolidayManager {
    private ArrayList<String> hasCelebrated;
    private int currentYear;
    private static final int START_YEAR = 2011;
    private static final List<Color> ALL_COLORS;
    private static final List<ChatColor> ALL_CHAT_COLORS;
    private static final List<ChatColor> CHAT_FORMATS;
    public final Set<Statistic> movementStatistics = EnumSet.of(Statistic.WALK_ONE_CM, new Statistic[]{Statistic.SWIM_ONE_CM, Statistic.FALL_ONE_CM, Statistic.CLIMB_ONE_CM, Statistic.FLY_ONE_CM, Statistic.WALK_UNDER_WATER_ONE_CM, Statistic.PIG_ONE_CM});

    public HolidayManager() {
        this.currentYear = Calendar.getInstance().get(1);
        File file = new File(mcMMO.getFlatFileDirectory(), "anniversary." + this.currentYear + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                mcMMO.p.getLogger().severe(iOException.toString());
            }
        }
        this.hasCelebrated = new ArrayList();
        try {
            this.hasCelebrated.clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getPath()));
            String string = bufferedReader.readLine();
            while (string != null) {
                this.hasCelebrated.add(string);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            mcMMO.p.getLogger().severe(exception.toString());
        }
        this.cleanupFiles();
    }

    private void cleanupFiles() {
        File file = new File(mcMMO.getFlatFileDirectory());
        File file2 = new File(file, "anniversary.yml");
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file2.exists()) {
            arrayList.add(file2);
        }
        Pattern pattern = Pattern.compile("anniversary\\.(?:.+)\\.yml");
        for (String string : file.list()) {
            File file3;
            if (!pattern.matcher(string).matches() || string.equals("anniversary." + this.currentYear + ".yml") || (file3 = new File(file, string)).isDirectory()) continue;
            arrayList.add(file3);
        }
        for (File file4 : arrayList) {
            if (!file4.delete()) continue;
            mcMMO.p.debug("Deleted: " + file4.getName());
        }
    }

    public void saveAnniversaryFiles() {
        mcMMO.p.debug("Saving anniversary files...");
        String string = mcMMO.getFlatFileDirectory() + "anniversary." + this.currentYear + ".yml";
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (String string2 : this.hasCelebrated) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            mcMMO.p.getLogger().severe(exception.toString());
        }
    }

    public void anniversaryCheck(CommandSender commandSender) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.currentYear, 1, 3);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(this.currentYear, 1, 6);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        if (this.hasCelebrated.contains(commandSender.getName())) {
            return;
        }
        if (!this.getDateRange(gregorianCalendar3.getTime(), gregorianCalendar.getTime(), gregorianCalendar2.getTime())) {
            return;
        }
        commandSender.sendMessage(LocaleLoader.getString("Holiday.Anniversary", this.currentYear - 2011));
        Object[] objectArray = new Object[]{HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose(), HolidayManager.chatColorChoose()};
        commandSender.sendMessage(String.format("      %1$s.''.      %4$s.        %7$s*''*    %10$s:_\\/_:     %11$s.", objectArray));
        commandSender.sendMessage(String.format("     %1$s:_\\/_:   %4$s_\\(/_  %5$s.:.%7$s*_\\/_*   %10$s: /\\ :  %11$s.'.:.'.", objectArray));
        commandSender.sendMessage(String.format(" %2$s.''.%1$s: /\\ :    %4$s/)\\   %5$s':'%7$s* /\\ *  %9$s: %10$s'..'.  %11$s-=:o:=-", objectArray));
        commandSender.sendMessage(String.format("%2$s:_\\/_:%1$s'%3$s.:::.    %4$s' %6$s*''*    %7$s* %9$s'.\\'/.'%8$s_\\(/_ %11$s'.':'.'", objectArray));
        commandSender.sendMessage(String.format("%2$s: /\\ : %3$s:::::     %6$s*_\\/_*     %9$s-= o =-%8$s /)\\     %11$s'", objectArray));
        commandSender.sendMessage(String.format(" %2$s'..'  %3$s':::'     %6$s* /\\ *     %9$s.'/.\\'.  %8$s'      %11$s*", objectArray));
        commandSender.sendMessage(String.format("     %2$s*            %6$s*..*         %9$s:           %11$s*", objectArray));
        commandSender.sendMessage(String.format("      %2$s*                        %9$s*          %11$s*", objectArray));
        commandSender.sendMessage(String.format("      %2$s*                        %9$s*          %11$s*", objectArray));
        this.hasCelebrated.add(commandSender.getName());
    }

    public boolean getDateRange(Date date, Date date2, Date date3) {
        return !date.before(date2) && !date.after(date3);
    }

    private static List<Color> colorChoose() {
        return ALL_COLORS.subList(0, Math.max(Misc.getRandom().nextInt(ALL_COLORS.size() + 1), 1));
    }

    private static String chatColorChoose() {
        StringBuilder stringBuilder = new StringBuilder(ALL_CHAT_COLORS.get(Misc.getRandom().nextInt(ALL_CHAT_COLORS.size())).toString());
        for (ChatColor chatColor : CHAT_FORMATS) {
            if (Misc.getRandom().nextInt(CHAT_FORMATS.size()) != 0) continue;
            stringBuilder.append(chatColor);
        }
        return stringBuilder.toString();
    }

    public boolean isAprilFirst() {
        if (!Config.getInstance().isAprilFoolsAllowed()) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.currentYear, 3, 1);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(this.currentYear, 3, 2);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        return this.getDateRange(gregorianCalendar3.getTime(), gregorianCalendar.getTime(), gregorianCalendar2.getTime());
    }

    public boolean nearingAprilFirst() {
        if (!Config.getInstance().isAprilFoolsAllowed()) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Calendar.getInstance().get(1), 2, 28);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(Calendar.getInstance().get(1), 3, 2);
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        return mcMMO.getHolidayManager().getDateRange(gregorianCalendar3.getTime(), gregorianCalendar.getTime(), gregorianCalendar2.getTime());
    }

    public void handleStatisticEvent(PlayerStatisticIncrementEvent playerStatisticIncrementEvent) {
        int n;
        Player player = playerStatisticIncrementEvent.getPlayer();
        Statistic statistic = playerStatisticIncrementEvent.getStatistic();
        int n2 = playerStatisticIncrementEvent.getNewValue();
        switch (statistic) {
            case DAMAGE_TAKEN: {
                n = 500;
                break;
            }
            case JUMP: {
                n = 500;
                break;
            }
            case DROP: {
                n = 200;
                break;
            }
            case MINE_BLOCK: 
            case BREAK_ITEM: {
                n = 500;
                break;
            }
            case CRAFT_ITEM: {
                n = 100;
                break;
            }
            default: {
                return;
            }
        }
        if (n2 % n == 0) {
            mcMMO.getHolidayManager().levelUpApril(player, FakeSkillType.getByStatistic(statistic));
        }
    }

    public void levelUpApril(Player player, FakeSkillType fakeSkillType) {
        if (!Config.getInstance().isAprilFoolsAllowed()) {
            return;
        }
        int n = Misc.getRandom().nextInt(1 + UserManager.getPlayer(player).getSkillLevel(PrimarySkillType.MINING)) + 1;
        SoundManager.sendSound(player, player.getLocation(), SoundType.LEVEL_UP);
        NotificationManager.sendPlayerInformation(player, NotificationType.HOLIDAY, "Holiday.AprilFools.Levelup", StringUtils.getCapitalized(fakeSkillType.toString()), String.valueOf(n));
    }

    public void registerAprilCommand() {
        if (!Config.getInstance().isAprilFoolsAllowed()) {
            return;
        }
        PluginCommand pluginCommand = mcMMO.p.getCommand("mcfools");
        pluginCommand.setExecutor((CommandExecutor)new AprilCommand());
    }

    static {
        ArrayList arrayList = new ArrayList();
        ArrayList<ChatColor> arrayList2 = new ArrayList<ChatColor>();
        ArrayList<ChatColor> arrayList3 = new ArrayList<ChatColor>();
        for (ChatColor chatColor : ChatColor.values()) {
            if (chatColor.isColor()) {
                arrayList2.add(chatColor);
                continue;
            }
            arrayList3.add(chatColor);
        }
        Collections.shuffle(arrayList2, Misc.getRandom());
        Collections.shuffle(arrayList, Misc.getRandom());
        Collections.shuffle(arrayList3, Misc.getRandom());
        ALL_CHAT_COLORS = ImmutableList.copyOf(arrayList2);
        ALL_COLORS = ImmutableList.copyOf(arrayList);
        CHAT_FORMATS = ImmutableList.copyOf(arrayList3);
    }

    public static enum FakeSkillType {
        MACHO,
        JUMPING,
        THROWING,
        WRECKING,
        CRAFTING,
        WALKING,
        SWIMMING,
        FALLING,
        CLIMBING,
        FLYING,
        DIVING,
        PIGGY,
        UNKNOWN;


        public static FakeSkillType getByName(String string) {
            for (FakeSkillType fakeSkillType : FakeSkillType.values()) {
                if (!fakeSkillType.name().equalsIgnoreCase(string)) continue;
                return fakeSkillType;
            }
            return null;
        }

        public static FakeSkillType getByStatistic(Statistic statistic) {
            switch (statistic) {
                case DAMAGE_TAKEN: {
                    return MACHO;
                }
                case JUMP: {
                    return JUMPING;
                }
                case DROP: {
                    return THROWING;
                }
                case MINE_BLOCK: 
                case BREAK_ITEM: {
                    return WRECKING;
                }
                case CRAFT_ITEM: {
                    return CRAFTING;
                }
                case WALK_ONE_CM: {
                    return WALKING;
                }
                case SWIM_ONE_CM: {
                    return SWIMMING;
                }
                case FALL_ONE_CM: {
                    return FALLING;
                }
                case CLIMB_ONE_CM: {
                    return CLIMBING;
                }
                case FLY_ONE_CM: {
                    return FLYING;
                }
                case WALK_UNDER_WATER_ONE_CM: {
                    return DIVING;
                }
                case PIG_ONE_CM: {
                    return PIGGY;
                }
            }
            return UNKNOWN;
        }
    }
}

