/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import java.util.HashMap;
import org.bukkit.entity.Player;

public final class HardcoreManager {
    private HardcoreManager() {
    }

    public static void invokeStatPenalty(Player player) {
        if (WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasHardcoreFlag(player)) {
            return;
        }
        double d = Config.getInstance().getHardcoreDeathStatPenaltyPercentage();
        int n = Config.getInstance().getHardcoreDeathStatPenaltyLevelThreshold();
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
        int n2 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Float> hashMap2 = new HashMap<String, Float>();
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            if (!primarySkillType.getHardcoreStatLossEnabled()) {
                hashMap.put(primarySkillType.toString(), 0);
                hashMap2.put(primarySkillType.toString(), Float.valueOf(0.0f));
                continue;
            }
            int n3 = playerProfile.getSkillLevel(primarySkillType);
            int n4 = playerProfile.getSkillXpLevel(primarySkillType);
            if (n3 <= 0 || n3 <= n) {
                hashMap.put(primarySkillType.toString(), 0);
                hashMap2.put(primarySkillType.toString(), Float.valueOf(0.0f));
                continue;
            }
            double d2 = (double)n3 * (d * 0.01);
            int n5 = (int)d2;
            int n6 = (int)Math.floor((double)n4 * (d2 - (double)n5));
            hashMap.put(primarySkillType.toString(), n5);
            hashMap2.put(primarySkillType.toString(), Float.valueOf(n6));
            n2 += n5;
        }
        if (!EventUtils.handleStatsLossEvent(player, hashMap, hashMap2)) {
            return;
        }
        NotificationManager.sendPlayerInformation(player, NotificationType.HARDCORE_MODE, "Hardcore.DeathStatLoss.PlayerDeath", String.valueOf(n2));
    }

    public static void invokeVampirism(Player player, Player player2) {
        if (!(!WorldGuardUtils.isWorldGuardLoaded() || WorldGuardManager.getInstance().hasHardcoreFlag(player) && WorldGuardManager.getInstance().hasHardcoreFlag(player2))) {
            return;
        }
        double d = Config.getInstance().getHardcoreVampirismStatLeechPercentage();
        int n = Config.getInstance().getHardcoreVampirismLevelThreshold();
        if (UserManager.getPlayer(player) == null || UserManager.getPlayer(player2) == null) {
            return;
        }
        PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
        PlayerProfile playerProfile2 = UserManager.getPlayer(player2).getProfile();
        int n2 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Float> hashMap2 = new HashMap<String, Float>();
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            if (!primarySkillType.getHardcoreVampirismEnabled()) {
                hashMap.put(primarySkillType.toString(), 0);
                hashMap2.put(primarySkillType.toString(), Float.valueOf(0.0f));
                continue;
            }
            int n3 = playerProfile.getSkillLevel(primarySkillType);
            int n4 = playerProfile2.getSkillLevel(primarySkillType);
            if (n4 <= 0 || n4 < n3 / 2 || n4 <= n) {
                hashMap.put(primarySkillType.toString(), 0);
                hashMap2.put(primarySkillType.toString(), Float.valueOf(0.0f));
                continue;
            }
            int n5 = playerProfile2.getSkillXpLevel(primarySkillType);
            double d2 = (double)n4 * (d * 0.01);
            int n6 = (int)d2;
            int n7 = (int)Math.floor((double)n5 * (d2 - (double)n6));
            hashMap.put(primarySkillType.toString(), n6);
            hashMap2.put(primarySkillType.toString(), Float.valueOf(n7));
            n2 += n6;
        }
        if (!EventUtils.handleVampirismEvent(player, player2, hashMap, hashMap2)) {
            return;
        }
        if (n2 > 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.HARDCORE_MODE, "Hardcore.Vampirism.Killer.Success", String.valueOf(n2), player2.getName());
            NotificationManager.sendPlayerInformation(player2, NotificationType.HARDCORE_MODE, "Hardcore.Vampirism.Victim.Success", player.getName(), String.valueOf(n2));
        } else {
            NotificationManager.sendPlayerInformation(player, NotificationType.HARDCORE_MODE, "Hardcore.Vampirism.Killer.Failure", player2.getName());
            NotificationManager.sendPlayerInformation(player2, NotificationType.HARDCORE_MODE, "Hardcore.Vampirism.Victim.Failure", player.getName());
        }
    }

    public static boolean isStatLossEnabled() {
        boolean bl = false;
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            if (!primarySkillType.getHardcoreStatLossEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isVampirismEnabled() {
        boolean bl = false;
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            if (!primarySkillType.getHardcoreVampirismEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

