/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelChangeEvent;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelDownEvent;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelUpEvent;
import com.gmail.nossr50.events.experience.McMMOPlayerXpGainEvent;
import com.gmail.nossr50.events.fake.FakeBlockBreakEvent;
import com.gmail.nossr50.events.fake.FakeBlockDamageEvent;
import com.gmail.nossr50.events.fake.FakeEntityDamageEvent;
import com.gmail.nossr50.events.fake.FakePlayerAnimationEvent;
import com.gmail.nossr50.events.fake.FakePlayerFishEvent;
import com.gmail.nossr50.events.hardcore.McMMOPlayerPreDeathPenaltyEvent;
import com.gmail.nossr50.events.hardcore.McMMOPlayerStatLossEvent;
import com.gmail.nossr50.events.hardcore.McMMOPlayerVampirismEvent;
import com.gmail.nossr50.events.party.McMMOPartyLevelUpEvent;
import com.gmail.nossr50.events.party.McMMOPartyTeleportEvent;
import com.gmail.nossr50.events.party.McMMOPartyXpGainEvent;
import com.gmail.nossr50.events.skills.abilities.McMMOPlayerAbilityActivateEvent;
import com.gmail.nossr50.events.skills.abilities.McMMOPlayerAbilityDeactivateEvent;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerFishingTreasureEvent;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerMagicHunterEvent;
import com.gmail.nossr50.events.skills.repair.McMMOPlayerRepairCheckEvent;
import com.gmail.nossr50.events.skills.salvage.McMMOPlayerSalvageCheckEvent;
import com.gmail.nossr50.events.skills.secondaryabilities.SubSkillEvent;
import com.gmail.nossr50.events.skills.unarmed.McMMOPlayerDisarmEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.PluginManager;

public class EventUtils {
    public static boolean isDamageFromMcMMOComplexBehaviour(Event event) {
        return event instanceof FakeEntityDamageEvent;
    }

    public static McMMOPlayer getMcMMOPlayer(Entity entity) {
        return UserManager.getPlayer((Player)entity);
    }

    public static boolean isRealPlayerDamaged(EntityDamageEvent entityDamageEvent) {
        double d = entityDamageEvent.getFinalDamage();
        if (d <= 0.0) {
            return false;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (Misc.isNPCEntityExcludingVillagers(entity)) {
            return false;
        }
        if (!entity.isValid() || !(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (CombatUtils.isInvincible(livingEntity, d)) {
            return false;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)entity;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return true;
            }
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
            if (mcMMOPlayer == null) {
                return true;
            }
            if (mcMMOPlayer.getGodMode()) {
                entityDamageEvent.setCancelled(true);
                return false;
            }
            return true;
        }
        return false;
    }

    public static McMMOPlayerAbilityActivateEvent callPlayerAbilityActivateEvent(Player player, PrimarySkillType primarySkillType) {
        McMMOPlayerAbilityActivateEvent mcMMOPlayerAbilityActivateEvent = new McMMOPlayerAbilityActivateEvent(player, primarySkillType);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerAbilityActivateEvent);
        return mcMMOPlayerAbilityActivateEvent;
    }

    @Deprecated
    public static SubSkillEvent callSubSkillEvent(Player player, SubSkillType subSkillType) {
        SubSkillEvent subSkillEvent = new SubSkillEvent(player, subSkillType);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)subSkillEvent);
        return subSkillEvent;
    }

    public static SubSkillEvent callSubSkillEvent(Player player, AbstractSubSkill abstractSubSkill) {
        SubSkillEvent subSkillEvent = new SubSkillEvent(player, abstractSubSkill);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)subSkillEvent);
        return subSkillEvent;
    }

    public static FakePlayerAnimationEvent callFakeArmSwingEvent(Player player) {
        FakePlayerAnimationEvent fakePlayerAnimationEvent = new FakePlayerAnimationEvent(player);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)fakePlayerAnimationEvent);
        return fakePlayerAnimationEvent;
    }

    public static boolean tryLevelChangeEvent(Player player, PrimarySkillType primarySkillType, int n, float f, boolean bl, XPGainReason xPGainReason) {
        McMMOPlayerLevelChangeEvent mcMMOPlayerLevelChangeEvent = bl ? new McMMOPlayerLevelUpEvent(player, primarySkillType, n, xPGainReason) : new McMMOPlayerLevelDownEvent(player, primarySkillType, n, xPGainReason);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerLevelChangeEvent);
        boolean bl2 = mcMMOPlayerLevelChangeEvent.isCancelled();
        if (bl2) {
            PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
            playerProfile.modifySkill(primarySkillType, playerProfile.getSkillLevel(primarySkillType) - (bl ? n : -n));
            playerProfile.addXp(primarySkillType, f);
        }
        return bl2;
    }

    public static boolean tryLevelEditEvent(Player player, PrimarySkillType primarySkillType, int n, float f, boolean bl, XPGainReason xPGainReason, int n2) {
        McMMOPlayerLevelChangeEvent mcMMOPlayerLevelChangeEvent = bl ? new McMMOPlayerLevelUpEvent(player, primarySkillType, n - n2, xPGainReason) : new McMMOPlayerLevelDownEvent(player, primarySkillType, n, xPGainReason);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerLevelChangeEvent);
        boolean bl2 = mcMMOPlayerLevelChangeEvent.isCancelled();
        if (bl2) {
            PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
            playerProfile.modifySkill(primarySkillType, playerProfile.getSkillLevel(primarySkillType) - (bl ? n : -n));
            playerProfile.addXp(primarySkillType, f);
        }
        return bl2;
    }

    public static boolean simulateBlockBreak(Block block, Player player, boolean bl) {
        PluginManager pluginManager = mcMMO.p.getServer().getPluginManager();
        if (bl) {
            EventUtils.callFakeArmSwingEvent(player);
        }
        FakeBlockDamageEvent fakeBlockDamageEvent = new FakeBlockDamageEvent(player, block, player.getInventory().getItemInMainHand(), true);
        pluginManager.callEvent((Event)fakeBlockDamageEvent);
        FakeBlockBreakEvent fakeBlockBreakEvent = new FakeBlockBreakEvent(block, player);
        pluginManager.callEvent((Event)fakeBlockBreakEvent);
        return !fakeBlockDamageEvent.isCancelled() && !fakeBlockBreakEvent.isCancelled();
    }

    public static void handlePartyTeleportEvent(Player player, Player player2) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        McMMOPartyTeleportEvent mcMMOPartyTeleportEvent = new McMMOPartyTeleportEvent(player, player2, mcMMOPlayer.getParty().getName());
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPartyTeleportEvent);
        if (mcMMOPartyTeleportEvent.isCancelled()) {
            return;
        }
        player.teleport((Entity)player2);
        player.sendMessage(LocaleLoader.getString("Party.Teleport.Player", player2.getName()));
        player2.sendMessage(LocaleLoader.getString("Party.Teleport.Target", player.getName()));
        mcMMOPlayer.getPartyTeleportRecord().actualizeLastUse();
    }

    public static boolean handlePartyXpGainEvent(Party party, float f) {
        McMMOPartyXpGainEvent mcMMOPartyXpGainEvent = new McMMOPartyXpGainEvent(party, f);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPartyXpGainEvent);
        boolean bl = mcMMOPartyXpGainEvent.isCancelled();
        if (!bl) {
            party.addXp(mcMMOPartyXpGainEvent.getRawXpGained());
        }
        return !bl;
    }

    public static boolean handlePartyLevelChangeEvent(Party party, int n, float f) {
        McMMOPartyLevelUpEvent mcMMOPartyLevelUpEvent = new McMMOPartyLevelUpEvent(party, n);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPartyLevelUpEvent);
        boolean bl = mcMMOPartyLevelUpEvent.isCancelled();
        if (bl) {
            party.setLevel(party.getLevel() + n);
            party.addXp(f);
        }
        return !bl;
    }

    public static boolean handleXpGainEvent(Player player, PrimarySkillType primarySkillType, float f, XPGainReason xPGainReason) {
        McMMOPlayerXpGainEvent mcMMOPlayerXpGainEvent = new McMMOPlayerXpGainEvent(player, primarySkillType, f, xPGainReason);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerXpGainEvent);
        boolean bl = mcMMOPlayerXpGainEvent.isCancelled();
        if (!bl) {
            UserManager.getPlayer(player).addXp(primarySkillType, mcMMOPlayerXpGainEvent.getRawXpGained());
            UserManager.getPlayer(player).getProfile().registerXpGain(primarySkillType, mcMMOPlayerXpGainEvent.getRawXpGained());
        }
        return !bl;
    }

    public static boolean handleStatsLossEvent(Player player, HashMap<String, Integer> hashMap, HashMap<String, Float> hashMap2) {
        if (UserManager.getPlayer(player) == null) {
            return true;
        }
        McMMOPlayerStatLossEvent mcMMOPlayerStatLossEvent = new McMMOPlayerStatLossEvent(player, hashMap, hashMap2);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerStatLossEvent);
        boolean bl = mcMMOPlayerStatLossEvent.isCancelled();
        if (!bl) {
            hashMap = mcMMOPlayerStatLossEvent.getLevelChanged();
            hashMap2 = mcMMOPlayerStatLossEvent.getExperienceChanged();
            PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
            for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                String string = primarySkillType.toString();
                int n = playerProfile.getSkillLevel(primarySkillType);
                playerProfile.modifySkill(primarySkillType, n - hashMap.get(string));
                playerProfile.removeXp(primarySkillType, hashMap2.get(string).floatValue());
                if (playerProfile.getSkillXpLevel(primarySkillType) < 0) {
                    playerProfile.setSkillXpLevel(primarySkillType, 0.0f);
                }
                if (playerProfile.getSkillLevel(primarySkillType) >= 0) continue;
                playerProfile.modifySkill(primarySkillType, 0);
            }
        }
        return !bl;
    }

    public static boolean handleVampirismEvent(Player player, Player player2, HashMap<String, Integer> hashMap, HashMap<String, Float> hashMap2) {
        boolean bl;
        McMMOPlayerVampirismEvent mcMMOPlayerVampirismEvent = new McMMOPlayerVampirismEvent(player, false, hashMap, hashMap2);
        McMMOPlayerVampirismEvent mcMMOPlayerVampirismEvent2 = new McMMOPlayerVampirismEvent(player2, true, hashMap, hashMap2);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerVampirismEvent);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerVampirismEvent2);
        boolean bl2 = bl = mcMMOPlayerVampirismEvent.isCancelled() || mcMMOPlayerVampirismEvent2.isCancelled();
        if (!bl) {
            HashMap<String, Integer> hashMap3 = mcMMOPlayerVampirismEvent.getLevelChanged();
            HashMap<String, Float> hashMap4 = mcMMOPlayerVampirismEvent.getExperienceChanged();
            HashMap<String, Integer> hashMap5 = mcMMOPlayerVampirismEvent2.getLevelChanged();
            HashMap<String, Float> hashMap6 = mcMMOPlayerVampirismEvent2.getExperienceChanged();
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
            if (mcMMOPlayer == null) {
                return true;
            }
            if (UserManager.getPlayer(player2) == null) {
                return true;
            }
            PlayerProfile playerProfile = UserManager.getPlayer(player2).getProfile();
            for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                String string = primarySkillType.toString();
                int n = playerProfile.getSkillLevel(primarySkillType);
                mcMMOPlayer.addLevels(primarySkillType, hashMap3.get(string));
                mcMMOPlayer.beginUnsharedXpGain(primarySkillType, hashMap4.get(string).floatValue(), XPGainReason.VAMPIRISM, XPGainSource.VAMPIRISM);
                playerProfile.modifySkill(primarySkillType, n - hashMap5.get(string));
                playerProfile.removeXp(primarySkillType, hashMap6.get(string).floatValue());
                if (playerProfile.getSkillXpLevel(primarySkillType) < 0) {
                    playerProfile.setSkillXpLevel(primarySkillType, 0.0f);
                }
                if (playerProfile.getSkillLevel(primarySkillType) >= 0) continue;
                playerProfile.modifySkill(primarySkillType, 0);
            }
        }
        return !bl;
    }

    public static McMMOPlayerAbilityDeactivateEvent callAbilityDeactivateEvent(Player player, SuperAbilityType superAbilityType) {
        McMMOPlayerAbilityDeactivateEvent mcMMOPlayerAbilityDeactivateEvent = new McMMOPlayerAbilityDeactivateEvent(player, PrimarySkillType.byAbility(superAbilityType));
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerAbilityDeactivateEvent);
        return mcMMOPlayerAbilityDeactivateEvent;
    }

    public static McMMOPlayerFishingTreasureEvent callFishingTreasureEvent(Player player, ItemStack itemStack, int n, Map<Enchantment, Integer> map) {
        McMMOPlayerFishingTreasureEvent mcMMOPlayerFishingTreasureEvent = map.isEmpty() ? new McMMOPlayerFishingTreasureEvent(player, itemStack, n) : new McMMOPlayerMagicHunterEvent(player, itemStack, n, map);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerFishingTreasureEvent);
        return mcMMOPlayerFishingTreasureEvent;
    }

    public static FakePlayerFishEvent callFakeFishEvent(Player player, FishHook fishHook) {
        FakePlayerFishEvent fakePlayerFishEvent = new FakePlayerFishEvent(player, null, fishHook, PlayerFishEvent.State.FISHING);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)fakePlayerFishEvent);
        return fakePlayerFishEvent;
    }

    public static McMMOPlayerRepairCheckEvent callRepairCheckEvent(Player player, short s, ItemStack itemStack, ItemStack itemStack2) {
        McMMOPlayerRepairCheckEvent mcMMOPlayerRepairCheckEvent = new McMMOPlayerRepairCheckEvent(player, s, itemStack, itemStack2);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerRepairCheckEvent);
        return mcMMOPlayerRepairCheckEvent;
    }

    public static McMMOPlayerPreDeathPenaltyEvent callPreDeathPenaltyEvent(Player player) {
        McMMOPlayerPreDeathPenaltyEvent mcMMOPlayerPreDeathPenaltyEvent = new McMMOPlayerPreDeathPenaltyEvent(player);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerPreDeathPenaltyEvent);
        return mcMMOPlayerPreDeathPenaltyEvent;
    }

    public static McMMOPlayerDisarmEvent callDisarmEvent(Player player) {
        McMMOPlayerDisarmEvent mcMMOPlayerDisarmEvent = new McMMOPlayerDisarmEvent(player);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerDisarmEvent);
        return mcMMOPlayerDisarmEvent;
    }

    public static McMMOPlayerSalvageCheckEvent callSalvageCheckEvent(Player player, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        McMMOPlayerSalvageCheckEvent mcMMOPlayerSalvageCheckEvent = new McMMOPlayerSalvageCheckEvent(player, itemStack, itemStack2, itemStack3);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPlayerSalvageCheckEvent);
        return mcMMOPlayerSalvageCheckEvent;
    }
}

