/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.items.ChimaeraWingWarmup;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public final class ChimaeraWing {
    private static McMMOPlayer mcMMOPlayer;
    private static Location location;

    private ChimaeraWing() {
    }

    public static void activationCheck(Player player) {
        int n;
        int n2;
        if (!Config.getInstance().getChimaeraEnabled()) {
            return;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (!ItemUtils.isChimaeraWing(itemStack)) {
            return;
        }
        if (!Permissions.chimaeraWing((Permissible)player)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        if (mcMMOPlayer.getTeleportCommenceLocation() != null) {
            return;
        }
        int n3 = itemStack.getAmount();
        if (n3 < Config.getInstance().getChimaeraUseCost()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Item.ChimaeraWing.NotEnough", String.valueOf(Config.getInstance().getChimaeraUseCost() - n3), "Item.ChimaeraWing.Name");
            return;
        }
        long l = mcMMOPlayer.getChimeraWingLastUse();
        int n4 = Config.getInstance().getChimaeraCooldown();
        if (n4 > 0 && (n2 = SkillUtils.calculateTimeLeft(l * 1000L, n4, player)) > 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ABILITY_COOLDOWN, "Item.Generic.Wait", String.valueOf(n2));
            return;
        }
        long l2 = mcMMOPlayer.getRecentlyHurt();
        int n5 = Config.getInstance().getChimaeraRecentlyHurtCooldown();
        if (n5 > 0 && (n = SkillUtils.calculateTimeLeft(l2 * 1000L, n5, player)) > 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ITEM_MESSAGE, "Item.Injured.Wait", String.valueOf(n));
            return;
        }
        location = player.getLocation();
        if (Config.getInstance().getChimaeraPreventUseUnderground() && location.getY() < (double)player.getWorld().getHighestBlockYAt(location)) {
            player.getInventory().setItemInMainHand(new ItemStack(ChimaeraWing.getChimaeraWing(n3 - Config.getInstance().getChimaeraUseCost())));
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Item.ChimaeraWing.Fail");
            player.updateInventory();
            player.setVelocity(new Vector(0.0, 0.5, 0.0));
            CombatUtils.dealDamage((LivingEntity)player, Misc.getRandom().nextInt((int)(player.getHealth() - 10.0)));
            mcMMOPlayer.actualizeChimeraWingLastUse();
            return;
        }
        mcMMOPlayer.actualizeTeleportCommenceLocation(player);
        long l3 = Config.getInstance().getChimaeraWarmup();
        if (l3 > 0L) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ITEM_MESSAGE, "Teleport.Commencing", String.valueOf(l3));
            new ChimaeraWingWarmup(mcMMOPlayer).runTaskLater((Plugin)mcMMO.p, 20L * l3);
        } else {
            ChimaeraWing.chimaeraExecuteTeleport();
        }
    }

    public static void chimaeraExecuteTeleport() {
        Player player = mcMMOPlayer.getPlayer();
        if (Config.getInstance().getChimaeraUseBedSpawn() && player.getBedSpawnLocation() != null) {
            player.teleport(player.getBedSpawnLocation());
        } else {
            Location location = player.getWorld().getSpawnLocation();
            if (location.getBlock().getType() == Material.AIR) {
                player.teleport(location);
            } else {
                player.teleport(player.getWorld().getHighestBlockAt(location).getLocation());
            }
        }
        player.getInventory().setItemInMainHand(new ItemStack(ChimaeraWing.getChimaeraWing(player.getInventory().getItemInMainHand().getAmount() - Config.getInstance().getChimaeraUseCost())));
        player.updateInventory();
        mcMMOPlayer.actualizeChimeraWingLastUse();
        mcMMOPlayer.setTeleportCommenceLocation(null);
        if (Config.getInstance().getChimaeraSoundEnabled()) {
            SoundManager.sendSound(player, location, SoundType.CHIMAERA_WING);
        }
        NotificationManager.sendPlayerInformation(player, NotificationType.ITEM_MESSAGE, "Item.ChimaeraWing.Pass");
    }

    public static ItemStack getChimaeraWing(int n) {
        ItemStack itemStack = new ItemStack(Config.getInstance().getChimaeraItem(), n);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.GOLD + LocaleLoader.getString("Item.ChimaeraWing.Name"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mcMMO Item");
        arrayList.add(LocaleLoader.getString("Item.ChimaeraWing.Lore"));
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ShapelessRecipe getChimaeraWingRecipe() {
        Material material = Config.getInstance().getChimaeraItem();
        int n = Config.getInstance().getChimaeraRecipeCost();
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(new NamespacedKey((Plugin)mcMMO.p, "Chimera"), ChimaeraWing.getChimaeraWing(1));
        shapelessRecipe.addIngredient(n, material);
        return shapelessRecipe;
    }
}

