/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.meta.BonusDropMeta;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.util.MaterialUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.RandomChanceSkill;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static void markDropsAsBonus(BlockState blockState, boolean bl) {
        if (bl) {
            blockState.setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(2, mcMMO.p));
        } else {
            blockState.setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(1, mcMMO.p));
        }
    }

    public static void markDropsAsBonus(BlockState blockState, int n) {
        blockState.setMetadata("mcMMO: Double Drops", (MetadataValue)new BonusDropMeta(n, mcMMO.p));
    }

    public static boolean checkDoubleDrops(Player player, BlockState blockState, PrimarySkillType primarySkillType, SubSkillType subSkillType) {
        if (Config.getInstance().getDoubleDropsEnabled(primarySkillType, blockState.getType()) && Permissions.isSubSkillEnabled((Permissible)player, subSkillType)) {
            return RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkill(player, subSkillType, true));
        }
        return false;
    }

    public static boolean shouldBeWatched(BlockState blockState) {
        return BlockUtils.affectedByGigaDrillBreaker(blockState) || BlockUtils.affectedByGreenTerra(blockState) || BlockUtils.affectedBySuperBreaker(blockState) != false || BlockUtils.isLog(blockState);
    }

    public static boolean canActivateAbilities(BlockState blockState) {
        return !mcMMO.getMaterialMapStore().isAbilityActivationBlackListed(blockState.getType());
    }

    public static boolean canActivateTools(BlockState blockState) {
        return !mcMMO.getMaterialMapStore().isToolActivationBlackListed(blockState.getType());
    }

    public static boolean isOre(BlockState blockState) {
        return MaterialUtils.isOre(blockState.getType());
    }

    public static boolean canMakeMossy(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isMossyWhiteListed(blockState.getType());
    }

    public static boolean affectedByGreenTerra(BlockState blockState) {
        if (ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.HERBALISM, blockState.getBlockData())) {
            return true;
        }
        return mcMMO.getModManager().isCustomHerbalismBlock(blockState);
    }

    public static Boolean affectedBySuperBreaker(BlockState blockState) {
        if (ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.MINING, blockState.getBlockData())) {
            return true;
        }
        return BlockUtils.isOre(blockState) || mcMMO.getModManager().isCustomMiningBlock(blockState);
    }

    public static boolean affectedByGigaDrillBreaker(BlockState blockState) {
        if (ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.EXCAVATION, blockState.getBlockData())) {
            return true;
        }
        return mcMMO.getModManager().isCustomExcavationBlock(blockState);
    }

    public static boolean isLog(BlockState blockState) {
        if (ExperienceConfig.getInstance().doesBlockGiveSkillXP(PrimarySkillType.WOODCUTTING, blockState.getBlockData())) {
            return true;
        }
        return mcMMO.getModManager().isCustomLog(blockState);
    }

    public static boolean isLeaves(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isLeavesWhiteListed(blockState.getType());
    }

    public static boolean affectedByFluxMining(BlockState blockState) {
        switch (blockState.getType()) {
            case IRON_ORE: 
            case GOLD_ORE: {
                return true;
            }
        }
        return false;
    }

    public static boolean canActivateHerbalism(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isHerbalismAbilityWhiteListed(blockState.getType());
    }

    public static boolean affectedByBlockCracker(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isBlockCrackerWhiteListed(blockState.getType());
    }

    public static boolean canMakeShroomy(BlockState blockState) {
        return mcMMO.getMaterialMapStore().isShroomyWhiteListed(blockState.getType());
    }

    public static boolean isMcMMOAnvil(BlockState blockState) {
        Material material = blockState.getType();
        return material == Repair.anvilMaterial || material == Salvage.anvilMaterial;
    }

    public static boolean isPistonPiece(BlockState blockState) {
        Material material = blockState.getType();
        return material == Material.MOVING_PISTON || material == Material.AIR;
    }

    public static HashSet<Material> getTransparentBlocks() {
        HashSet<Material> hashSet = new HashSet<Material>();
        for (Material material : Material.values()) {
            if (!material.isTransparent()) continue;
            hashSet.add(material);
        }
        return hashSet;
    }

    public static boolean isFullyGrown(BlockState blockState) {
        BlockData blockData = blockState.getBlockData();
        if (blockData.getMaterial() == Material.CACTUS || blockData.getMaterial() == Material.SUGAR_CANE) {
            return true;
        }
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            return ageable.getAge() == ageable.getMaximumAge();
        }
        return true;
    }
}

