/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.woodcutting;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class WoodcuttingManager
extends SkillManager {
    private boolean treeFellerReachedThreshold = false;
    private static int treeFellerThreshold;
    private static final int[][] directions;

    public WoodcuttingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.WOODCUTTING);
        treeFellerThreshold = Config.getInstance().getTreeFellerThreshold();
    }

    public boolean canUseLeafBlower(ItemStack itemStack) {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.WOODCUTTING_LEAF_BLOWER) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.WOODCUTTING_LEAF_BLOWER) && ItemUtils.isAxe(itemStack);
    }

    public boolean canUseTreeFeller(ItemStack itemStack) {
        return this.mcMMOPlayer.getAbilityMode(SuperAbilityType.TREE_FELLER) && ItemUtils.isAxe(itemStack);
    }

    private boolean canGetDoubleDrops() {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.WOODCUTTING_HARVEST_LUMBER) && RankUtils.hasReachedRank(1, this.getPlayer(), SubSkillType.WOODCUTTING_HARVEST_LUMBER) && RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.WOODCUTTING_HARVEST_LUMBER, this.getPlayer());
    }

    public void woodcuttingBlockCheck(BlockState blockState) {
        int n = WoodcuttingManager.getExperienceFromLog(blockState);
        switch (blockState.getType()) {
            case BROWN_MUSHROOM_BLOCK: 
            case RED_MUSHROOM_BLOCK: {
                break;
            }
            default: {
                if (!this.canGetDoubleDrops()) break;
                WoodcuttingManager.checkForDoubleDrop(blockState);
            }
        }
        this.applyXpGain(n, XPGainReason.PVE);
    }

    public void processTreeFeller(BlockState blockState) {
        Player player = this.getPlayer();
        HashSet<BlockState> hashSet = new HashSet<BlockState>();
        this.treeFellerReachedThreshold = false;
        this.processTree(blockState, hashSet);
        if (this.treeFellerReachedThreshold) {
            this.treeFellerReachedThreshold = false;
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Woodcutting.Skills.TreeFeller.Threshold");
            return;
        }
        if (!WoodcuttingManager.handleDurabilityLoss(hashSet, player.getInventory().getItemInMainHand())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Woodcutting.Skills.TreeFeller.Splinter");
            double d = player.getHealth();
            if (d > 1.0) {
                CombatUtils.dealDamage((LivingEntity)player, Misc.getRandom().nextInt((int)(d - 1.0)));
            }
            return;
        }
        this.dropTreeFellerLootFromBlocks(hashSet);
        this.treeFellerReachedThreshold = false;
    }

    private void processTree(BlockState blockState, Set<BlockState> set) {
        ArrayList<BlockState> arrayList = new ArrayList<BlockState>();
        if (this.processTreeFellerTargetBlock(blockState.getBlock().getRelative(BlockFace.UP).getState(), arrayList, set)) {
            for (int[] nArray : directions) {
                this.processTreeFellerTargetBlock(blockState.getBlock().getRelative(nArray[0], 0, nArray[1]).getState(), arrayList, set);
                if (!this.treeFellerReachedThreshold) continue;
                return;
            }
        } else {
            this.processTreeFellerTargetBlock(blockState.getBlock().getRelative(BlockFace.DOWN).getState(), arrayList, set);
            for (int i = -1; i <= 1; ++i) {
                for (int[] nArray : directions) {
                    this.processTreeFellerTargetBlock(blockState.getBlock().getRelative(nArray[0], i, nArray[1]).getState(), arrayList, set);
                    if (!this.treeFellerReachedThreshold) continue;
                    return;
                }
            }
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            BlockState blockState2 = (BlockState)object.next();
            if (this.treeFellerReachedThreshold) {
                return;
            }
            this.processTree(blockState2, set);
        }
    }

    private static boolean handleDurabilityLoss(Set<BlockState> set, ItemStack itemStack) {
        if (itemStack.getItemMeta() != null && itemStack.getItemMeta().isUnbreakable()) {
            return true;
        }
        int n = 0;
        Material material = itemStack.getType();
        for (BlockState blockState : set) {
            if (!BlockUtils.isLog(blockState)) continue;
            n = (short)(n + Config.getInstance().getAbilityToolDamage());
        }
        SkillUtils.handleDurabilityChange(itemStack, n);
        return itemStack.getDurability() < (mcMMO.getRepairableManager().isRepairable(material) ? mcMMO.getRepairableManager().getRepairable(material).getMaximumDurability() : material.getMaxDurability());
    }

    private boolean processTreeFellerTargetBlock(BlockState blockState, List<BlockState> list, Set<BlockState> set) {
        if (set.contains(blockState) || mcMMO.getPlaceStore().isTrue(blockState)) {
            return false;
        }
        if (set.size() > treeFellerThreshold) {
            this.treeFellerReachedThreshold = true;
        }
        if (BlockUtils.isLog(blockState)) {
            set.add(blockState);
            list.add(blockState);
            return true;
        }
        if (BlockUtils.isLeaves(blockState)) {
            set.add(blockState);
            return false;
        }
        return false;
    }

    private void dropTreeFellerLootFromBlocks(Set<BlockState> set) {
        Player player = this.getPlayer();
        int n = 0;
        int n2 = 0;
        for (BlockState blockState : set) {
            int n3 = n;
            Block block = blockState.getBlock();
            if (!EventUtils.simulateBlockBreak(block, player, true)) break;
            Material material = blockState.getType();
            if (material == Material.BROWN_MUSHROOM_BLOCK || material == Material.RED_MUSHROOM_BLOCK) {
                n += WoodcuttingManager.processTreeFellerXPGains(blockState, n2);
                Misc.dropItems(Misc.getBlockCenter(blockState), block.getDrops());
            } else if (mcMMO.getModManager().isCustomLeaf(blockState)) {
                Misc.dropItems(Misc.getBlockCenter(blockState), block.getDrops());
            } else {
                if (BlockUtils.isLog(blockState)) {
                    if (this.canGetDoubleDrops()) {
                        WoodcuttingManager.checkForDoubleDrop(blockState);
                    }
                    n += WoodcuttingManager.processTreeFellerXPGains(blockState, n2);
                    Misc.dropItems(Misc.getBlockCenter(blockState), block.getDrops());
                }
                if (BlockUtils.isLeaves(blockState)) {
                    Misc.dropItems(Misc.getBlockCenter(blockState), block.getDrops());
                }
            }
            blockState.setType(Material.AIR);
            blockState.update(true);
            n2 = this.updateProcessedLogCount(n, n2, n3);
        }
        this.applyXpGain(n, XPGainReason.PVE);
    }

    private int updateProcessedLogCount(int n, int n2, int n3) {
        if (n3 != n) {
            ++n2;
        }
        return n2;
    }

    private static int processTreeFellerXPGains(BlockState blockState, int n) {
        int n2 = ExperienceConfig.getInstance().getXp(PrimarySkillType.WOODCUTTING, blockState.getType());
        if (n2 <= 0) {
            return 0;
        }
        if (ExperienceConfig.getInstance().isTreeFellerXPReduced()) {
            int n3 = n2 - n * 5;
            n2 = Math.max(1, n3);
            return n2;
        }
        return ExperienceConfig.getInstance().getXp(PrimarySkillType.WOODCUTTING, blockState.getType());
    }

    protected static int getExperienceFromLog(BlockState blockState) {
        if (mcMMO.getModManager().isCustomLog(blockState)) {
            return mcMMO.getModManager().getBlock(blockState).getXpGain();
        }
        return ExperienceConfig.getInstance().getXp(PrimarySkillType.WOODCUTTING, blockState.getType());
    }

    protected static void checkForDoubleDrop(BlockState blockState) {
        if (mcMMO.getModManager().isCustomLog(blockState) && mcMMO.getModManager().getBlock(blockState).isDoubleDropEnabled()) {
            Misc.dropItems(Misc.getBlockCenter(blockState), blockState.getBlock().getDrops());
        } else if (Config.getInstance().getWoodcuttingDoubleDropsEnabled(blockState.getBlockData())) {
            Misc.dropItems(Misc.getBlockCenter(blockState), blockState.getBlock().getDrops());
        }
    }

    static {
        directions = new int[][]{{-2, -1}, {-2, 0}, {-2, 1}, {-1, -2}, {-1, -1}, {-1, 0}, {-1, 1}, {-1, 2}, {0, -2}, {0, -1}, {0, 1}, {0, 2}, {1, -2}, {1, -1}, {1, 0}, {1, 1}, {1, 2}, {2, -1}, {2, 0}, {2, 1}};
    }
}

