/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.unarmed;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.unarmed.Unarmed;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;

public class UnarmedManager
extends SkillManager {
    private long lastAttacked;
    private long attackInterval;

    public UnarmedManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.UNARMED);
        this.initUnarmedPerPlayerVars();
    }

    private void initUnarmedPerPlayerVars() {
        this.lastAttacked = 0L;
        this.attackInterval = 750L;
    }

    public boolean canActivateAbility() {
        return this.mcMMOPlayer.getToolPreparationMode(ToolType.FISTS) && Permissions.berserk((Permissible)this.getPlayer());
    }

    public boolean canUseIronArm() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_IRON_ARM_STYLE)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_IRON_ARM_STYLE);
    }

    public boolean canUseBerserk() {
        return this.mcMMOPlayer.getAbilityMode(SuperAbilityType.BERSERK);
    }

    public boolean canDisarm(LivingEntity livingEntity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_DISARM)) {
            return false;
        }
        return livingEntity instanceof Player && ((Player)livingEntity).getInventory().getItemInMainHand().getType() != Material.AIR && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_DISARM);
    }

    public boolean canDeflect() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_ARROW_DEFLECT)) {
            return false;
        }
        Player player = this.getPlayer();
        return ItemUtils.isUnarmed(player.getInventory().getItemInMainHand()) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_ARROW_DEFLECT);
    }

    public boolean canUseBlockCracker() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.UNARMED_BLOCK_CRACKER)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.UNARMED_BLOCK_CRACKER);
    }

    public boolean blockCrackerCheck(BlockState blockState) {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.ALWAYS_FIRES, SubSkillType.UNARMED_BLOCK_CRACKER, this.getPlayer())) {
            return false;
        }
        switch (blockState.getType()) {
            case STONE_BRICKS: {
                if (!Unarmed.blockCrackerSmoothBrick) {
                    return false;
                }
                blockState.setType(Material.CRACKED_STONE_BRICKS);
                return true;
            }
        }
        return false;
    }

    public void disarmCheck(Player player) {
        if (RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.UNARMED_DISARM, this.getPlayer()) && !this.hasIronGrip(player)) {
            if (EventUtils.callDisarmEvent(player).isCancelled()) {
                return;
            }
            if (UserManager.getPlayer(player) == null) {
                return;
            }
            Item item = Misc.dropItem(player.getLocation(), player.getInventory().getItemInMainHand());
            if (item != null && AdvancedConfig.getInstance().getDisarmProtected()) {
                item.setMetadata("mcMMO: Disarmed Item", (MetadataValue)UserManager.getPlayer(player).getPlayerMetadata());
            }
            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Skills.Disarmed");
        }
    }

    public boolean deflectCheck() {
        if (RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.UNARMED_ARROW_DEFLECT, this.getPlayer())) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Combat.ArrowDeflect");
            return true;
        }
        return false;
    }

    public double berserkDamage(double d) {
        d = d * Unarmed.berserkDamageModifier - d;
        return d;
    }

    public double ironArm() {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.ALWAYS_FIRES, SubSkillType.UNARMED_IRON_ARM_STYLE, this.getPlayer())) {
            return 0.0;
        }
        return this.getIronArmDamage();
    }

    public boolean isPunchingCooldownOver() {
        return this.lastAttacked + this.attackInterval <= System.currentTimeMillis();
    }

    public double getIronArmDamage() {
        int n = RankUtils.getRank(this.getPlayer(), SubSkillType.UNARMED_IRON_ARM_STYLE);
        if (n == 1) {
            return 4.0;
        }
        return 3 + n * 2;
    }

    private boolean hasIronGrip(Player player) {
        if (!Misc.isNPCEntityExcludingVillagers((Entity)player) && Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.UNARMED_IRON_GRIP) && RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.UNARMED_IRON_GRIP, player)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Unarmed.Ability.IronGrip.Defender");
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Unarmed.Ability.IronGrip.Attacker");
            return true;
        }
        return false;
    }

    public long getLastAttacked() {
        return this.lastAttacked;
    }

    public void setLastAttacked(long l) {
        this.lastAttacked = l;
    }

    public long getAttackInterval() {
        return this.attackInterval;
    }

    public void setAttackInterval(long l) {
        this.attackInterval = l;
    }
}

