/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.taming;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TrackedTamingEntity
extends BukkitRunnable {
    private LivingEntity livingEntity;
    private final CallOfTheWildType callOfTheWildType;
    private UUID id;
    private int length;
    private final TamingManager tamingManagerRef;

    protected TrackedTamingEntity(LivingEntity livingEntity, CallOfTheWildType callOfTheWildType, TamingManager tamingManager) {
        this.tamingManagerRef = tamingManager;
        this.callOfTheWildType = callOfTheWildType;
        this.livingEntity = livingEntity;
        this.id = livingEntity.getUniqueId();
        int n = Config.getInstance().getTamingCOTWLength(callOfTheWildType.getConfigEntityTypeEntry());
        if (n > 0) {
            this.length = n * 20;
            this.runTaskLater((Plugin)mcMMO.p, this.length);
        }
    }

    public void run() {
        if (this.livingEntity.isValid()) {
            Location location = this.livingEntity.getLocation();
            location.getWorld().playSound(location, Sound.BLOCK_FIRE_EXTINGUISH, 0.8f, 0.8f);
            ParticleEffectUtils.playCallOfTheWildEffect(this.livingEntity);
            if (this.tamingManagerRef != null) {
                this.tamingManagerRef.removeFromTracker(this);
            }
            this.livingEntity.setHealth(0.0);
            this.livingEntity.remove();
        }
        this.cancel();
    }

    public CallOfTheWildType getCallOfTheWildType() {
        return this.callOfTheWildType;
    }

    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    public UUID getID() {
        return this.id;
    }
}

