/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.taming;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import com.gmail.nossr50.datatypes.skills.subskills.taming.TamingSummon;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.skills.taming.TrackedTamingEntity;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceSkillStatic;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;

public class TamingManager
extends SkillManager {
    private static HashMap<Material, CallOfTheWildType> summoningItems;
    private static HashMap<CallOfTheWildType, TamingSummon> cotwSummonDataProperties;
    private long lastSummonTimeStamp;
    private HashMap<CallOfTheWildType, List<TrackedTamingEntity>> playerSummonedEntities;

    public TamingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.TAMING);
        this.init();
    }

    private void init() {
        this.lastSummonTimeStamp = 0L;
        this.initPerPlayerSummonTracking();
        this.initStaticCaches();
    }

    private void initPerPlayerSummonTracking() {
        this.playerSummonedEntities = new HashMap();
        for (CallOfTheWildType callOfTheWildType : CallOfTheWildType.values()) {
            this.playerSummonedEntities.put(callOfTheWildType, new ArrayList());
        }
    }

    private void initStaticCaches() {
        if (summoningItems == null) {
            summoningItems = new HashMap();
            summoningItems.put(Config.getInstance().getTamingCOTWMaterial(CallOfTheWildType.CAT.getConfigEntityTypeEntry()), CallOfTheWildType.CAT);
            summoningItems.put(Config.getInstance().getTamingCOTWMaterial(CallOfTheWildType.WOLF.getConfigEntityTypeEntry()), CallOfTheWildType.WOLF);
            summoningItems.put(Config.getInstance().getTamingCOTWMaterial(CallOfTheWildType.HORSE.getConfigEntityTypeEntry()), CallOfTheWildType.HORSE);
        }
        if (cotwSummonDataProperties == null) {
            cotwSummonDataProperties = new HashMap();
            for (CallOfTheWildType callOfTheWildType : CallOfTheWildType.values()) {
                Material material = Config.getInstance().getTamingCOTWMaterial(callOfTheWildType.getConfigEntityTypeEntry());
                int n = Config.getInstance().getTamingCOTWCost(callOfTheWildType.getConfigEntityTypeEntry());
                int n2 = Config.getInstance().getTamingCOTWAmount(callOfTheWildType.getConfigEntityTypeEntry());
                int n3 = Config.getInstance().getTamingCOTWLength(callOfTheWildType.getConfigEntityTypeEntry());
                int n4 = Config.getInstance().getTamingCOTWMaxAmount(callOfTheWildType.getConfigEntityTypeEntry());
                TamingSummon tamingSummon = new TamingSummon(callOfTheWildType, material, n, n2, n3, n4);
                cotwSummonDataProperties.put(callOfTheWildType, tamingSummon);
            }
        }
    }

    public boolean canUseThickFur() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_THICK_FUR) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_THICK_FUR);
    }

    public boolean canUseEnvironmentallyAware() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_ENVIRONMENTALLY_AWARE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_ENVIRONMENTALLY_AWARE);
    }

    public boolean canUseShockProof() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_SHOCK_PROOF) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_SHOCK_PROOF);
    }

    public boolean canUseHolyHound() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_ENVIRONMENTALLY_AWARE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_HOLY_HOUND);
    }

    public boolean canUseFastFoodService() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_FAST_FOOD_SERVICE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_FAST_FOOD_SERVICE);
    }

    public boolean canUseSharpenedClaws() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_SHARPENED_CLAWS) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_SHARPENED_CLAWS);
    }

    public boolean canUseGore() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_GORE)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_GORE);
    }

    public boolean canUseBeastLore() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_BEAST_LORE)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_BEAST_LORE);
    }

    public void awardTamingXP(LivingEntity livingEntity) {
        this.applyXpGain(ExperienceConfig.getInstance().getTamingXP(livingEntity.getType()), XPGainReason.PVE);
    }

    public void fastFoodService(Wolf wolf, double d) {
        double d2;
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_STATIC_CHANCE, SubSkillType.TAMING_FAST_FOOD_SERVICE, this.getPlayer())) {
            return;
        }
        double d3 = wolf.getHealth();
        if (d3 < (d2 = wolf.getMaxHealth())) {
            double d4 = d3 + d;
            wolf.setHealth(Math.min(d4, d2));
        }
    }

    public double gore(LivingEntity livingEntity, double d) {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.TAMING_GORE, this.getPlayer())) {
            return 0.0;
        }
        BleedTimerTask.add(livingEntity, (LivingEntity)this.getPlayer(), Taming.goreBleedTicks, 1, 2);
        if (livingEntity instanceof Player) {
            NotificationManager.sendPlayerInformation((Player)livingEntity, NotificationType.SUBSKILL_MESSAGE, "Combat.StruckByGore");
        }
        NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Combat.Gore");
        d = d * Taming.goreModifier - d;
        return d;
    }

    public double sharpenedClaws() {
        return Taming.sharpenedClawsBonusDamage;
    }

    public void summonOcelot() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_CALL_OF_THE_WILD)) {
            return;
        }
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.OCELOT)) {
            return;
        }
        this.processCallOfTheWild();
    }

    public void summonWolf() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_CALL_OF_THE_WILD)) {
            return;
        }
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.WOLF)) {
            return;
        }
        this.processCallOfTheWild();
    }

    public void summonHorse() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_CALL_OF_THE_WILD)) {
            return;
        }
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.HORSE)) {
            return;
        }
        this.processCallOfTheWild();
    }

    public void beastLore(LivingEntity livingEntity) {
        Player player = this.getPlayer();
        Tameable tameable = (Tameable)livingEntity;
        String string = LocaleLoader.getString("Combat.BeastLore") + " ";
        if (tameable.isTamed() && tameable.getOwner() != null) {
            string = string.concat(LocaleLoader.getString("Combat.BeastLoreOwner", tameable.getOwner().getName()) + " ");
        }
        string = string.concat(LocaleLoader.getString("Combat.BeastLoreHealth", livingEntity.getHealth(), livingEntity.getMaxHealth()));
        if (tameable instanceof AbstractHorse) {
            AbstractHorse abstractHorse = (AbstractHorse)tameable;
            string = string.concat("\n" + LocaleLoader.getString("Combat.BeastLoreHorseSpeed", abstractHorse.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getValue() * 43.0));
        }
        player.sendMessage(string);
    }

    public void processEnvironmentallyAware(Wolf wolf, double d) {
        if (d > wolf.getHealth()) {
            return;
        }
        Player player = this.getPlayer();
        wolf.teleport((Entity)player);
        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Taming.Listener.Wolf");
    }

    public void pummel(LivingEntity livingEntity, Wolf wolf) {
        Player player;
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_PUMMEL)) {
            return;
        }
        if (!RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(AdvancedConfig.getInstance().getPummelChance(), this.getPlayer(), SubSkillType.TAMING_PUMMEL))) {
            return;
        }
        ParticleEffectUtils.playGreaterImpactEffect(livingEntity);
        livingEntity.setVelocity(wolf.getLocation().getDirection().normalize().multiply(1.5));
        if (livingEntity instanceof Player && NotificationManager.doesPlayerUseNotifications(player = (Player)livingEntity)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Taming.SubSkill.Pummel.TargetMessage");
        }
    }

    public void attackTarget(LivingEntity livingEntity) {
        Tameable tameable;
        if (livingEntity instanceof Tameable && (tameable = (Tameable)livingEntity).getOwner() == this.getPlayer()) {
            return;
        }
        double d = 5.0;
        Player player = this.getPlayer();
        for (Entity entity : player.getNearbyEntities(d, d, d)) {
            Wolf wolf;
            if (entity.getType() != EntityType.WOLF || !(wolf = (Wolf)entity).isTamed() || wolf.getOwner() != player || wolf.isSitting()) continue;
            wolf.setTarget(livingEntity);
        }
    }

    private void processCallOfTheWild() {
        if (this.lastSummonTimeStamp + 150L > System.currentTimeMillis()) {
            return;
        }
        this.lastSummonTimeStamp = System.currentTimeMillis();
        Player player = this.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (this.isCOTWItem(itemStack)) {
            CallOfTheWildType callOfTheWildType = summoningItems.get(itemStack.getType());
            TamingSummon tamingSummon = cotwSummonDataProperties.get((Object)callOfTheWildType);
            int n = 0;
            if (itemStack.getAmount() >= tamingSummon.getItemAmountRequired()) {
                int n2;
                Location location = Misc.getLocationOffset(player.getLocation(), 1.0);
                for (n2 = 0; n2 < tamingSummon.getEntitiesSummoned(); ++n2) {
                    if (this.getAmountCurrentlySummoned(callOfTheWildType) >= tamingSummon.getSummonCap()) {
                        NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.Limit", String.valueOf(tamingSummon.getSummonCap()), StringUtils.getCapitalized(callOfTheWildType.toString()));
                        break;
                    }
                    location = Misc.getLocationOffset(location, 1.0);
                    this.spawnCOTWEntity(callOfTheWildType, location, tamingSummon.getEntityType());
                    if (tamingSummon.getSummonLifespan() > 0) {
                        NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.Success.WithLifespan", StringUtils.getCapitalized(callOfTheWildType.toString()), String.valueOf(tamingSummon.getSummonLifespan()));
                    } else {
                        NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.Success.WithoutLifespan", StringUtils.getCapitalized(callOfTheWildType.toString()));
                    }
                    SoundManager.sendSound(player, player.getLocation(), SoundType.ABILITY_ACTIVATED_GENERIC);
                    ++n;
                }
                if (n >= 1) {
                    n2 = itemStack.getAmount() - tamingSummon.getItemAmountRequired();
                    itemStack.setAmount(n2);
                    player.updateInventory();
                }
            } else {
                int n3 = tamingSummon.getItemAmountRequired() - itemStack.getAmount();
                NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.NeedMoreItems", String.valueOf(n3), StringUtils.getPrettyItemString(itemStack.getType()));
            }
        }
    }

    private void spawnCOTWEntity(CallOfTheWildType callOfTheWildType, Location location, EntityType entityType) {
        switch (callOfTheWildType) {
            case CAT: {
                this.spawnCat(location, entityType);
                break;
            }
            case HORSE: {
                this.spawnHorse(location);
                break;
            }
            case WOLF: {
                this.spawnWolf(location);
            }
        }
    }

    private void spawnWolf(Location location) {
        LivingEntity livingEntity = (LivingEntity)this.getPlayer().getWorld().spawnEntity(location, EntityType.WOLF);
        this.applyMetaDataToCOTWEntity(livingEntity);
        this.setBaseCOTWEntityProperties(livingEntity);
        ((Wolf)livingEntity).setAdult();
        this.addToTracker(livingEntity, CallOfTheWildType.WOLF);
        livingEntity.setMaxHealth(20.0);
        livingEntity.setHealth(livingEntity.getMaxHealth());
        livingEntity.setCustomName(LocaleLoader.getString("Taming.Summon.Name.Format", this.getPlayer().getName(), StringUtils.getPrettyEntityTypeString(EntityType.WOLF)));
    }

    private void spawnCat(Location location, EntityType entityType) {
        LivingEntity livingEntity = (LivingEntity)this.getPlayer().getWorld().spawnEntity(location, entityType);
        this.applyMetaDataToCOTWEntity(livingEntity);
        this.setBaseCOTWEntityProperties(livingEntity);
        this.addToTracker(livingEntity, CallOfTheWildType.CAT);
        if (livingEntity instanceof Ocelot) {
            int n = Ocelot.Type.values().length;
            ((Ocelot)livingEntity).setCatType(Ocelot.Type.values()[Misc.getRandom().nextInt(n)]);
            ((Ocelot)livingEntity).setAdult();
        } else if (livingEntity instanceof Cat) {
            int n = Cat.Type.values().length;
            ((Cat)livingEntity).setCatType(Cat.Type.values()[Misc.getRandom().nextInt(n)]);
            ((Cat)livingEntity).setAdult();
        }
        livingEntity.setCustomName(LocaleLoader.getString("Taming.Summon.Name.Format", this.getPlayer().getName(), StringUtils.getPrettyEntityTypeString(entityType)));
        ParticleEffectUtils.playCallOfTheWildEffect(livingEntity);
    }

    private void spawnHorse(Location location) {
        LivingEntity livingEntity = (LivingEntity)this.getPlayer().getWorld().spawnEntity(location, EntityType.HORSE);
        this.applyMetaDataToCOTWEntity(livingEntity);
        this.setBaseCOTWEntityProperties(livingEntity);
        this.addToTracker(livingEntity, CallOfTheWildType.HORSE);
        Horse horse = (Horse)livingEntity;
        livingEntity.setMaxHealth(15.0 + Misc.getRandom().nextDouble() * 15.0);
        livingEntity.setHealth(livingEntity.getMaxHealth());
        horse.setColor(Horse.Color.values()[Misc.getRandom().nextInt(Horse.Color.values().length)]);
        horse.setStyle(Horse.Style.values()[Misc.getRandom().nextInt(Horse.Style.values().length)]);
        horse.setJumpStrength(Math.max(AdvancedConfig.getInstance().getMinHorseJumpStrength(), Math.min(Math.min(Misc.getRandom().nextDouble(), Misc.getRandom().nextDouble()) * 2.0, AdvancedConfig.getInstance().getMaxHorseJumpStrength())));
        horse.setAdult();
        livingEntity.setCustomName(LocaleLoader.getString("Taming.Summon.Name.Format", this.getPlayer().getName(), StringUtils.getPrettyEntityTypeString(EntityType.HORSE)));
        ParticleEffectUtils.playCallOfTheWildEffect(livingEntity);
    }

    private void setBaseCOTWEntityProperties(LivingEntity livingEntity) {
        ((Tameable)livingEntity).setOwner((AnimalTamer)this.getPlayer());
        livingEntity.setRemoveWhenFarAway(false);
    }

    private void applyMetaDataToCOTWEntity(LivingEntity livingEntity) {
        livingEntity.setMetadata("mcMMO: Spawned Entity", (MetadataValue)mcMMO.metadataValue);
        livingEntity.setMetadata("mcMMO: COTW Entity", (MetadataValue)mcMMO.metadataValue);
    }

    public boolean isCOTWItem(ItemStack itemStack) {
        return summoningItems.containsKey(itemStack.getType());
    }

    private int getAmountCurrentlySummoned(CallOfTheWildType callOfTheWildType) {
        this.recalibrateTracker();
        return this.playerSummonedEntities.get((Object)callOfTheWildType).size();
    }

    private void addToTracker(LivingEntity livingEntity, CallOfTheWildType callOfTheWildType) {
        TrackedTamingEntity trackedTamingEntity = new TrackedTamingEntity(livingEntity, callOfTheWildType, this);
        this.playerSummonedEntities.get((Object)callOfTheWildType).add(trackedTamingEntity);
    }

    public List<TrackedTamingEntity> getTrackedEntities(CallOfTheWildType callOfTheWildType) {
        return this.playerSummonedEntities.get((Object)callOfTheWildType);
    }

    public void removeFromTracker(TrackedTamingEntity trackedTamingEntity) {
        if (this.playerSummonedEntities.get((Object)trackedTamingEntity.getCallOfTheWildType()).contains((Object)trackedTamingEntity)) {
            this.playerSummonedEntities.get((Object)trackedTamingEntity.getCallOfTheWildType()).remove((Object)trackedTamingEntity);
        }
        NotificationManager.sendPlayerInformationChatOnly(this.getPlayer(), "Taming.Summon.COTW.TimeExpired", StringUtils.getPrettyEntityTypeString(trackedTamingEntity.getLivingEntity().getType()));
    }

    private void recalibrateTracker() {
        for (CallOfTheWildType callOfTheWildType : CallOfTheWildType.values()) {
            ArrayList<TrackedTamingEntity> arrayList = this.getValidTrackedEntities(callOfTheWildType);
            this.playerSummonedEntities.put(callOfTheWildType, arrayList);
        }
    }

    private ArrayList<TrackedTamingEntity> getValidTrackedEntities(CallOfTheWildType callOfTheWildType) {
        ArrayList<TrackedTamingEntity> arrayList = new ArrayList<TrackedTamingEntity>();
        for (TrackedTamingEntity trackedTamingEntity : this.getTrackedEntities(callOfTheWildType)) {
            LivingEntity livingEntity = trackedTamingEntity.getLivingEntity();
            if (livingEntity == null || !livingEntity.isValid()) continue;
            arrayList.add(trackedTamingEntity);
        }
        return arrayList;
    }

    public void cleanupAllSummons() {
        for (List<TrackedTamingEntity> list : this.playerSummonedEntities.values()) {
            for (TrackedTamingEntity trackedTamingEntity : list) {
                LivingEntity livingEntity = trackedTamingEntity.getLivingEntity();
                if (livingEntity == null || !livingEntity.isValid()) continue;
                livingEntity.setHealth(0.0);
                livingEntity.remove();
            }
            list.clear();
        }
    }
}

