/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.taming;

import com.gmail.nossr50.config.AdvancedConfig;
import org.bukkit.EntityEffect;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;

public class Taming {
    public static double fastFoodServiceActivationChance = AdvancedConfig.getInstance().getFastFoodChance();
    public static int goreBleedTicks = 2;
    public static double goreModifier = AdvancedConfig.getInstance().getGoreModifier();
    public static double sharpenedClawsBonusDamage = AdvancedConfig.getInstance().getSharpenedClawsBonus();
    public static double shockProofModifier = AdvancedConfig.getInstance().getShockProofModifier();
    public static double thickFurModifier = AdvancedConfig.getInstance().getThickFurModifier();

    public static boolean canPreventDamage(Tameable tameable, AnimalTamer animalTamer) {
        return tameable.isTamed() && animalTamer instanceof Player && tameable instanceof Wolf;
    }

    public static double processThickFur(Wolf wolf, double d) {
        wolf.playEffect(EntityEffect.WOLF_SHAKE);
        return d / thickFurModifier;
    }

    public static void processThickFurFire(Wolf wolf) {
        wolf.playEffect(EntityEffect.WOLF_SMOKE);
        wolf.setFireTicks(0);
    }

    public static double processShockProof(Wolf wolf, double d) {
        wolf.playEffect(EntityEffect.WOLF_SHAKE);
        return d / shockProofModifier;
    }

    public static void processHolyHound(Wolf wolf, double d) {
        double d2 = Math.min(wolf.getHealth() + d, wolf.getMaxHealth());
        wolf.setHealth(d2);
        wolf.playEffect(EntityEffect.WOLF_HEARTS);
    }

    protected static String getCallOfTheWildFailureMessage(EntityType entityType) {
        switch (entityType) {
            case OCELOT: {
                return "Taming.Summon.Fail.Ocelot";
            }
            case WOLF: {
                return "Taming.Summon.Fail.Wolf";
            }
            case HORSE: {
                return "Taming.Summon.Fail.Horse";
            }
        }
        return "";
    }
}

