/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.swords;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.swords.Swords;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class SwordsManager
extends SkillManager {
    public SwordsManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.SWORDS);
    }

    public boolean canActivateAbility() {
        return this.mcMMOPlayer.getToolPreparationMode(ToolType.SWORD) && Permissions.serratedStrikes((Permissible)this.getPlayer());
    }

    public boolean canUseStab() {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SWORDS_STAB) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_STAB);
    }

    public boolean canUseRupture() {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SWORDS_RUPTURE) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_RUPTURE);
    }

    public boolean canUseCounterAttack(Entity entity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_COUNTER_ATTACK)) {
            return false;
        }
        return entity instanceof LivingEntity && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SWORDS_COUNTER_ATTACK);
    }

    public boolean canUseSerratedStrike() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_SERRATED_STRIKES)) {
            return false;
        }
        return this.mcMMOPlayer.getAbilityMode(SuperAbilityType.SERRATED_STRIKES);
    }

    public void ruptureCheck(LivingEntity livingEntity) {
        if (RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.SWORDS_RUPTURE, this.getPlayer())) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.isBlocking()) {
                    return;
                }
                if (NotificationManager.doesPlayerUseNotifications(player) && !BleedTimerTask.isBleeding((LivingEntity)player)) {
                    NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Bleeding.Started");
                }
            }
            BleedTimerTask.add(livingEntity, (LivingEntity)this.getPlayer(), this.getRuptureBleedTicks(), RankUtils.getRank(this.getPlayer(), SubSkillType.SWORDS_RUPTURE), this.getToolTier(this.getPlayer().getInventory().getItemInMainHand()));
            if (this.mcMMOPlayer.useChatNotifications()) {
                NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Bleeding");
            }
        }
    }

    public double getStabDamage() {
        int n = RankUtils.getRank(this.getPlayer(), SubSkillType.SWORDS_STAB);
        if (n > 0) {
            double d = 1.0 + (double)n * 1.5;
            return d;
        }
        return 0.0;
    }

    public int getToolTier(ItemStack itemStack) {
        if (ItemUtils.isDiamondTool(itemStack)) {
            return 4;
        }
        if (ItemUtils.isIronTool(itemStack) || ItemUtils.isGoldTool(itemStack)) {
            return 3;
        }
        if (ItemUtils.isStoneTool(itemStack)) {
            return 2;
        }
        return 1;
    }

    public int getRuptureBleedTicks() {
        int n = 2 * RankUtils.getRank(this.getPlayer(), SubSkillType.SWORDS_RUPTURE);
        if (n > Swords.bleedMaxTicks) {
            n = Swords.bleedMaxTicks;
        }
        return n;
    }

    public void counterAttackChecks(LivingEntity livingEntity, double d) {
        if (RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.SWORDS_COUNTER_ATTACK, this.getPlayer())) {
            CombatUtils.dealDamage(livingEntity, d / Swords.counterAttackModifier, (LivingEntity)this.getPlayer());
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Countered");
            if (livingEntity instanceof Player) {
                NotificationManager.sendPlayerInformation((Player)livingEntity, NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Counter.Hit");
            }
        }
    }

    public void serratedStrikes(LivingEntity livingEntity, double d, Map<EntityDamageEvent.DamageModifier, Double> map) {
        CombatUtils.applyAbilityAoE(this.getPlayer(), livingEntity, d / Swords.serratedStrikesModifier, map, this.skill);
    }
}

