/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.smelting;

import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.smelting.Smelting;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class SmeltingManager
extends SkillManager {
    public SmeltingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.SMELTING);
    }

    public boolean isSecondSmeltSuccessful() {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SMELTING_SECOND_SMELT) && RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.SMELTING_SECOND_SMELT, this.getPlayer());
    }

    public int fuelEfficiency(int n) {
        return n * this.getFuelEfficiencyMultiplier();
    }

    public int getFuelEfficiencyMultiplier() {
        switch (RankUtils.getRank(this.getPlayer(), SubSkillType.SMELTING_FUEL_EFFICIENCY)) {
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public ItemStack smeltProcessing(ItemStack itemStack, ItemStack itemStack2) {
        this.applyXpGain(Smelting.getResourceXp(itemStack), XPGainReason.PVE, XPGainSource.PASSIVE);
        if (this.isSecondSmeltSuccessful()) {
            ItemStack itemStack3 = itemStack2.clone();
            itemStack3.setAmount(itemStack2.getAmount() + 1);
            return itemStack3;
        }
        return itemStack2;
    }

    public int vanillaXPBoost(int n) {
        return n * this.getVanillaXpMultiplier();
    }

    public int getVanillaXpMultiplier() {
        return Math.max(1, RankUtils.getRank(this.getPlayer(), SubSkillType.SMELTING_UNDERSTANDING_THE_ART));
    }
}

