/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.salvage;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceSkillStatic;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;

public class SalvageManager
extends SkillManager {
    private boolean placedAnvil;
    private int lastClick;

    public SalvageManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.SALVAGE);
    }

    public void placedAnvilCheck() {
        Player player = this.getPlayer();
        if (this.getPlacedAnvil()) {
            return;
        }
        if (Config.getInstance().getSalvageAnvilMessagesEnabled()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Salvage.Listener.Anvil");
        }
        if (Config.getInstance().getSalvageAnvilPlaceSoundsEnabled()) {
            SoundManager.sendSound(player, player.getLocation(), SoundType.ANVIL);
        }
        this.togglePlacedAnvil();
    }

    public void handleSalvage(Location location, ItemStack itemStack) {
        Player player = this.getPlayer();
        Salvageable salvageable = mcMMO.getSalvageableManager().getSalvageable(itemStack.getType());
        if (itemStack.getItemMeta().isUnbreakable()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Anvil.Unbreakable");
            return;
        }
        if (!Permissions.salvageItemType((Permissible)player, salvageable.getSalvageItemType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        if (!Permissions.salvageMaterialType((Permissible)player, salvageable.getSalvageMaterialType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        if (!RankUtils.hasUnlockedSubskill(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Salvage.Skills.Adept.Level", String.valueOf(RankUtils.getUnlockLevel(SubSkillType.SALVAGE_ARCANE_SALVAGE)), StringUtils.getPrettyItemString(itemStack.getType()));
            return;
        }
        int n = Salvage.calculateSalvageableAmount(itemStack.getDurability(), salvageable.getMaximumDurability(), salvageable.getMaximumQuantity());
        if (n <= 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Salvage.Skills.TooDamaged");
            return;
        }
        n = Math.min(n, this.getSalvageLimit());
        player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        location.add(0.5, 1.0, 0.5);
        Map map = itemStack.getEnchantments();
        ItemStack itemStack2 = null;
        if (!map.isEmpty()) {
            itemStack2 = this.arcaneSalvageCheck(map);
        }
        int n2 = 1;
        int n3 = 99;
        for (int i = 0; i < n - 1; ++i) {
            if (!RandomChanceUtil.rollDice(n3, 100)) continue;
            Math.max(n3 -= 2, 95);
            ++n2;
        }
        if (n2 == n && n != 1 && RankUtils.isPlayerMaxRankInSubSkill(player, SubSkillType.SALVAGE_ARCANE_SALVAGE)) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.Lottery.Perfect", String.valueOf(n2), StringUtils.getPrettyItemString(itemStack.getType()));
        } else if (salvageable.getMaximumQuantity() == 1 || this.getSalvageLimit() >= salvageable.getMaximumQuantity()) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.Lottery.Normal", String.valueOf(n2), StringUtils.getPrettyItemString(itemStack.getType()));
        } else {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.Lottery.Untrained", String.valueOf(n2), StringUtils.getPrettyItemString(itemStack.getType()));
        }
        ItemStack itemStack3 = new ItemStack(salvageable.getSalvageMaterial(), n2);
        if (EventUtils.callSalvageCheckEvent(player, itemStack, itemStack3, itemStack2).isCancelled()) {
            return;
        }
        Location location2 = location.clone();
        Location location3 = player.getLocation().clone();
        double d = location2.distance(location3);
        double d2 = 0.6;
        double d3 = 0.3;
        double d4 = Math.min(d2, Math.max(d3, d * 0.2));
        location2.add(0.0, 0.1, 0.0);
        if (itemStack2 != null) {
            Misc.spawnItemTowardsLocation(location2.clone(), location3.clone(), itemStack2, d4);
        }
        Misc.spawnItemTowardsLocation(location2.clone(), location3.clone(), itemStack3, d4);
        if (Config.getInstance().getSalvageAnvilUseSoundsEnabled()) {
            SoundManager.sendSound(player, player.getLocation(), SoundType.ITEM_BREAK);
        }
        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Salvage.Skills.Success");
    }

    public int getSalvageLimit() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.SALVAGE_SCRAP_COLLECTOR);
    }

    public int getArcaneSalvageRank() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.SALVAGE_ARCANE_SALVAGE);
    }

    public double getExtractFullEnchantChance() {
        if (Permissions.hasSalvageEnchantBypassPerk((Permissible)this.getPlayer())) {
            return 100.0;
        }
        return AdvancedConfig.getInstance().getArcaneSalvageExtractFullEnchantsChance(this.getArcaneSalvageRank());
    }

    public double getExtractPartialEnchantChance() {
        return AdvancedConfig.getInstance().getArcaneSalvageExtractPartialEnchantsChance(this.getArcaneSalvageRank());
    }

    private ItemStack arcaneSalvageCheck(Map<Enchantment, Integer> map) {
        Player player = this.getPlayer();
        if (!RankUtils.hasUnlockedSubskill(player, SubSkillType.SALVAGE_ARCANE_SALVAGE) || !Permissions.arcaneSalvage((Permissible)player)) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.ArcaneFailed", new String[0]);
            return null;
        }
        ItemStack itemStack = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemStack.getItemMeta();
        boolean bl = false;
        int n = 0;
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            int n2 = entry.getValue();
            if (!ExperienceConfig.getInstance().allowUnsafeEnchantments() && n2 > entry.getKey().getMaxLevel()) {
                n2 = entry.getKey().getMaxLevel();
            }
            if (!Salvage.arcaneSalvageEnchantLoss || Permissions.hasSalvageEnchantBypassPerk((Permissible)player) || RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(this.getExtractFullEnchantChance(), this.getPlayer(), SubSkillType.SALVAGE_ARCANE_SALVAGE))) {
                enchantmentStorageMeta.addStoredEnchant(entry.getKey(), n2, true);
                continue;
            }
            if (n2 > 1 && Salvage.arcaneSalvageDowngrades && RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(this.getExtractPartialEnchantChance(), this.getPlayer(), SubSkillType.SALVAGE_ARCANE_SALVAGE))) {
                enchantmentStorageMeta.addStoredEnchant(entry.getKey(), n2 - 1, true);
                bl = true;
                continue;
            }
            ++n;
        }
        if (this.failedAllEnchants(n, map.entrySet().size())) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.ArcaneFailed", new String[0]);
            return null;
        }
        if (bl) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.ArcanePartial", new String[0]);
        }
        itemStack.setItemMeta((ItemMeta)enchantmentStorageMeta);
        return itemStack;
    }

    private boolean failedAllEnchants(int n, int n2) {
        return n == n2;
    }

    public boolean checkConfirmation(boolean bl) {
        Player player = this.getPlayer();
        long l = this.getLastAnvilUse();
        if (!SkillUtils.cooldownExpired(l, 3) || !Config.getInstance().getSalvageConfirmRequired()) {
            return true;
        }
        if (!bl) {
            return false;
        }
        this.actualizeLastAnvilUse();
        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Skills.ConfirmOrCancel", LocaleLoader.getString("Salvage.Pretty.Name"));
        return false;
    }

    public boolean getPlacedAnvil() {
        return this.placedAnvil;
    }

    public void togglePlacedAnvil() {
        this.placedAnvil = !this.placedAnvil;
    }

    public int getLastAnvilUse() {
        return this.lastClick;
    }

    public void setLastAnvilUse(int n) {
        this.lastClick = n;
    }

    public void actualizeLastAnvilUse() {
        this.lastClick = (int)(System.currentTimeMillis() / 1000L);
    }
}

