/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.repair.repairables;

import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class SimpleRepairable
implements Repairable {
    private final Material itemMaterial;
    private final Material repairMaterial;
    private final int minimumLevel;
    private final short maximumDurability;
    private String repairMaterialPrettyName;
    private final ItemType repairItemType;
    private final MaterialType repairMaterialType;
    private final double xpMultiplier;
    private int minQuantity = -1;

    protected SimpleRepairable(Material material, Material material2, String string, int n, short s, ItemType itemType, MaterialType materialType, double d) {
        this.itemMaterial = material;
        this.repairMaterial = material2;
        this.repairMaterialPrettyName = string;
        this.repairItemType = itemType;
        this.repairMaterialType = materialType;
        this.minimumLevel = n;
        this.maximumDurability = s;
        this.xpMultiplier = d;
    }

    protected SimpleRepairable(Material material, Material material2, String string, int n, short s, ItemType itemType, MaterialType materialType, double d, int n2) {
        this.itemMaterial = material;
        this.repairMaterial = material2;
        this.repairMaterialPrettyName = string;
        this.repairItemType = itemType;
        this.repairMaterialType = materialType;
        this.minimumLevel = n;
        this.maximumDurability = s;
        this.xpMultiplier = d;
        this.minQuantity = n2;
    }

    @Override
    public Material getItemMaterial() {
        return this.itemMaterial;
    }

    @Override
    public Material getRepairMaterial() {
        return this.repairMaterial;
    }

    @Override
    public String getRepairMaterialPrettyName() {
        return this.repairMaterialPrettyName;
    }

    @Override
    public ItemType getRepairItemType() {
        return this.repairItemType;
    }

    @Override
    public MaterialType getRepairMaterialType() {
        return this.repairMaterialType;
    }

    @Override
    public int getMinimumQuantity() {
        if (this.minQuantity == -1) {
            return Math.max(SkillUtils.getRepairAndSalvageQuantities(this.itemMaterial, this.repairMaterial), 1);
        }
        return this.minQuantity;
    }

    @Override
    public short getMaximumDurability() {
        return this.maximumDurability;
    }

    @Override
    public short getBaseRepairDurability(ItemStack itemStack) {
        return (short)(this.maximumDurability / this.getMinimumQuantity());
    }

    @Override
    public int getMinimumLevel() {
        return this.minimumLevel;
    }

    @Override
    public double getXpMultiplier() {
        return this.xpMultiplier;
    }
}

