/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.repair;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.repair.ArcaneForging;
import com.gmail.nossr50.skills.repair.Repair;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceSkillStatic;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;

public class RepairManager
extends SkillManager {
    private boolean placedAnvil;
    private int lastClick;

    public RepairManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.REPAIR);
    }

    public void placedAnvilCheck() {
        Player player = this.getPlayer();
        if (this.getPlacedAnvil()) {
            return;
        }
        if (Config.getInstance().getRepairAnvilMessagesEnabled()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Repair.Listener.Anvil");
        }
        if (Config.getInstance().getRepairAnvilPlaceSoundsEnabled()) {
            SoundManager.sendSound(player, player.getLocation(), SoundType.ANVIL);
        }
        this.togglePlacedAnvil();
    }

    public void handleRepair(ItemStack itemStack) {
        int n;
        Player player = this.getPlayer();
        Repairable repairable = mcMMO.getRepairableManager().getRepairable(itemStack.getType());
        if (itemStack.getItemMeta().isUnbreakable()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Anvil.Unbreakable");
            return;
        }
        if (!Permissions.repairMaterialType((Permissible)player, repairable.getRepairMaterialType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        if (!Permissions.repairItemType((Permissible)player, repairable.getRepairItemType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        int n2 = this.getSkillLevel();
        if (n2 < (n = repairable.getMinimumLevel())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Skills.Adept", String.valueOf(n), StringUtils.getPrettyItemString(itemStack.getType()));
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        Material material = repairable.getRepairMaterial();
        ItemStack itemStack2 = new ItemStack(material);
        short s = itemStack.getDurability();
        if (s <= 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Skills.FullDurability");
            return;
        }
        if (!playerInventory.contains(material)) {
            String string = repairable.getRepairMaterialPrettyName() == null ? StringUtils.getPrettyItemString(material) : repairable.getRepairMaterialPrettyName();
            String string2 = "";
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Skills.NeedMore.Extra", string, string2);
            return;
        }
        if (itemStack.getAmount() != 1) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Skills.StackedItems");
            return;
        }
        SkillUtils.removeAbilityBuff(itemStack);
        short s2 = repairable.getBaseRepairDurability(itemStack);
        short s3 = this.repairCalculate(s, s2);
        if (EventUtils.callRepairCheckEvent(player, (short)(s - s3), itemStack2, itemStack).isCancelled()) {
            return;
        }
        if (ArcaneForging.arcaneForgingEnchantLoss && !Permissions.hasRepairEnchantBypassPerk((Permissible)player)) {
            this.addEnchants(itemStack);
        }
        itemStack2 = playerInventory.getItem(playerInventory.first(material)).clone();
        itemStack2.setAmount(1);
        playerInventory.removeItem(new ItemStack[]{itemStack2});
        this.applyXpGain((float)((double)this.getPercentageRepaired(s, s3, repairable.getMaximumDurability()) * repairable.getXpMultiplier() * ExperienceConfig.getInstance().getRepairXPBase() * ExperienceConfig.getInstance().getRepairXP(repairable.getRepairMaterialType())), XPGainReason.PVE);
        if (Config.getInstance().getRepairAnvilUseSoundsEnabled()) {
            SoundManager.sendSound(player, player.getLocation(), SoundType.ANVIL);
            SoundManager.sendSound(player, player.getLocation(), SoundType.ITEM_BREAK);
        }
        itemStack.setDurability(s3);
    }

    private float getPercentageRepaired(short s, short s2, short s3) {
        return (float)(s - s2) / (float)s3;
    }

    public boolean checkConfirmation(boolean bl) {
        Player player = this.getPlayer();
        long l = this.getLastAnvilUse();
        if (!SkillUtils.cooldownExpired(l, 3) || !Config.getInstance().getRepairConfirmRequired()) {
            return true;
        }
        if (!bl) {
            return false;
        }
        this.actualizeLastAnvilUse();
        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Skills.ConfirmOrCancel", LocaleLoader.getString("Repair.Pretty.Name"));
        return false;
    }

    public int getArcaneForgingRank() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.REPAIR_ARCANE_FORGING);
    }

    public double getKeepEnchantChance() {
        return AdvancedConfig.getInstance().getArcaneForgingKeepEnchantsChance(this.getArcaneForgingRank());
    }

    public double getDowngradeEnchantChance() {
        return AdvancedConfig.getInstance().getArcaneForgingDowngradeChance(this.getArcaneForgingRank());
    }

    private short repairCalculate(short s, int n) {
        Player player = this.getPlayer();
        if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.REPAIR_REPAIR_MASTERY) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.REPAIR_REPAIR_MASTERY)) {
            double d = Repair.repairMasteryMaxBonus / 100.0;
            double d2 = Repair.repairMasteryMaxBonus / (double)Repair.repairMasteryMaxBonusLevel * ((double)this.getSkillLevel() / 100.0);
            double d3 = (double)n * Math.min(d2, d);
            n = (int)((double)n + d3);
        }
        if (Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.REPAIR_SUPER_REPAIR) && this.checkPlayerProcRepair()) {
            n = (int)((double)n * 2.0);
        }
        if (n <= 0 || n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        return (short)Math.max(s - n, 0);
    }

    private boolean checkPlayerProcRepair() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.REPAIR_SUPER_REPAIR)) {
            return false;
        }
        if (RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.REPAIR_SUPER_REPAIR, this.getPlayer())) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Repair.Skills.FeltEasy");
            return true;
        }
        return false;
    }

    private void addEnchants(ItemStack itemStack) {
        Player player = this.getPlayer();
        Map map = itemStack.getEnchantments();
        if (map.isEmpty()) {
            return;
        }
        if (Permissions.arcaneBypass((Permissible)player)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Repair.Arcane.Perfect");
            return;
        }
        if (this.getArcaneForgingRank() == 0 || !Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.REPAIR_ARCANE_FORGING)) {
            for (Enchantment enchantment : map.keySet()) {
                itemStack.removeEnchantment(enchantment);
            }
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE_FAILED, "Repair.Arcane.Lost");
            return;
        }
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            int n = (Integer)entry.getValue();
            if (!ExperienceConfig.getInstance().allowUnsafeEnchantments() && n > ((Enchantment)entry.getKey()).getMaxLevel()) {
                n = ((Enchantment)entry.getKey()).getMaxLevel();
                itemStack.addEnchantment((Enchantment)entry.getKey(), n);
            }
            Enchantment enchantment = (Enchantment)entry.getKey();
            if (RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(this.getKeepEnchantChance(), this.getPlayer(), SubSkillType.REPAIR_ARCANE_FORGING))) {
                if (!ArcaneForging.arcaneForgingDowngrades || n <= 1 || RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(100.0 - this.getDowngradeEnchantChance(), this.getPlayer(), SubSkillType.REPAIR_ARCANE_FORGING))) continue;
                itemStack.addUnsafeEnchantment(enchantment, n - 1);
                bl = true;
                continue;
            }
            itemStack.removeEnchantment(enchantment);
        }
        Map map2 = itemStack.getEnchantments();
        if (map2.isEmpty()) {
            NotificationManager.sendPlayerInformationChatOnly(this.getPlayer(), "Repair.Arcane.Fail", new String[0]);
        } else if (bl || map2.size() < map.size()) {
            NotificationManager.sendPlayerInformationChatOnly(this.getPlayer(), "Repair.Arcane.Downgrade", new String[0]);
        } else {
            NotificationManager.sendPlayerInformationChatOnly(this.getPlayer(), "Repair.Arcane.Perfect", new String[0]);
        }
    }

    public boolean getPlacedAnvil() {
        return this.placedAnvil;
    }

    public void togglePlacedAnvil() {
        this.placedAnvil = !this.placedAnvil;
    }

    public int getLastAnvilUse() {
        return this.lastClick;
    }

    public void setLastAnvilUse(int n) {
        this.lastClick = n;
    }

    public void actualizeLastAnvilUse() {
        this.lastClick = (int)(System.currentTimeMillis() / 1000L);
    }
}

