/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.mining;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.AbilityCooldownTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.mining.BlastMining;
import com.gmail.nossr50.skills.mining.Mining;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class MiningManager
extends SkillManager {
    public MiningManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.MINING);
    }

    public boolean canUseDemolitionsExpertise() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_DEMOLITIONS_EXPERTISE)) {
            return false;
        }
        return this.getSkillLevel() >= BlastMining.getDemolitionExpertUnlockLevel() && Permissions.demolitionsExpertise((Permissible)this.getPlayer());
    }

    public boolean canDetonate() {
        Player player = this.getPlayer();
        return this.canUseBlastMining() && player.isSneaking() && (ItemUtils.isPickaxe(this.getPlayer().getInventory().getItemInMainHand()) || player.getInventory().getItemInMainHand().getType() == Config.getInstance().getDetonatorItem()) && Permissions.remoteDetonation((Permissible)player);
    }

    public boolean canUseBlastMining() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_BLAST_MINING);
    }

    public boolean canUseBiggerBombs() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_BIGGER_BOMBS)) {
            return false;
        }
        return this.getSkillLevel() >= BlastMining.getBiggerBombsUnlockLevel() && Permissions.biggerBombs((Permissible)this.getPlayer());
    }

    public boolean canDoubleDrop() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_DOUBLE_DROPS) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.MINING_DOUBLE_DROPS);
    }

    public void miningBlockCheck(BlockState blockState) {
        Player player = this.getPlayer();
        this.applyXpGain(Mining.getBlockXp(blockState), XPGainReason.PVE);
        if (!Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.MINING_DOUBLE_DROPS)) {
            return;
        }
        if (this.mcMMOPlayer.getAbilityMode(this.skill.getAbility())) {
            SkillUtils.handleDurabilityChange(this.getPlayer().getInventory().getItemInMainHand(), Config.getInstance().getAbilityToolDamage());
        }
        if (!Config.getInstance().getDoubleDropsEnabled(PrimarySkillType.MINING, blockState.getType()) || !this.canDoubleDrop()) {
            return;
        }
        boolean bl = player.getInventory().getItemInMainHand().containsEnchantment(Enchantment.SILK_TOUCH);
        if (bl && !AdvancedConfig.getInstance().getDoubleDropSilkTouchEnabled()) {
            return;
        }
        if (RandomChanceUtil.checkRandomChanceExecutionSuccess(this.getPlayer(), SubSkillType.MINING_DOUBLE_DROPS, true)) {
            BlockUtils.markDropsAsBonus(blockState, this.mcMMOPlayer.getAbilityMode(this.skill.getAbility()));
        }
    }

    public void remoteDetonation() {
        Player player = this.getPlayer();
        Block block = player.getTargetBlock(BlockUtils.getTransparentBlocks(), 100);
        if (!this.blastMiningCooldownOver() || block.getType() != Material.TNT || !EventUtils.simulateBlockBreak(block, player, true)) {
            return;
        }
        TNTPrimed tNTPrimed = (TNTPrimed)player.getWorld().spawn(block.getLocation(), TNTPrimed.class);
        NotificationManager.sendPlayerInformation(player, NotificationType.SUPER_ABILITY, "Mining.Blast.Boom");
        tNTPrimed.setMetadata("mcMMO: Tracked TNT", (MetadataValue)this.mcMMOPlayer.getPlayerMetadata());
        tNTPrimed.setFuseTicks(0);
        block.setType(Material.AIR);
        this.mcMMOPlayer.setAbilityDATS(SuperAbilityType.BLAST_MINING, System.currentTimeMillis());
        this.mcMMOPlayer.setAbilityInformed(SuperAbilityType.BLAST_MINING, false);
        new AbilityCooldownTask(this.mcMMOPlayer, SuperAbilityType.BLAST_MINING).runTaskLater((Plugin)mcMMO.p, SuperAbilityType.BLAST_MINING.getCooldown() * 20);
    }

    public void blastMiningDropProcessing(float f, List<Block> list) {
        ArrayList<BlockState> arrayList = new ArrayList<BlockState>();
        ArrayList<BlockState> arrayList2 = new ArrayList<BlockState>();
        int n = 0;
        float f2 = (float)(this.getOreBonus() / 100.0);
        float f3 = (float)(this.getDebrisReduction() / 100.0);
        int n2 = this.getDropMultiplier();
        float f4 = f - f3;
        for (Block block : list) {
            BlockState blockState = block.getState();
            if (BlockUtils.isOre(blockState)) {
                arrayList.add(blockState);
                continue;
            }
            arrayList2.add(blockState);
        }
        for (BlockState blockState : arrayList) {
            if (!(Misc.getRandom().nextFloat() < f + f2)) continue;
            if (!mcMMO.getPlaceStore().isTrue(blockState)) {
                n += Mining.getBlockXp(blockState);
            }
            Misc.dropItem(Misc.getBlockCenter(blockState), new ItemStack(blockState.getType()));
            if (mcMMO.getPlaceStore().isTrue(blockState)) continue;
            for (int i = 1; i < n2; ++i) {
                Mining.handleSilkTouchDrops(blockState);
            }
        }
        if (f4 > 0.0f) {
            for (BlockState blockState : arrayList2) {
                if (!(Misc.getRandom().nextFloat() < f4)) continue;
                Misc.dropItems(Misc.getBlockCenter(blockState), blockState.getBlock().getDrops());
            }
        }
        this.applyXpGain(n, XPGainReason.PVE);
    }

    public float biggerBombs(float f) {
        return (float)((double)f + this.getBlastRadiusModifier());
    }

    public double processDemolitionsExpertise(double d) {
        return d * ((100.0 - this.getBlastDamageModifier()) / 100.0);
    }

    public int getBlastMiningTier() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.MINING_BLAST_MINING);
    }

    public double getOreBonus() {
        return MiningManager.getOreBonus(this.getBlastMiningTier());
    }

    public static double getOreBonus(int n) {
        return AdvancedConfig.getInstance().getOreBonus(n);
    }

    public static double getDebrisReduction(int n) {
        return AdvancedConfig.getInstance().getDebrisReduction(n);
    }

    public double getDebrisReduction() {
        return MiningManager.getDebrisReduction(this.getBlastMiningTier());
    }

    public static int getDropMultiplier(int n) {
        return AdvancedConfig.getInstance().getDropMultiplier(n);
    }

    public int getDropMultiplier() {
        return MiningManager.getDropMultiplier(this.getBlastMiningTier());
    }

    public double getBlastRadiusModifier() {
        return BlastMining.getBlastRadiusModifier(this.getBlastMiningTier());
    }

    public double getBlastDamageModifier() {
        return BlastMining.getBlastDamageDecrease(this.getBlastMiningTier());
    }

    private boolean blastMiningCooldownOver() {
        int n = this.mcMMOPlayer.calculateTimeRemaining(SuperAbilityType.BLAST_MINING);
        if (n > 0) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.ABILITY_COOLDOWN, "Skills.TooTired", String.valueOf(n));
            return false;
        }
        return true;
    }
}

