/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.mining;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.MetadataValue;

public class BlastMining {
    public static final int MAXIMUM_REMOTE_DETONATION_DISTANCE = 100;

    public static double getBlastRadiusModifier(int n) {
        return AdvancedConfig.getInstance().getBlastRadiusModifier(n);
    }

    public static double getBlastDamageDecrease(int n) {
        return AdvancedConfig.getInstance().getBlastDamageDecrease(n);
    }

    public static int getDemolitionExpertUnlockLevel() {
        for (int i = 0; i < SubSkillType.MINING_BLAST_MINING.getNumRanks() - 1; ++i) {
            if (!(BlastMining.getBlastDamageDecrease(i + 1) > 0.0)) continue;
            return RankUtils.getRankUnlockLevel(SubSkillType.MINING_BLAST_MINING, i + 1);
        }
        return 0;
    }

    public static int getBiggerBombsUnlockLevel() {
        for (int i = 0; i < SubSkillType.MINING_BLAST_MINING.getNumRanks() - 1; ++i) {
            if (!(BlastMining.getBlastRadiusModifier(i + 1) > 0.0)) continue;
            return RankUtils.getRankUnlockLevel(SubSkillType.MINING_BLAST_MINING, i + 1);
        }
        return 0;
    }

    public static boolean processBlastMiningExplosion(EntityDamageByEntityEvent entityDamageByEntityEvent, TNTPrimed tNTPrimed, Player player) {
        if (!tNTPrimed.hasMetadata("mcMMO: Tracked TNT") || !UserManager.hasPlayerDataKey((Entity)player)) {
            return false;
        }
        Player player2 = mcMMO.p.getServer().getPlayerExact(((MetadataValue)tNTPrimed.getMetadata("mcMMO: Tracked TNT").get(0)).asString());
        if (!player2.equals(player)) {
            return false;
        }
        if (UserManager.getPlayer(player) == null) {
            return false;
        }
        MiningManager miningManager = UserManager.getPlayer(player).getMiningManager();
        if (!miningManager.canUseDemolitionsExpertise()) {
            return false;
        }
        entityDamageByEntityEvent.setDamage(EntityDamageEvent.DamageModifier.BASE, miningManager.processDemolitionsExpertise(entityDamageByEntityEvent.getDamage()));
        if (entityDamageByEntityEvent.getFinalDamage() == 0.0) {
            entityDamageByEntityEvent.setCancelled(true);
            return false;
        }
        return true;
    }
}

