/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.herbalism;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.BlockSnapshot;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.datatypes.treasure.HylianTreasure;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.DelayedHerbalismXPCheckTask;
import com.gmail.nossr50.runnables.skills.HerbalismBlockUpdaterTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.herbalism.Herbalism;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceSkillStatic;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class HerbalismManager
extends SkillManager {
    public HerbalismManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.HERBALISM);
    }

    public boolean canGreenThumbBlock(BlockState blockState) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.HERBALISM_GREEN_THUMB)) {
            return false;
        }
        Player player = this.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        return itemStack.getAmount() > 0 && itemStack.getType() == Material.WHEAT_SEEDS && BlockUtils.canMakeMossy(blockState) && Permissions.greenThumbBlock((Permissible)player, blockState.getType());
    }

    public boolean canUseShroomThumb(BlockState blockState) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.HERBALISM_SHROOM_THUMB)) {
            return false;
        }
        Player player = this.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        Material material = playerInventory.getItemInMainHand().getType();
        return (material == Material.BROWN_MUSHROOM || material == Material.RED_MUSHROOM) && playerInventory.contains(Material.BROWN_MUSHROOM, 1) && playerInventory.contains(Material.RED_MUSHROOM, 1) && BlockUtils.canMakeShroomy(blockState) && Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_SHROOM_THUMB);
    }

    public boolean canUseHylianLuck() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.HERBALISM_HYLIAN_LUCK)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.HERBALISM_HYLIAN_LUCK);
    }

    public boolean canGreenTerraBlock(BlockState blockState) {
        return this.mcMMOPlayer.getAbilityMode(SuperAbilityType.GREEN_TERRA) && BlockUtils.canMakeMossy(blockState);
    }

    public boolean canActivateAbility() {
        return this.mcMMOPlayer.getToolPreparationMode(ToolType.HOE) && Permissions.greenTerra((Permissible)this.getPlayer());
    }

    public boolean isGreenTerraActive() {
        return this.mcMMOPlayer.getAbilityMode(SuperAbilityType.GREEN_TERRA);
    }

    public int farmersDiet(int n) {
        return SkillUtils.handleFoodSkills(this.getPlayer(), n, SubSkillType.HERBALISM_FARMERS_DIET);
    }

    public boolean processGreenTerraBlockConversion(BlockState blockState) {
        ItemStack itemStack;
        Player player = this.getPlayer();
        if (!Permissions.greenThumbBlock((Permissible)player, blockState.getType())) {
            return false;
        }
        PlayerInventory playerInventory = player.getInventory();
        if (!playerInventory.containsAtLeast(itemStack = new ItemStack(Material.WHEAT_SEEDS), 1)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Herbalism.Ability.GTe.NeedMore");
            return false;
        }
        playerInventory.removeItem(new ItemStack[]{itemStack});
        player.updateInventory();
        return Herbalism.convertGreenTerraBlocks(blockState);
    }

    public void processHerbalismBlockBreakEvent(BlockBreakEvent blockBreakEvent) {
        Player player = this.getPlayer();
        if (Config.getInstance().getHerbalismPreventAFK() && player.isInsideVehicle()) {
            return;
        }
        HashSet<Block> hashSet = this.getBrokenHerbalismBlocks(blockBreakEvent);
        this.processHerbalismOnBlocksBroken(blockBreakEvent, hashSet);
    }

    private void processHerbalismOnBlocksBroken(BlockBreakEvent blockBreakEvent, HashSet<Block> hashSet) {
        BlockState blockState = blockBreakEvent.getBlock().getState();
        if (Permissions.greenThumbPlant((Permissible)this.getPlayer(), blockState.getType())) {
            this.processGreenThumbPlants(blockState, this.isGreenTerraActive());
        }
        this.checkDoubleDropsOnBrokenPlants(blockBreakEvent.getPlayer(), hashSet);
        ArrayList<BlockSnapshot> arrayList = new ArrayList<BlockSnapshot>();
        HashSet<Block> hashSet2 = new HashSet<Block>();
        for (Block block : hashSet) {
            if (block.getLocation().equals((Object)blockState.getBlock().getLocation())) {
                if (!mcMMO.getPlaceStore().isTrue(blockState)) {
                    hashSet2.add(block);
                    continue;
                }
                if (this.isChorusTree(block.getType())) {
                    arrayList.add(new BlockSnapshot(block.getType(), block));
                    continue;
                }
                hashSet2.add(block);
                continue;
            }
            if (this.isChorusTree(block.getType())) {
                arrayList.add(new BlockSnapshot(block.getType(), block));
                continue;
            }
            hashSet2.add(block);
        }
        if (hashSet2.size() > 0) {
            this.awardXPForPlantBlocks(hashSet2);
        }
        if (arrayList.size() > 0) {
            Object object = new DelayedHerbalismXPCheckTask(this.mcMMOPlayer, arrayList);
            object.runTaskLater((Plugin)mcMMO.p, 20L);
        }
    }

    public void checkDoubleDropsOnBrokenPlants(Player player, Collection<Block> collection) {
        if (!RankUtils.hasUnlockedSubskill(player, SubSkillType.HERBALISM_DOUBLE_DROPS) || !Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_DOUBLE_DROPS)) {
            return;
        }
        for (Block block : collection) {
            BlockState blockState = block.getState();
            BlockData blockData = blockState.getBlockData();
            if (!mcMMO.getPlaceStore().isTrue(block)) {
                if (blockData instanceof Ageable) {
                    Ageable ageable = (Ageable)blockData;
                    if (!this.isAgeableMature(ageable) && !this.isBizarreAgeable(blockData) || !this.checkDoubleDrop(blockState)) continue;
                    this.markForBonusDrops(blockState);
                    continue;
                }
                if (!this.checkDoubleDrop(blockState)) continue;
                this.markForBonusDrops(blockState);
                continue;
            }
            if (!this.isAgeableAndFullyMature(blockData) || this.isBizarreAgeable(blockData)) continue;
            this.markForBonusDrops(blockState);
        }
    }

    public boolean isBizarreAgeable(BlockData blockData) {
        if (blockData instanceof Ageable) {
            switch (blockData.getMaterial()) {
                case CACTUS: 
                case SUGAR_CANE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void markForBonusDrops(BlockState blockState) {
        boolean bl = this.mcMMOPlayer.getAbilityMode(SuperAbilityType.GREEN_TERRA);
        BlockUtils.markDropsAsBonus(blockState, bl);
    }

    public boolean isAgeableAndFullyMature(BlockData blockData) {
        return blockData instanceof Ageable && this.isAgeableMature((Ageable)blockData);
    }

    public void awardXPForPlantBlocks(HashSet<Block> hashSet) {
        int n = 0;
        for (Block block : hashSet) {
            BlockState blockState = block.getState();
            BlockData blockData = blockState.getBlockData();
            if (mcMMO.getPlaceStore().isTrue(blockState)) {
                if (this.isAgeableAndFullyMature(blockData) && !this.isBizarreAgeable(blockData)) {
                    n += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, blockState.getType());
                }
                mcMMO.getPlaceStore().setFalse(blockState);
                continue;
            }
            if (blockData instanceof Ageable) {
                Ageable ageable = (Ageable)blockData;
                if (!this.isAgeableMature(ageable) && !this.isBizarreAgeable(blockData)) continue;
                n += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, blockState.getType());
                continue;
            }
            n += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, block.getType());
        }
        if (this.mcMMOPlayer.isDebugMode()) {
            this.mcMMOPlayer.getPlayer().sendMessage("Plants processed: " + hashSet.size());
        }
        if (n > 0) {
            this.applyXpGain(n, XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    public boolean isAgeableMature(Ageable ageable) {
        return ageable.getAge() == ageable.getMaximumAge() && ageable.getAge() != 0;
    }

    public void awardXPForBlockSnapshots(ArrayList<BlockSnapshot> arrayList) {
        int n = 0;
        int n2 = 0;
        for (BlockSnapshot blockSnapshot : arrayList) {
            BlockState blockState = blockSnapshot.getBlockRef().getState();
            if (blockState.hasMetadata("mcMMO: Double Drops")) {
                blockState.removeMetadata("mcMMO: Double Drops", (Plugin)mcMMO.p);
            }
            if (blockState.getType() != Material.AIR) continue;
            if (mcMMO.getPlaceStore().isTrue(blockState)) {
                mcMMO.getPlaceStore().setFalse(blockState);
                continue;
            }
            n += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, blockSnapshot.getOldType());
            ++n2;
        }
        if (this.mcMMOPlayer.isDebugMode()) {
            this.mcMMOPlayer.getPlayer().sendMessage("Chorus Plants checked for XP: " + arrayList.size());
            this.mcMMOPlayer.getPlayer().sendMessage("Valid Chorus Plant XP Gains: " + n2);
        }
        if (n > 0) {
            this.applyXpGain(n, XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    private HashSet<Block> getBrokenHerbalismBlocks(BlockBreakEvent blockBreakEvent) {
        BlockState blockState = blockBreakEvent.getBlock().getState();
        Material material = blockState.getType();
        HashSet<Block> hashSet = new HashSet<Block>();
        boolean bl = this.isOneBlockPlant(material);
        if (bl) {
            hashSet.add(blockState.getBlock());
        } else {
            hashSet = this.getBrokenBlocksMultiBlockPlants(blockState, blockBreakEvent);
        }
        return hashSet;
    }

    private HashSet<Block> getBrokenChorusBlocks(BlockState blockState) {
        HashSet<Block> hashSet = this.grabChorusTreeBrokenBlocksRecursive(blockState.getBlock(), new HashSet<Block>());
        return hashSet;
    }

    private HashSet<Block> grabChorusTreeBrokenBlocksRecursive(Block block, HashSet<Block> hashSet) {
        if (!this.isChorusTree(block.getType())) {
            return hashSet;
        }
        if (hashSet.size() > 256) {
            return hashSet;
        }
        if (!hashSet.add(block)) {
            return hashSet;
        }
        for (BlockFace blockFace : new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            this.grabChorusTreeBrokenBlocksRecursive(block.getRelative(blockFace, 1), hashSet);
        }
        hashSet.add(block);
        return hashSet;
    }

    protected HashSet<Block> getBrokenBlocksMultiBlockPlants(BlockState blockState, BlockBreakEvent blockBreakEvent) {
        HashSet<Block> hashSet = this.isChorusBranch(blockState.getType()) ? this.getBrokenChorusBlocks(blockState) : this.getBlocksBrokenAbove(blockState);
        return hashSet;
    }

    private boolean isChorusBranch(Material material) {
        return material == Material.CHORUS_PLANT;
    }

    private boolean isChorusTree(Material material) {
        return material == Material.CHORUS_PLANT || material == Material.CHORUS_FLOWER;
    }

    private HashSet<Block> getBlocksBrokenAbove(BlockState blockState) {
        HashSet<Block> hashSet = new HashSet<Block>();
        Block block = blockState.getBlock();
        hashSet.add(block);
        int n = 255;
        for (int i = 1; i < n; ++i) {
            Block block2 = block.getRelative(BlockFace.UP, i);
            if (!mcMMO.getMaterialMapStore().isMultiBlockPlant(block2.getType())) break;
            hashSet.add(block2);
        }
        return hashSet;
    }

    private boolean isOneBlockPlant(Material material) {
        return !mcMMO.getMaterialMapStore().isMultiBlockPlant(material);
    }

    private boolean checkDoubleDrop(BlockState blockState) {
        return BlockUtils.checkDoubleDrops(this.getPlayer(), blockState, this.skill, SubSkillType.HERBALISM_DOUBLE_DROPS);
    }

    public boolean processGreenThumbBlocks(BlockState blockState) {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.HERBALISM_GREEN_THUMB, this.getPlayer())) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE_FAILED, "Herbalism.Ability.GTh.Fail");
            return false;
        }
        return Herbalism.convertGreenTerraBlocks(blockState);
    }

    public boolean processHylianLuck(BlockState blockState) {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.HERBALISM_HYLIAN_LUCK, this.getPlayer())) {
            return false;
        }
        String string = StringUtils.getFriendlyConfigBlockDataString(blockState.getBlockData());
        if (!TreasureConfig.getInstance().hylianMap.containsKey(string)) {
            return false;
        }
        List<HylianTreasure> list = TreasureConfig.getInstance().hylianMap.get(string);
        Player player = this.getPlayer();
        if (list.isEmpty()) {
            return false;
        }
        int n = this.getSkillLevel();
        Location location = Misc.getBlockCenter(blockState);
        for (HylianTreasure hylianTreasure : list) {
            if (n < hylianTreasure.getDropLevel() || !RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(hylianTreasure.getDropChance(), this.getPlayer(), SubSkillType.HERBALISM_HYLIAN_LUCK))) continue;
            if (!EventUtils.simulateBlockBreak(blockState.getBlock(), player, false)) {
                return false;
            }
            blockState.setType(Material.AIR);
            Misc.dropItem(location, hylianTreasure.getDrop());
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Herbalism.HylianLuck");
            return true;
        }
        return false;
    }

    public boolean processShroomThumb(BlockState blockState) {
        Player player = this.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        if (!playerInventory.contains(Material.BROWN_MUSHROOM, 1)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Skills.NeedMore", StringUtils.getPrettyItemString(Material.BROWN_MUSHROOM));
            return false;
        }
        if (!playerInventory.contains(Material.RED_MUSHROOM, 1)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Skills.NeedMore", StringUtils.getPrettyItemString(Material.RED_MUSHROOM));
            return false;
        }
        playerInventory.removeItem(new ItemStack[]{new ItemStack(Material.BROWN_MUSHROOM)});
        playerInventory.removeItem(new ItemStack[]{new ItemStack(Material.RED_MUSHROOM)});
        player.updateInventory();
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.HERBALISM_SHROOM_THUMB, player)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Herbalism.Ability.ShroomThumb.Fail");
            return false;
        }
        return Herbalism.convertShroomThumb(blockState);
    }

    private void processGreenThumbPlants(BlockState blockState, boolean bl) {
        if (!BlockUtils.isFullyGrown(blockState)) {
            return;
        }
        Player player = this.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        Material material = null;
        switch (blockState.getType()) {
            case CARROTS: {
                material = Material.CARROT;
                break;
            }
            case WHEAT: {
                material = Material.WHEAT_SEEDS;
                break;
            }
            case NETHER_WART: {
                material = Material.NETHER_WART;
                break;
            }
            case POTATOES: {
                material = Material.POTATO;
                break;
            }
            case BEETROOTS: {
                material = Material.BEETROOT_SEEDS;
                break;
            }
            case COCOA: {
                material = Material.COCOA_BEANS;
                break;
            }
            default: {
                return;
            }
        }
        ItemStack itemStack = new ItemStack(material);
        if (!bl && !RandomChanceUtil.checkRandomChanceExecutionSuccess(player, SubSkillType.HERBALISM_GREEN_THUMB, true)) {
            return;
        }
        if (!this.processGrowingPlants(blockState, bl)) {
            return;
        }
        if (!ItemUtils.isHoe(this.getPlayer().getInventory().getItemInMainHand())) {
            if (!playerInventory.containsAtLeast(itemStack, 1)) {
                return;
            }
            playerInventory.removeItem(new ItemStack[]{itemStack});
            player.updateInventory();
        }
        new HerbalismBlockUpdaterTask(blockState).runTaskLater((Plugin)mcMMO.p, 0L);
    }

    private boolean processGrowingPlants(BlockState blockState, boolean bl) {
        int n = this.getGreenThumbStage();
        blockState.setMetadata("mcMMO: Green Thumb", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)((int)(System.currentTimeMillis() / 1000L))));
        Ageable ageable = (Ageable)blockState.getBlockData();
        switch (blockState.getType()) {
            case CARROTS: 
            case WHEAT: 
            case POTATOES: {
                if (bl) {
                    ageable.setAge(3);
                    break;
                }
                ageable.setAge(n);
                break;
            }
            case NETHER_WART: 
            case BEETROOTS: {
                if (bl || n > 2) {
                    ageable.setAge(2);
                    break;
                }
                if (n == 2) {
                    ageable.setAge(1);
                    break;
                }
                ageable.setAge(0);
                break;
            }
            case COCOA: {
                if (bl || this.getGreenThumbStage() > 1) {
                    ageable.setAge(1);
                    break;
                }
                ageable.setAge(0);
                break;
            }
            default: {
                return false;
            }
        }
        blockState.setBlockData((BlockData)ageable);
        return true;
    }

    private int getGreenThumbStage() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.HERBALISM_GREEN_THUMB);
    }
}

