/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.fishing;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.treasure.EnchantmentTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasure;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.datatypes.treasure.ShakeTreasure;
import com.gmail.nossr50.datatypes.treasure.Treasure;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerFishingEvent;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerFishingTreasureEvent;
import com.gmail.nossr50.events.skills.fishing.McMMOPlayerShakeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.fishing.Fishing;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceSkillStatic;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class FishingManager
extends SkillManager {
    public static final int FISHING_ROD_CAST_CD_MILLISECONDS = 100;
    public static final int OVERFISH_LIMIT = 10;
    private final long FISHING_COOLDOWN_SECONDS = 1000L;
    private long fishingRodCastTimestamp = 0L;
    private long fishHookSpawnTimestamp = 0L;
    private long lastWarned = 0L;
    private long lastWarnedExhaust = 0L;
    private FishHook fishHookReference;
    private BoundingBox lastFishingBoundingBox;
    private Item fishingCatch;
    private Location hookLocation;
    private int fishCaughtCounter = 1;

    public FishingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.FISHING);
    }

    public boolean canShake(Entity entity) {
        return entity instanceof LivingEntity && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.FISHING_SHAKE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_SHAKE);
    }

    public boolean canMasterAngler() {
        return this.getSkillLevel() >= RankUtils.getUnlockLevel(SubSkillType.FISHING_MASTER_ANGLER) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_MASTER_ANGLER);
    }

    public void setFishingRodCastTimestamp() {
        long l = System.currentTimeMillis();
        if (l > this.fishHookSpawnTimestamp + 1000L) {
            return;
        }
        if (l < this.fishingRodCastTimestamp + 100L) {
            this.getPlayer().setFoodLevel(Math.max(this.getPlayer().getFoodLevel() - 1, 0));
            this.getPlayer().getInventory().getItemInMainHand().setDurability((short)(this.getPlayer().getInventory().getItemInMainHand().getDurability() + 5));
            this.getPlayer().updateInventory();
            if (this.lastWarnedExhaust + 1000L < l) {
                this.getPlayer().sendMessage(LocaleLoader.getString("Fishing.Exhausting"));
                this.lastWarnedExhaust = l;
                SoundManager.sendSound(this.getPlayer(), this.getPlayer().getLocation(), SoundType.TIRED);
            }
        }
        this.fishingRodCastTimestamp = System.currentTimeMillis();
    }

    public void setFishHookReference(FishHook fishHook) {
        if (fishHook.getMetadata("mcMMO: Fish Hook Tracker").size() > 0) {
            return;
        }
        fishHook.setMetadata("mcMMO: Fish Hook Tracker", (MetadataValue)mcMMO.metadataValue);
        this.fishHookReference = fishHook;
        this.fishHookSpawnTimestamp = System.currentTimeMillis();
        this.fishingRodCastTimestamp = System.currentTimeMillis();
    }

    public boolean isFishingTooOften() {
        long l;
        boolean bl;
        long l2 = System.currentTimeMillis();
        boolean bl2 = bl = l2 < (l = this.fishHookSpawnTimestamp + 1000L);
        if (bl && this.lastWarned + 1000L < l2) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Fishing.Scared"));
            this.lastWarned = System.currentTimeMillis();
        }
        return bl;
    }

    public boolean isExploitingFishing(Vector vector) {
        boolean bl;
        BoundingBox boundingBox = FishingManager.makeBoundingBox(vector);
        boolean bl2 = bl = this.lastFishingBoundingBox != null && this.lastFishingBoundingBox.overlaps(boundingBox);
        this.fishCaughtCounter = bl ? ++this.fishCaughtCounter : 1;
        if (this.fishCaughtCounter + 1 == 10) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Fishing.LowResourcesTip", 3));
        }
        if (!bl) {
            this.lastFishingBoundingBox = boundingBox;
        }
        return bl && this.fishCaughtCounter >= 10;
    }

    public static BoundingBox makeBoundingBox(Vector vector) {
        return BoundingBox.of((Vector)vector, (double)1.0, (double)1.0, (double)1.0);
    }

    public void setFishingTarget() {
        this.getPlayer().getTargetBlock(BlockUtils.getTransparentBlocks(), 100);
    }

    public boolean canIceFish(Block block) {
        if (this.getSkillLevel() < RankUtils.getUnlockLevel(SubSkillType.FISHING_ICE_FISHING)) {
            return false;
        }
        if (block.getType() != Material.ICE) {
            return false;
        }
        if (!Fishing.iceFishingBiomes.contains(block.getBiome()) && block.getRelative(BlockFace.DOWN, 3).getType() != Material.WATER) {
            return false;
        }
        Player player = this.getPlayer();
        if (!Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_ICE_FISHING)) {
            return false;
        }
        return EventUtils.simulateBlockBreak(block, player, false);
    }

    public int getLootTier() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.FISHING_TREASURE_HUNTER);
    }

    public double getShakeChance() {
        return AdvancedConfig.getInstance().getShakeChance(this.getLootTier());
    }

    protected int getVanillaXPBoostModifier() {
        return AdvancedConfig.getInstance().getFishingVanillaXPModifier(this.getLootTier());
    }

    public double getShakeProbability() {
        return this.getShakeChance();
    }

    public int handleFishermanDiet(int n) {
        return SkillUtils.handleFoodSkills(this.getPlayer(), n, SubSkillType.FISHING_FISHERMANS_DIET);
    }

    public void iceFishing(FishHook fishHook, Block block) {
        block.setType(Material.WATER);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Block block2 = block.getRelative(i, 0, j);
                if (block2.getType() != Material.ICE) continue;
                block2.setType(Material.WATER);
            }
        }
        EventUtils.callFakeFishEvent(this.getPlayer(), fishHook);
    }

    public void masterAngler(FishHook fishHook) {
        Player player = this.getPlayer();
        Location location = fishHook.getLocation();
        double d = fishHook.getBiteChance();
        this.hookLocation = location;
        if (Fishing.masterAnglerBiomes.contains(location.getBlock().getBiome())) {
            d *= AdvancedConfig.getInstance().getMasterAnglerBiomeModifier();
        }
        if (player.isInsideVehicle() && player.getVehicle().getType() == EntityType.BOAT) {
            d *= AdvancedConfig.getInstance().getMasterAnglerBoatModifier();
        }
        fishHook.setBiteChance(Math.min(d, 1.0));
    }

    public boolean isMagicHunterEnabled() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.FISHING_MAGIC_HUNTER) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.FISHING_TREASURE_HUNTER) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.FISHING_TREASURE_HUNTER);
    }

    public void handleFishing(Item item) {
        this.fishingCatch = item;
        int n = ExperienceConfig.getInstance().getXp(PrimarySkillType.FISHING, item.getItemStack().getType());
        int n2 = 0;
        Player player = this.getPlayer();
        Treasure treasure = null;
        if (Config.getInstance().getFishingDropsEnabled() && Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.FISHING_TREASURE_HUNTER)) {
            treasure = this.getFishingTreasure();
            this.fishingCatch = null;
        }
        if (treasure != null) {
            McMMOPlayerFishingTreasureEvent mcMMOPlayerFishingTreasureEvent;
            ItemStack itemStack = treasure.getDrop().clone();
            Map<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            if (this.isMagicHunterEnabled() && ItemUtils.isEnchantable(itemStack)) {
                map = this.handleMagicHunter(itemStack);
            }
            if (!(mcMMOPlayerFishingTreasureEvent = EventUtils.callFishingTreasureEvent(player, itemStack, treasure.getXp(), map)).isCancelled()) {
                itemStack = mcMMOPlayerFishingTreasureEvent.getTreasure();
                n2 = mcMMOPlayerFishingTreasureEvent.getXp();
            } else {
                itemStack = null;
                n2 = 0;
            }
            if (itemStack != null) {
                boolean bl = false;
                if (!map.isEmpty()) {
                    itemStack.addUnsafeEnchantments(map);
                    bl = true;
                }
                if (bl) {
                    NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Fishing.Ability.TH.MagicFound");
                }
                if (Config.getInstance().getFishingExtraFish()) {
                    Misc.dropItem(player.getEyeLocation(), item.getItemStack());
                }
                item.setItemStack(itemStack);
            }
        }
        this.applyXpGain(n + n2, XPGainReason.PVE);
    }

    public int handleVanillaXpBoost(int n) {
        return n * this.getVanillaXpMultiplier();
    }

    public Location getHookLocation() {
        return this.hookLocation;
    }

    public void shakeCheck(LivingEntity livingEntity) {
        if (RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(this.getShakeChance(), this.getPlayer(), SubSkillType.FISHING_SHAKE))) {
            Object object;
            List<ShakeTreasure> list = Fishing.findPossibleDrops(livingEntity);
            if (list == null || list.isEmpty()) {
                return;
            }
            ItemStack itemStack = Fishing.chooseDrop(list);
            if (itemStack == null) {
                return;
            }
            switch (livingEntity.getType()) {
                case PLAYER: {
                    object = (Player)livingEntity;
                    switch (itemStack.getType()) {
                        case PLAYER_HEAD: {
                            itemStack.setDurability((short)3);
                            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                            skullMeta.setOwningPlayer((OfflinePlayer)object);
                            itemStack.setItemMeta((ItemMeta)skullMeta);
                            break;
                        }
                        case BEDROCK: {
                            if (!TreasureConfig.getInstance().getInventoryStealEnabled()) break;
                            PlayerInventory playerInventory = object.getInventory();
                            int n = playerInventory.getContents().length;
                            int n2 = Misc.getRandom().nextInt(n);
                            itemStack = playerInventory.getItem(n2);
                            if (itemStack == null) break;
                            if (TreasureConfig.getInstance().getInventoryStealStacks()) {
                                playerInventory.setItem(n2, null);
                            } else {
                                playerInventory.setItem(n2, itemStack.getAmount() > 1 ? new ItemStack(itemStack.getType(), itemStack.getAmount() - 1) : null);
                                itemStack.setAmount(1);
                            }
                            object.updateInventory();
                            break;
                        }
                    }
                    break;
                }
                case SHEEP: {
                    Sheep sheep = (Sheep)livingEntity;
                    if (!itemStack.getType().name().endsWith("WOOL")) break;
                    if (sheep.isSheared()) {
                        return;
                    }
                    sheep.setSheared(true);
                    break;
                }
            }
            object = new McMMOPlayerShakeEvent(this.getPlayer(), itemStack);
            itemStack = ((McMMOPlayerShakeEvent)((Object)object)).getDrop();
            if (((McMMOPlayerFishingEvent)((Object)object)).isCancelled() || itemStack == null) {
                return;
            }
            Misc.dropItem(livingEntity.getLocation(), itemStack);
            CombatUtils.dealDamage(livingEntity, Math.min(Math.max(livingEntity.getMaxHealth() / 4.0, 1.0), 10.0), EntityDamageEvent.DamageCause.CUSTOM, (Entity)this.getPlayer());
            this.applyXpGain(ExperienceConfig.getInstance().getFishingShakeXP(), XPGainReason.PVE);
        }
    }

    private FishingTreasure getFishingTreasure() {
        double d = Misc.getRandom().nextDouble() * 100.0;
        int n = this.getPlayer().getInventory().getItemInMainHand().getType() == Material.FISHING_ROD ? this.getPlayer().getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LUCK) : this.getPlayer().getInventory().getItemInOffHand().getEnchantmentLevel(Enchantment.LUCK);
        d *= 1.0 - (double)n * Config.getInstance().getFishingLureModifier() / 100.0;
        Treasure treasure = null;
        for (Rarity rarity : Rarity.values()) {
            double d2 = TreasureConfig.getInstance().getItemDropRate(this.getLootTier(), rarity);
            if (d <= d2) {
                List<FishingTreasure> list = TreasureConfig.getInstance().fishingRewards.get((Object)rarity);
                if (list.isEmpty()) {
                    return null;
                }
                treasure = list.get(Misc.getRandom().nextInt(list.size()));
                break;
            }
            d -= d2;
        }
        if (treasure == null) {
            return null;
        }
        ItemStack itemStack = treasure.getDrop().clone();
        int n2 = itemStack.getType().getMaxDurability();
        if (n2 > 0) {
            itemStack.setDurability((short)Misc.getRandom().nextInt(n2));
        }
        treasure.setDrop(itemStack);
        return treasure;
    }

    private Map<Enchantment, Integer> handleMagicHunter(ItemStack itemStack) {
        HashMap<Enchantment, Integer> hashMap = new HashMap<Enchantment, Integer>();
        List<EnchantmentTreasure> list = null;
        double d = Misc.getRandom().nextDouble() * 100.0;
        for (Rarity object : Rarity.values()) {
            if (object == Rarity.RECORD) continue;
            double d2 = TreasureConfig.getInstance().getEnchantmentDropRate(this.getLootTier(), object);
            if (d <= d2) {
                if (itemStack.getType() == Material.ENCHANTED_BOOK) {
                    d = d2 + 1.0;
                    continue;
                }
                list = TreasureConfig.getInstance().fishingEnchantments.get((Object)object);
                break;
            }
            d -= d2;
        }
        if (list == null) {
            return hashMap;
        }
        List<Enchantment> list2 = this.getPossibleEnchantments(itemStack);
        ArrayList<EnchantmentTreasure> arrayList = new ArrayList<EnchantmentTreasure>();
        for (EnchantmentTreasure enchantmentTreasure : list) {
            if (!list2.contains(enchantmentTreasure.getEnchantment())) continue;
            arrayList.add(enchantmentTreasure);
        }
        if (arrayList.isEmpty()) {
            return hashMap;
        }
        Collections.shuffle(arrayList, Misc.getRandom());
        int n = 1;
        for (EnchantmentTreasure enchantmentTreasure : arrayList) {
            Enchantment enchantment = enchantmentTreasure.getEnchantment();
            if (itemStack.getItemMeta().hasConflictingEnchant(enchantment) || Misc.getRandom().nextInt(n) != 0) continue;
            hashMap.put(enchantment, enchantmentTreasure.getLevel());
            n *= 2;
        }
        return hashMap;
    }

    private List<Enchantment> getPossibleEnchantments(ItemStack itemStack) {
        Material material = itemStack.getType();
        if (Fishing.ENCHANTABLE_CACHE.containsKey(material)) {
            return Fishing.ENCHANTABLE_CACHE.get(material);
        }
        ArrayList<Enchantment> arrayList = new ArrayList<Enchantment>();
        for (Enchantment enchantment : Enchantment.values()) {
            if (!enchantment.canEnchantItem(itemStack)) continue;
            arrayList.add(enchantment);
        }
        Fishing.ENCHANTABLE_CACHE.put(material, arrayList);
        return arrayList;
    }

    private int getVanillaXpMultiplier() {
        return this.getVanillaXPBoostModifier();
    }
}

