/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.excavation;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.treasure.ExcavationTreasure;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.excavation.Excavation;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class ExcavationManager
extends SkillManager {
    public ExcavationManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.EXCAVATION);
    }

    public void excavationBlockCheck(BlockState blockState) {
        List<ExcavationTreasure> list;
        int n = Excavation.getBlockXP(blockState);
        if (Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.EXCAVATION_ARCHAEOLOGY) && !(list = Excavation.getTreasures(blockState)).isEmpty()) {
            int n2 = this.getSkillLevel();
            Location location = Misc.getBlockCenter(blockState);
            for (ExcavationTreasure excavationTreasure : list) {
                if (n2 < excavationTreasure.getDropLevel() || !RandomChanceUtil.checkRandomChanceExecutionSuccess(this.getPlayer(), PrimarySkillType.EXCAVATION, excavationTreasure.getDropChance())) continue;
                if (RandomChanceUtil.rollDice(this.getArchaelogyExperienceOrbChance(), 100)) {
                    ExperienceOrb experienceOrb = (ExperienceOrb)this.getPlayer().getWorld().spawnEntity(location, EntityType.EXPERIENCE_ORB);
                    experienceOrb.setExperience(this.getExperienceOrbsReward());
                }
                n += excavationTreasure.getXp();
                Misc.dropItem(location, excavationTreasure.getDrop());
            }
        }
        this.applyXpGain(n, XPGainReason.PVE);
    }

    public int getExperienceOrbsReward() {
        return 1 * this.getArchaeologyRank();
    }

    public double getArchaelogyExperienceOrbChance() {
        return this.getArchaeologyRank() * 2;
    }

    public int getArchaeologyRank() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.EXCAVATION_ARCHAEOLOGY);
    }

    public void printExcavationDebug(Player player, BlockState blockState) {
        if (Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.EXCAVATION_ARCHAEOLOGY)) {
            List<ExcavationTreasure> list = Excavation.getTreasures(blockState);
            if (!list.isEmpty()) {
                for (ExcavationTreasure excavationTreasure : list) {
                    player.sendMessage("|||||||||||||||||||||||||||||||||");
                    player.sendMessage("[mcMMO DEBUG] Treasure found: (" + excavationTreasure.getDrop().getType().toString() + ")");
                    player.sendMessage("[mcMMO DEBUG] Drop Chance for Treasure: " + excavationTreasure.getDropChance());
                    player.sendMessage("[mcMMO DEBUG] Skill Level Required: " + excavationTreasure.getDropLevel());
                    player.sendMessage("[mcMMO DEBUG] XP for Treasure: " + excavationTreasure.getXp());
                }
            } else {
                player.sendMessage("[mcMMO DEBUG] No treasures found for this block.");
            }
        }
    }

    public void gigaDrillBreaker(BlockState blockState) {
        this.excavationBlockCheck(blockState);
        this.excavationBlockCheck(blockState);
        SkillUtils.handleDurabilityChange(this.getPlayer().getInventory().getItemInMainHand(), Config.getInstance().getAbilityToolDamage());
    }
}

