/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.child;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public class FamilyTree {
    private static HashMap<PrimarySkillType, Set<PrimarySkillType>> tree = new HashMap();

    public static Set<PrimarySkillType> getParents(PrimarySkillType primarySkillType) {
        FamilyTree.enforceChildSkill(primarySkillType);
        return tree.get((Object)primarySkillType);
    }

    protected static void registerParent(PrimarySkillType primarySkillType, PrimarySkillType primarySkillType2) {
        FamilyTree.enforceChildSkill(primarySkillType);
        FamilyTree.enforceNotChildSkill(primarySkillType2);
        if (!tree.containsKey((Object)primarySkillType)) {
            tree.put(primarySkillType, EnumSet.noneOf(PrimarySkillType.class));
        }
        tree.get((Object)primarySkillType).add(primarySkillType2);
    }

    protected static void closeRegistration() {
        for (PrimarySkillType primarySkillType : tree.keySet()) {
            Set<PrimarySkillType> set = Collections.unmodifiableSet(tree.get((Object)primarySkillType));
            tree.put(primarySkillType, set);
        }
    }

    protected static void clearRegistrations() {
        tree.clear();
    }

    protected static void enforceChildSkill(PrimarySkillType primarySkillType) {
        if (!primarySkillType.isChildSkill()) {
            throw new IllegalArgumentException(primarySkillType.name() + " is not a child skill!");
        }
    }

    protected static void enforceNotChildSkill(PrimarySkillType primarySkillType) {
        if (primarySkillType.isChildSkill()) {
            throw new IllegalArgumentException(primarySkillType.name() + " is a child skill!");
        }
    }
}

