/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.child;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.StringUtils;
import java.io.Reader;
import java.util.EnumSet;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ChildConfig
extends AutoUpdateConfigLoader {
    public ChildConfig() {
        super("child.yml");
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.config.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)plugin.getResourceAsReader("child.yml")));
        FamilyTree.clearRegistrations();
        for (PrimarySkillType primarySkillType : PrimarySkillType.CHILD_SKILLS) {
            plugin.debug("Finding parents of " + primarySkillType.name());
            EnumSet<PrimarySkillType> enumSet = EnumSet.noneOf(PrimarySkillType.class);
            boolean bl = false;
            for (String string : this.config.getStringList(StringUtils.getCapitalized(primarySkillType.name()))) {
                try {
                    PrimarySkillType primarySkillType2 = PrimarySkillType.valueOf(string.toUpperCase());
                    FamilyTree.enforceNotChildSkill(primarySkillType2);
                    enumSet.add(primarySkillType2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    plugin.getLogger().warning(string + " is not a valid skill type, or is a child skill!");
                    bl = true;
                    break;
                }
            }
            if (bl) {
                enumSet.clear();
                for (String string : this.config.getDefaults().getStringList(StringUtils.getCapitalized(primarySkillType.name()))) {
                    enumSet.add(PrimarySkillType.valueOf(string.toUpperCase()));
                }
            }
            for (PrimarySkillType primarySkillType3 : enumSet) {
                plugin.debug("Registering " + primarySkillType3.name() + " as parent of " + primarySkillType.name());
                FamilyTree.registerParent(primarySkillType, primarySkillType3);
            }
        }
        FamilyTree.closeRegistration();
    }
}

