/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.axes;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.axes.Axes;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class AxesManager
extends SkillManager {
    public AxesManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.AXES);
    }

    public boolean canUseAxeMastery() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_AXE_MASTERY)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_AXE_MASTERY);
    }

    public boolean canCriticalHit(LivingEntity livingEntity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_CRITICAL_STRIKES)) {
            return false;
        }
        return livingEntity.isValid() && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_CRITICAL_STRIKES);
    }

    public boolean canImpact(LivingEntity livingEntity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_ARMOR_IMPACT)) {
            return false;
        }
        return livingEntity.isValid() && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_ARMOR_IMPACT) && Axes.hasArmor(livingEntity);
    }

    public boolean canGreaterImpact(LivingEntity livingEntity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_GREATER_IMPACT)) {
            return false;
        }
        return livingEntity.isValid() && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.AXES_GREATER_IMPACT) && !Axes.hasArmor(livingEntity);
    }

    public boolean canUseSkullSplitter(LivingEntity livingEntity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.AXES_SKULL_SPLITTER)) {
            return false;
        }
        return livingEntity.isValid() && this.mcMMOPlayer.getAbilityMode(SuperAbilityType.SKULL_SPLITTER) && Permissions.skullSplitter((Permissible)this.getPlayer());
    }

    public boolean canActivateAbility() {
        return this.mcMMOPlayer.getToolPreparationMode(ToolType.AXE) && Permissions.skullSplitter((Permissible)this.getPlayer());
    }

    public double axeMastery() {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.ALWAYS_FIRES, SubSkillType.AXES_AXE_MASTERY, this.getPlayer())) {
            return 0.0;
        }
        return Axes.getAxeMasteryBonusDamage(this.getPlayer());
    }

    public double criticalHit(LivingEntity livingEntity, double d) {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.AXES_CRITICAL_STRIKES, this.getPlayer())) {
            return 0.0;
        }
        Player player = this.getPlayer();
        if (this.mcMMOPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.CriticalHit");
        }
        if (livingEntity instanceof Player) {
            Player player2 = (Player)livingEntity;
            if (NotificationManager.doesPlayerUseNotifications(player2)) {
                NotificationManager.sendPlayerInformation(player2, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.CritStruck");
            }
            d = d * Axes.criticalHitPVPModifier - d;
        } else {
            d = d * Axes.criticalHitPVEModifier - d;
        }
        return d;
    }

    public void impactCheck(LivingEntity livingEntity) {
        double d = this.getImpactDurabilityDamage();
        for (ItemStack itemStack : livingEntity.getEquipment().getArmorContents()) {
            if (itemStack == null || !ItemUtils.isArmor(itemStack) || !RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_STATIC_CHANCE, SubSkillType.AXES_ARMOR_IMPACT, this.getPlayer())) continue;
            SkillUtils.handleDurabilityChange(itemStack, d, 1.0);
        }
    }

    public double getImpactDurabilityDamage() {
        return AdvancedConfig.getInstance().getImpactDurabilityDamageMultiplier() * (double)RankUtils.getRank(this.getPlayer(), SubSkillType.AXES_ARMOR_IMPACT);
    }

    public double greaterImpact(LivingEntity livingEntity) {
        Player player;
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_STATIC_CHANCE, SubSkillType.AXES_GREATER_IMPACT, this.getPlayer())) {
            return 0.0;
        }
        Player player2 = this.getPlayer();
        ParticleEffectUtils.playGreaterImpactEffect(livingEntity);
        livingEntity.setVelocity(player2.getLocation().getDirection().normalize().multiply(Axes.greaterImpactKnockbackMultiplier));
        if (this.mcMMOPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(player2, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.GI.Proc");
        }
        if (livingEntity instanceof Player && NotificationManager.doesPlayerUseNotifications(player = (Player)livingEntity)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.GI.Struck");
        }
        return Axes.greaterImpactBonusDamage;
    }

    public void skullSplitterCheck(LivingEntity livingEntity, double d, Map<EntityDamageEvent.DamageModifier, Double> map) {
        CombatUtils.applyAbilityAoE(this.getPlayer(), livingEntity, d / Axes.skullSplitterModifier, map, this.skill);
    }
}

