/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.archery;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.archery.Archery;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArcheryManager
extends SkillManager {
    public ArcheryManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.ARCHERY);
    }

    public boolean canDaze(LivingEntity livingEntity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ARCHERY_DAZE)) {
            return false;
        }
        return livingEntity instanceof Player && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ARCHERY_DAZE);
    }

    public boolean canSkillShot() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ARCHERY_SKILL_SHOT)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ARCHERY_SKILL_SHOT);
    }

    public boolean canRetrieveArrows() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ARCHERY_ARROW_RETRIEVAL)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ARCHERY_ARROW_RETRIEVAL);
    }

    public double distanceXpBonusMultiplier(LivingEntity livingEntity, Entity entity) {
        if (!entity.hasMetadata("mcMMO: Arrow Distance")) {
            return entity.getLocation().distance(livingEntity.getLocation());
        }
        Location location = (Location)((MetadataValue)entity.getMetadata("mcMMO: Arrow Distance").get(0)).value();
        Location location2 = livingEntity.getLocation();
        if (location.getWorld() != location2.getWorld()) {
            return 1.0;
        }
        return 1.0 + Math.min(location.distance(location2), 50.0) * Archery.DISTANCE_XP_MULTIPLIER;
    }

    public void retrieveArrows(LivingEntity livingEntity, Projectile projectile) {
        if (projectile.hasMetadata("mcMMO: Tracked Arrow")) {
            Archery.incrementTrackerValue(livingEntity);
            projectile.removeMetadata("mcMMO: Tracked Arrow", (Plugin)mcMMO.p);
        }
    }

    public double daze(Player player) {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.ARCHERY_DAZE, this.getPlayer())) {
            return 0.0;
        }
        Location location = player.getLocation();
        location.setPitch((float)(90 - Misc.getRandom().nextInt(181)));
        player.teleport(location);
        player.addPotionEffect(new PotionEffect(PotionEffectType.CONFUSION, 200, 10));
        if (NotificationManager.doesPlayerUseNotifications(player)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Combat.TouchedFuzzy");
        }
        if (this.mcMMOPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Combat.TargetDazed");
        }
        return Archery.dazeBonusDamage;
    }

    public double skillShot(double d) {
        if (!RandomChanceUtil.isActivationSuccessful(SkillActivationType.ALWAYS_FIRES, SubSkillType.ARCHERY_SKILL_SHOT, this.getPlayer())) {
            return d;
        }
        return Archery.getSkillShotBonusDamage(this.getPlayer(), d);
    }
}

