/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.archery;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.skills.archery.TrackedEntity;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Archery {
    private static List<TrackedEntity> trackedEntities = new ArrayList<TrackedEntity>();
    public static double skillShotMaxBonusDamage = AdvancedConfig.getInstance().getSkillShotDamageMax();
    public static double dazeBonusDamage = AdvancedConfig.getInstance().getDazeBonusDamage();
    public static final double DISTANCE_XP_MULTIPLIER = ExperienceConfig.getInstance().getArcheryDistanceMultiplier();

    protected static void incrementTrackerValue(LivingEntity livingEntity) {
        for (TrackedEntity trackedEntity : trackedEntities) {
            if (trackedEntity.getLivingEntity().getEntityId() != livingEntity.getEntityId()) continue;
            trackedEntity.incrementArrowCount();
            return;
        }
        Archery.addToTracker(livingEntity);
    }

    protected static void addToTracker(LivingEntity livingEntity) {
        TrackedEntity trackedEntity = new TrackedEntity(livingEntity);
        trackedEntity.incrementArrowCount();
        trackedEntities.add(trackedEntity);
    }

    protected static void removeFromTracker(TrackedEntity trackedEntity) {
        trackedEntities.remove((Object)trackedEntity);
    }

    public static void arrowRetrievalCheck(LivingEntity livingEntity) {
        Iterator<TrackedEntity> iterator = trackedEntities.iterator();
        while (iterator.hasNext()) {
            TrackedEntity trackedEntity = iterator.next();
            if (trackedEntity.getID() != livingEntity.getUniqueId()) continue;
            Misc.dropItems(livingEntity.getLocation(), new ItemStack(Material.ARROW), trackedEntity.getArrowCount());
            iterator.remove();
            return;
        }
    }

    public static double getSkillShotBonusDamage(Player player, double d) {
        double d2 = Archery.getDamageBonusPercent(player);
        double d3 = d + d * d2;
        return Math.min(d3, skillShotMaxBonusDamage);
    }

    public static double getDamageBonusPercent(Player player) {
        return (double)RankUtils.getRank(player, SubSkillType.ARCHERY_SKILL_SHOT) * AdvancedConfig.getInstance().getSkillShotRankDamageMultiplier() / 100.0;
    }
}

