/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.alchemy;

import com.gmail.nossr50.config.skills.alchemy.PotionConfig;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.alchemy.AlchemyPotion;
import com.gmail.nossr50.datatypes.skills.alchemy.PotionStage;
import com.gmail.nossr50.events.fake.FakeBrewEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerUpdateInventoryTask;
import com.gmail.nossr50.runnables.skills.AlchemyBrewCheckTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public final class AlchemyPotionBrewer {
    public static boolean isValidBrew(Player player, ItemStack[] itemStackArray) {
        if (!AlchemyPotionBrewer.isValidIngredient(player, itemStackArray[3])) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (itemStackArray[i] == null || itemStackArray[i].getType() != Material.POTION && itemStackArray[i].getType() != Material.SPLASH_POTION && itemStackArray[i].getType() != Material.LINGERING_POTION || AlchemyPotionBrewer.getChildPotion(PotionConfig.getInstance().getPotion(itemStackArray[i]), itemStackArray[3]) == null) continue;
            return true;
        }
        return false;
    }

    private static AlchemyPotion getChildPotion(AlchemyPotion alchemyPotion, ItemStack itemStack) {
        if (alchemyPotion != null) {
            return alchemyPotion.getChild(itemStack);
        }
        return null;
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() == 0;
    }

    private static void removeIngredient(BrewerInventory brewerInventory, Player player) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = brewerInventory.getIngredient() == null ? null : brewerInventory.getIngredient().clone();
        if (AlchemyPotionBrewer.isEmpty(itemStack) || !AlchemyPotionBrewer.isValidIngredient(player, itemStack)) {
            return;
        }
        if (itemStack.getAmount() <= 1) {
            brewerInventory.setIngredient(null);
            return;
        }
        itemStack.setAmount(itemStack.getAmount() - 1);
        brewerInventory.setIngredient(itemStack);
    }

    private static boolean hasIngredient(BrewerInventory brewerInventory, Player player) {
        ItemStack itemStack = brewerInventory.getIngredient() == null ? null : brewerInventory.getIngredient().clone();
        return !AlchemyPotionBrewer.isEmpty(itemStack) && AlchemyPotionBrewer.isValidIngredient(player, itemStack);
    }

    public static boolean isValidIngredient(Player player, ItemStack itemStack) {
        if (AlchemyPotionBrewer.isEmpty(itemStack)) {
            return false;
        }
        for (ItemStack itemStack2 : AlchemyPotionBrewer.getValidIngredients(player)) {
            if (!itemStack.isSimilar(itemStack2)) continue;
            return true;
        }
        return false;
    }

    private static List<ItemStack> getValidIngredients(Player player) {
        if (player == null || UserManager.getPlayer(player) == null) {
            return PotionConfig.getInstance().getIngredients(1);
        }
        return PotionConfig.getInstance().getIngredients(!Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.ALCHEMY_CONCOCTIONS) ? 1 : UserManager.getPlayer(player).getAlchemyManager().getTier());
    }

    public static void finishBrewing(BlockState blockState, Player player, boolean bl) {
        AlchemyPotion alchemyPotion;
        ItemStack itemStack;
        if (!(blockState instanceof BrewingStand)) {
            return;
        }
        BrewerInventory brewerInventory = ((BrewingStand)blockState).getInventory();
        ItemStack itemStack2 = itemStack = brewerInventory.getIngredient() == null ? null : brewerInventory.getIngredient().clone();
        if (!AlchemyPotionBrewer.hasIngredient(brewerInventory, player)) {
            return;
        }
        ArrayList<AlchemyPotion> arrayList = new ArrayList<AlchemyPotion>();
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack3 = brewerInventory.getItem(i);
            if (AlchemyPotionBrewer.isEmpty(itemStack3) || itemStack3.getType() == Material.GLASS_BOTTLE || !PotionConfig.getInstance().isValidPotion(itemStack3)) continue;
            AlchemyPotion alchemyPotion2 = PotionConfig.getInstance().getPotion(itemStack3);
            alchemyPotion = alchemyPotion2.getChild(itemStack);
            arrayList.add(alchemyPotion2);
            if (alchemyPotion == null) continue;
            brewerInventory.setItem(i, alchemyPotion.toItemStack(itemStack3.getAmount()).clone());
        }
        FakeBrewEvent fakeBrewEvent = new FakeBrewEvent(blockState.getBlock(), brewerInventory, ((BrewingStand)blockState).getFuelLevel());
        mcMMO.p.getServer().getPluginManager().callEvent((Event)fakeBrewEvent);
        if (fakeBrewEvent.isCancelled() || arrayList.isEmpty()) {
            return;
        }
        AlchemyPotionBrewer.removeIngredient(brewerInventory, player);
        for (AlchemyPotion alchemyPotion2 : arrayList) {
            alchemyPotion = alchemyPotion2.getChild(itemStack);
            if (alchemyPotion == null || player == null) continue;
            PotionStage potionStage = PotionStage.getPotionStage(alchemyPotion2, alchemyPotion);
            if (!UserManager.hasPlayerDataKey((Entity)player)) continue;
            UserManager.getPlayer(player).getAlchemyManager().handlePotionBrewSuccesses(potionStage, 1);
        }
        if (!bl) {
            AlchemyPotionBrewer.scheduleUpdate((Inventory)brewerInventory);
        }
    }

    public static boolean transferItems(InventoryView inventoryView, int n, ClickType clickType) {
        boolean bl = false;
        if (clickType.isLeftClick()) {
            bl = AlchemyPotionBrewer.transferItems(inventoryView, n);
        } else if (clickType.isRightClick()) {
            bl = AlchemyPotionBrewer.transferOneItem(inventoryView, n);
        }
        return bl;
    }

    private static boolean transferOneItem(InventoryView inventoryView, int n) {
        ItemStack itemStack = inventoryView.getItem(n).clone();
        ItemStack itemStack2 = inventoryView.getItem(3).clone();
        if (AlchemyPotionBrewer.isEmpty(itemStack)) {
            return false;
        }
        boolean bl = AlchemyPotionBrewer.isEmpty(itemStack2);
        int n2 = itemStack.getAmount();
        if (!bl && n2 >= itemStack.getType().getMaxStackSize()) {
            return false;
        }
        if (bl || itemStack.isSimilar(itemStack2)) {
            if (bl) {
                itemStack2 = itemStack.clone();
                itemStack2.setAmount(1);
            } else {
                itemStack2.setAmount(itemStack2.getAmount() + 1);
            }
            itemStack.setAmount(n2 - 1);
            inventoryView.setItem(3, itemStack2);
            inventoryView.setItem(n, itemStack);
            return true;
        }
        return false;
    }

    private static boolean transferItems(InventoryView inventoryView, int n) {
        ItemStack itemStack = inventoryView.getItem(n).clone();
        ItemStack itemStack2 = inventoryView.getItem(3).clone();
        if (AlchemyPotionBrewer.isEmpty(itemStack)) {
            return false;
        }
        if (AlchemyPotionBrewer.isEmpty(itemStack2)) {
            inventoryView.setItem(3, itemStack);
            inventoryView.setItem(n, null);
            return true;
        }
        if (itemStack.isSimilar(itemStack2)) {
            int n2;
            int n3;
            int n4 = itemStack.getAmount();
            if (n4 + (n3 = itemStack2.getAmount()) > (n2 = itemStack2.getType().getMaxStackSize())) {
                int n5 = n4 + n3 - n2;
                itemStack2.setAmount(n2);
                inventoryView.setItem(3, itemStack2);
                itemStack.setAmount(n5);
                inventoryView.setItem(n, itemStack);
                return true;
            }
            itemStack2.setAmount(n4 + n3);
            inventoryView.setItem(n, null);
            inventoryView.setItem(3, itemStack2);
            return true;
        }
        return false;
    }

    public static void scheduleCheck(Player player, BrewingStand brewingStand) {
        new AlchemyBrewCheckTask(player, brewingStand).runTask((Plugin)mcMMO.p);
    }

    public static void scheduleUpdate(Inventory inventory) {
        for (HumanEntity humanEntity : inventory.getViewers()) {
            if (!(humanEntity instanceof Player)) continue;
            new PlayerUpdateInventoryTask((Player)humanEntity).runTask((Plugin)mcMMO.p);
        }
    }
}

