/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.alchemy;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.skills.alchemy.PotionConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.alchemy.PotionStage;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class AlchemyManager
extends SkillManager {
    private final double LUCKY_MODIFIER = 1.3333333333333333;

    public AlchemyManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.ALCHEMY);
    }

    public int getTier() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.ALCHEMY_CONCOCTIONS);
    }

    public List<ItemStack> getIngredients() {
        return PotionConfig.getInstance().getIngredients(this.getTier());
    }

    public String getIngredientList() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ItemStack itemStack : this.getIngredients()) {
            String string = StringUtils.getPrettyItemString(itemStack.getType());
            stringBuilder.append(", ").append(string);
        }
        return stringBuilder.substring(2);
    }

    public double calculateBrewSpeed(boolean bl) {
        int n = this.getSkillLevel();
        if (n < Alchemy.catalysisUnlockLevel) {
            return Alchemy.catalysisMinSpeed;
        }
        return Math.min(Alchemy.catalysisMaxSpeed, Alchemy.catalysisMinSpeed + (Alchemy.catalysisMaxSpeed - Alchemy.catalysisMinSpeed) * (double)(n - Alchemy.catalysisUnlockLevel) / (double)(Alchemy.catalysisMaxBonusLevel - Alchemy.catalysisUnlockLevel)) * (bl ? 1.3333333333333333 : 1.0);
    }

    public void handlePotionBrewSuccesses(PotionStage potionStage, int n) {
        this.applyXpGain((float)(ExperienceConfig.getInstance().getPotionXP(potionStage) * (double)n), XPGainReason.PVE, XPGainSource.PASSIVE);
    }
}

