/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.acrobatics;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.LimitedSizeList;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.Acrobatics;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AcrobaticsManager
extends SkillManager {
    private long rollXPCooldown = 0L;
    private long rollXPInterval = 3000L;
    private long rollXPIntervalLengthen = 10000L;
    private LimitedSizeList fallLocationMap = new LimitedSizeList(50);

    public AcrobaticsManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.ACROBATICS);
    }

    public boolean hasFallenInLocationBefore(Location location) {
        return this.fallLocationMap.contains(location);
    }

    public void addLocationToFallMap(Location location) {
        this.fallLocationMap.add(location);
    }

    public boolean canGainRollXP() {
        if (!ExperienceConfig.getInstance().isAcrobaticsExploitingPrevented()) {
            return true;
        }
        if (System.currentTimeMillis() >= this.rollXPCooldown) {
            this.rollXPCooldown = System.currentTimeMillis() + this.rollXPInterval;
            this.rollXPIntervalLengthen = 10000L;
            return true;
        }
        this.rollXPCooldown += this.rollXPIntervalLengthen;
        this.rollXPIntervalLengthen += 1000L;
        return false;
    }

    public boolean canDodge(Entity entity) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.ACROBATICS_DODGE)) {
            return false;
        }
        if (Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.ACROBATICS_DODGE)) {
            if (entity instanceof LightningStrike && Acrobatics.dodgeLightningDisabled) {
                return false;
            }
            return this.skill.shouldProcess(entity);
        }
        return false;
    }

    public double dodgeCheck(double d) {
        double d2 = Acrobatics.calculateModifiedDodgeDamage(d, Acrobatics.dodgeDamageModifier);
        Player player = this.getPlayer();
        if (!this.isFatal(d2) && RandomChanceUtil.isActivationSuccessful(SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, SubSkillType.ACROBATICS_DODGE, player)) {
            ParticleEffectUtils.playDodgeEffect(player);
            if (this.mcMMOPlayer.useChatNotifications()) {
                NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Acrobatics.Combat.Proc");
            }
            if (SkillUtils.cooldownExpired(this.mcMMOPlayer.getRespawnATS(), 5)) {
                this.applyXpGain((float)(d * (double)Acrobatics.dodgeXpModifier), XPGainReason.PVP);
            }
            return d2;
        }
        return d;
    }

    private boolean isFatal(double d) {
        return this.getPlayer().getHealth() - d <= 0.0;
    }
}

