/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.BleedContainer;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class BleedTimerTask
extends BukkitRunnable {
    private static Map<LivingEntity, BleedContainer> bleedList = new HashMap<LivingEntity, BleedContainer>();
    private static boolean isIterating = false;

    public void run() {
        isIterating = true;
        Iterator<Map.Entry<LivingEntity, BleedContainer>> iterator = bleedList.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            double d;
            Map.Entry<LivingEntity, BleedContainer> entry = iterator.next();
            LivingEntity livingEntity = entry.getKey();
            int n = entry.getValue().toolTier;
            if (entry.getValue().bleedTicks <= 0 || !livingEntity.isValid()) {
                if (livingEntity instanceof Player) {
                    NotificationManager.sendPlayerInformation((Player)livingEntity, NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Bleeding.Stopped");
                }
                iterator.remove();
                continue;
            }
            int n2 = 0;
            if (livingEntity instanceof Player) {
                Player player;
                d = AdvancedConfig.getInstance().getRuptureDamagePlayer();
                if (entry.getValue().toolTier >= 4 && entry.getValue().bleedRank >= 3) {
                    d *= 1.5;
                }
                if (!(player = (Player)livingEntity).isOnline()) continue;
                for (Object object2 : ((Player)livingEntity).getInventory().getArmorContents()) {
                    if (object2 == null) continue;
                    ++n2;
                }
            } else {
                d = AdvancedConfig.getInstance().getRuptureDamageMobs();
                if (entry.getValue().bleedRank >= 3) {
                    d *= 1.5;
                }
                MobHealthbarUtils.handleMobHealthbars(livingEntity, d, mcMMO.p);
            }
            if (n2 > 3) {
                d *= 0.75;
            }
            if (n < 4) {
                d /= 2.0;
            }
            if (n < 2) {
                d /= 2.0;
            }
            double d2 = livingEntity.getHealth();
            CombatUtils.dealNoInvulnerabilityTickDamageRupture(livingEntity, d, (Entity)entry.getValue().damageSource, n);
            double d3 = livingEntity.getHealth();
            if (d3 <= 0.0 || d2 != d3) {
                SoundManager.worldSendSound(livingEntity.getWorld(), livingEntity.getLocation(), SoundType.BLEED);
                ParticleEffectUtils.playBleedEffect(livingEntity);
            }
            object2 = BleedTimerTask.copyContainer(entry.getValue());
            --object2.bleedTicks;
            entry.setValue((BleedContainer)object2);
        }
        isIterating = false;
    }

    public static BleedContainer copyContainer(BleedContainer bleedContainer) {
        LivingEntity livingEntity = bleedContainer.target;
        LivingEntity livingEntity2 = bleedContainer.damageSource;
        int n = bleedContainer.bleedTicks;
        int n2 = bleedContainer.bleedRank;
        int n3 = bleedContainer.toolTier;
        BleedContainer bleedContainer2 = new BleedContainer(livingEntity, n, n2, n3, livingEntity2);
        return bleedContainer2;
    }

    public static void bleedOut(LivingEntity livingEntity) {
        if (bleedList.containsKey(livingEntity)) {
            CombatUtils.dealNoInvulnerabilityTickDamage(livingEntity, BleedTimerTask.bleedList.get((Object)livingEntity).bleedTicks * 2, (Entity)BleedTimerTask.bleedList.get((Object)livingEntity).damageSource);
        }
    }

    public static void add(LivingEntity livingEntity, LivingEntity livingEntity2, int n, int n2, int n3) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot add bleed task async!");
        }
        if (isIterating) {
            throw new IllegalStateException("Cannot add task while iterating timers!");
        }
        if (n3 < 4) {
            n = Math.max(1, n / 3);
        }
        BleedContainer bleedContainer = new BleedContainer(livingEntity, n, n2, n3, livingEntity2);
        bleedList.put(livingEntity, bleedContainer);
    }

    public static boolean isBleeding(LivingEntity livingEntity) {
        return bleedList.containsKey(livingEntity);
    }
}

