/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.AbilityCooldownTask;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AbilityDisableTask
extends BukkitRunnable {
    private McMMOPlayer mcMMOPlayer;
    private SuperAbilityType ability;

    public AbilityDisableTask(McMMOPlayer mcMMOPlayer, SuperAbilityType superAbilityType) {
        this.mcMMOPlayer = mcMMOPlayer;
        this.ability = superAbilityType;
    }

    public void run() {
        if (!this.mcMMOPlayer.getAbilityMode(this.ability)) {
            return;
        }
        Player player = this.mcMMOPlayer.getPlayer();
        switch (this.ability) {
            case SUPER_BREAKER: 
            case GIGA_DRILL_BREAKER: {
                SkillUtils.handleAbilitySpeedDecrease(player);
            }
            case BERSERK: {
                if (!Config.getInstance().getRefreshChunksEnabled()) break;
                this.resendChunkRadiusAt(player, 1);
            }
        }
        EventUtils.callAbilityDeactivateEvent(player, this.ability);
        this.mcMMOPlayer.setAbilityMode(this.ability, false);
        this.mcMMOPlayer.setAbilityInformed(this.ability, false);
        ParticleEffectUtils.playAbilityDisabledEffect(player);
        if (this.mcMMOPlayer.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ABILITY_OFF, this.ability.getAbilityOff());
        }
        SkillUtils.sendSkillMessage(player, NotificationType.SUPER_ABILITY_ALERT_OTHERS, this.ability.getAbilityPlayerOff());
        new AbilityCooldownTask(this.mcMMOPlayer, this.ability).runTaskLater((Plugin)mcMMO.p, PerksUtils.handleCooldownPerks(player, this.ability.getCooldown()) * 20);
    }

    private void resendChunkRadiusAt(Player player, int n) {
        Chunk chunk = player.getLocation().getChunk();
        World world = player.getWorld();
        int n2 = chunk.getX();
        int n3 = chunk.getZ();
        for (int i = n2 - n; i <= n2 + n; ++i) {
            for (int j = n3 - n; j <= n3 + n; ++j) {
                world.refreshChunk(i, j);
            }
        }
    }
}

