/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McScoreboardKeepTask;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerProfileLoadingTask
extends BukkitRunnable {
    private final Player player;
    private int attempt = 0;

    public PlayerProfileLoadingTask(Player player) {
        this.player = player;
    }

    private PlayerProfileLoadingTask(Player player, int n) {
        this.player = player;
        this.attempt = n;
    }

    public void run() {
        if (Misc.isNPCIncludingVillagers((Entity)this.player)) {
            return;
        }
        if (!this.player.isOnline()) {
            mcMMO.p.getLogger().info("Aborting profile loading recovery for " + this.player.getName() + " - player logged out");
            return;
        }
        PlayerProfile playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(this.player.getName(), this.player.getUniqueId(), true);
        if (playerProfile.isLoaded()) {
            new ApplySuccessfulProfile(new McMMOPlayer(this.player, playerProfile)).runTask((Plugin)mcMMO.p);
            return;
        }
        if (this.attempt >= 3) {
            mcMMO.p.getLogger().severe(LocaleLoader.getString("Profile.Loading.FailureNotice", this.player.getName(), String.valueOf(this.attempt)));
            mcMMO.p.getServer().broadcast(LocaleLoader.getString("Profile.Loading.FailureNotice", this.player.getName()), "bukkit.broadcast.admin");
            this.player.sendMessage(LocaleLoader.getString("Profile.Loading.FailurePlayer", String.valueOf(this.attempt)).split("\n"));
        }
        ++this.attempt;
        new PlayerProfileLoadingTask(this.player, this.attempt).runTaskLaterAsynchronously((Plugin)mcMMO.p, 100 + this.attempt * 100);
    }

    private class ApplySuccessfulProfile
    extends BukkitRunnable {
        private final McMMOPlayer mcMMOPlayer;

        private ApplySuccessfulProfile(McMMOPlayer mcMMOPlayer) {
            this.mcMMOPlayer = mcMMOPlayer;
        }

        public void run() {
            if (!PlayerProfileLoadingTask.this.player.isOnline()) {
                mcMMO.p.getLogger().info("Aborting profile loading recovery for " + PlayerProfileLoadingTask.this.player.getName() + " - player logged out");
                return;
            }
            this.mcMMOPlayer.setupPartyData();
            UserManager.track(this.mcMMOPlayer);
            this.mcMMOPlayer.actualizeRespawnATS();
            if (Config.getInstance().getScoreboardsEnabled()) {
                ScoreboardManager.setupPlayer(PlayerProfileLoadingTask.this.player);
                if (Config.getInstance().getShowStatsAfterLogin()) {
                    ScoreboardManager.enablePlayerStatsScoreboard(PlayerProfileLoadingTask.this.player);
                    new McScoreboardKeepTask(PlayerProfileLoadingTask.this.player).runTaskLater((Plugin)mcMMO.p, 20L);
                }
            }
            if (Config.getInstance().getShowProfileLoadedMessage()) {
                PlayerProfileLoadingTask.this.player.sendMessage(LocaleLoader.getString("Profile.Loading.Success"));
            }
        }
    }
}

