/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.database;

import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.uuid.UUIDFetcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.scheduler.BukkitRunnable;

public class UUIDUpdateAsyncTask
extends BukkitRunnable {
    private mcMMO plugin;
    private static final int MAX_LOOKUP = Math.max(HiddenConfig.getInstance().getUUIDConvertAmount(), 100);
    private static final int RATE_LIMIT = HiddenConfig.getInstance().getMojangRateLimit();
    private static final long LIMIT_PERIOD = HiddenConfig.getInstance().getMojangLimitPeriod();
    private static final int BATCH_SIZE = MAX_LOOKUP * 3;
    private List<String> userNames;
    private int size;
    private int checkedUsers;
    private long startMillis;

    public UUIDUpdateAsyncTask(mcMMO mcMMO2, List<String> list) {
        this.plugin = mcMMO2;
        this.userNames = list;
        this.checkedUsers = 0;
        this.startMillis = System.currentTimeMillis();
    }

    public void run() {
        this.size = this.userNames.size();
        this.plugin.getLogger().info("Starting to check and update UUIDs, total amount of users: " + this.size);
        HashMap<String, UUID> hashMap = new HashMap<String, UUID>();
        while (this.size != 0) {
            List<String> list;
            if (this.checkedUsers + 100 > RATE_LIMIT) {
                try {
                    Thread.sleep(LIMIT_PERIOD);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
                this.startMillis = System.currentTimeMillis();
                this.checkedUsers = 0;
            }
            if (this.size > MAX_LOOKUP) {
                list = this.userNames.subList(this.size - MAX_LOOKUP, this.size);
                this.size -= MAX_LOOKUP;
            } else {
                list = this.userNames.subList(0, this.size);
                this.size = 0;
            }
            try {
                hashMap.putAll((Map<String, UUID>)new UUIDFetcher(list).call());
            }
            catch (Exception exception) {
                if (exception.getMessage() != null && exception.getMessage().contains("429")) {
                    this.size += list.size();
                    try {
                        Thread.sleep(LIMIT_PERIOD);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        exception.printStackTrace();
                        return;
                    }
                }
                this.plugin.getLogger().log(Level.SEVERE, "Unable to fetch UUIDs!", exception);
                return;
            }
            this.checkedUsers += list.size();
            list.clear();
            this.size = this.userNames.size();
            Misc.printProgress(this.checkedUsers, 200, this.startMillis);
            if (hashMap.size() < BATCH_SIZE) continue;
            mcMMO.getDatabaseManager().saveUserUUIDs(hashMap);
            hashMap = new HashMap();
        }
        if (hashMap.size() == 0 || mcMMO.getDatabaseManager().saveUserUUIDs(hashMap)) {
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_UUIDS);
            this.plugin.getLogger().info("UUID upgrade completed!");
        }
    }
}

