/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.database;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.CommandSender;
import org.bukkit.scheduler.BukkitRunnable;

public class FormulaConversionTask
extends BukkitRunnable {
    private CommandSender sender;
    private FormulaType formulaType;

    public FormulaConversionTask(CommandSender commandSender, FormulaType formulaType) {
        this.sender = commandSender;
        this.formulaType = formulaType;
    }

    public void run() {
        int n = 0;
        long l = System.currentTimeMillis();
        for (String string : mcMMO.getDatabaseManager().getStoredUsers()) {
            PlayerProfile playerProfile;
            McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(string);
            if (mcMMOPlayer == null) {
                playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(string, false);
                if (!playerProfile.isLoaded()) {
                    mcMMO.p.debug("Profile not loaded.");
                    continue;
                }
                this.editValues(playerProfile);
                playerProfile.scheduleAsyncSave();
            } else {
                playerProfile = mcMMOPlayer.getProfile();
                this.editValues(playerProfile);
            }
            Misc.printProgress(++n, 200, l);
        }
        mcMMO.getFormulaManager().setPreviousFormulaType(this.formulaType);
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcconvert.Experience.Finish", this.formulaType.toString()));
    }

    private void editValues(PlayerProfile playerProfile) {
        mcMMO.p.debug("========================================================================");
        mcMMO.p.debug("Conversion report for " + playerProfile.getPlayerName() + ":");
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            int n = playerProfile.getSkillLevel(primarySkillType);
            int n2 = playerProfile.getSkillXpLevel(primarySkillType);
            int n3 = mcMMO.getFormulaManager().calculateTotalExperience(n, n2);
            if (n3 == 0) continue;
            int[] nArray = mcMMO.getFormulaManager().calculateNewLevel(primarySkillType, (int)Math.floor((double)n3 / ExperienceConfig.getInstance().getExpModifier()), this.formulaType);
            int n4 = nArray[0];
            int n5 = nArray[1];
            mcMMO.p.debug("  Skill: " + primarySkillType.toString());
            mcMMO.p.debug("    OLD:");
            mcMMO.p.debug("      Level: " + n);
            mcMMO.p.debug("      XP " + n2);
            mcMMO.p.debug("      Total XP " + n3);
            mcMMO.p.debug("    NEW:");
            mcMMO.p.debug("      Level " + n4);
            mcMMO.p.debug("      XP " + n5);
            mcMMO.p.debug("------------------------------------------------------------------------");
            playerProfile.modifySkill(primarySkillType, n4);
            playerProfile.setSkillXpLevel(primarySkillType, n5);
        }
    }
}

