/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MctopCommandDisplayTask
extends BukkitRunnable {
    private final List<PlayerStat> userStats;
    private final CommandSender sender;
    private final PrimarySkillType skill;
    private final int page;
    private final boolean useBoard;
    private final boolean useChat;

    MctopCommandDisplayTask(List<PlayerStat> list, int n, PrimarySkillType primarySkillType, CommandSender commandSender, boolean bl, boolean bl2) {
        this.userStats = list;
        this.page = n;
        this.skill = primarySkillType;
        this.sender = commandSender;
        this.useBoard = bl;
        this.useChat = bl2;
    }

    public void run() {
        if (this.useBoard && Config.getInstance().getScoreboardsEnabled()) {
            this.displayBoard();
        }
        if (this.useChat) {
            this.displayChat();
        }
        if (this.sender instanceof Player) {
            ((Player)this.sender).removeMetadata("mcMMO: Processing Database Command", (Plugin)mcMMO.p);
        }
        if (this.sender instanceof Player) {
            this.sender.sendMessage(LocaleLoader.getString("Commands.mctop.Tip"));
        }
    }

    private void displayChat() {
        if (this.skill == null) {
            if (this.sender instanceof Player) {
                this.sender.sendMessage(LocaleLoader.getString("Commands.PowerLevel.Leaderboard"));
            } else {
                this.sender.sendMessage(ChatColor.stripColor((String)LocaleLoader.getString("Commands.PowerLevel.Leaderboard")));
            }
        } else if (this.sender instanceof Player) {
            this.sender.sendMessage(LocaleLoader.getString("Commands.Skill.Leaderboard", this.skill.getName()));
        } else {
            this.sender.sendMessage(ChatColor.stripColor((String)LocaleLoader.getString("Commands.Skill.Leaderboard", this.skill.getName())));
        }
        int n = this.page * 10 - 9;
        for (PlayerStat playerStat : this.userStats) {
            if (this.sender instanceof Player) {
                this.sender.sendMessage(String.format("%2d. %s%s - %s%s", n, ChatColor.GREEN, playerStat.name, ChatColor.WHITE, playerStat.statVal));
            } else {
                this.sender.sendMessage(String.format("%2d. %s - %s", n, playerStat.name, playerStat.statVal));
            }
            ++n;
        }
    }

    private void displayBoard() {
        if (this.skill == null) {
            ScoreboardManager.showTopPowerScoreboard((Player)this.sender, this.page, this.userStats);
        } else {
            ScoreboardManager.showTopScoreboard((Player)this.sender, this.skill, this.page, this.userStats);
        }
    }
}

