/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class McrankCommandDisplayTask
extends BukkitRunnable {
    private final Map<PrimarySkillType, Integer> skills;
    private final CommandSender sender;
    private final String playerName;
    private final boolean useBoard;
    private final boolean useChat;

    McrankCommandDisplayTask(Map<PrimarySkillType, Integer> map, CommandSender commandSender, String string, boolean bl, boolean bl2) {
        this.skills = map;
        this.sender = commandSender;
        this.playerName = string;
        this.useBoard = bl;
        this.useChat = bl2;
    }

    public void run() {
        if (this.useBoard && Config.getInstance().getScoreboardsEnabled()) {
            this.displayBoard();
        }
        if (this.useChat) {
            this.displayChat();
        }
        ((Player)this.sender).removeMetadata("mcMMO: Processing Database Command", (Plugin)mcMMO.p);
    }

    private void displayChat() {
        Integer n;
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Heading"));
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Player", this.playerName));
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            n = this.skills.get((Object)primarySkillType);
            this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Skill", primarySkillType.getName(), n == null ? LocaleLoader.getString("Commands.mcrank.Unranked") : n));
        }
        n = this.skills.get(null);
        this.sender.sendMessage(LocaleLoader.getString("Commands.mcrank.Overall", n == null ? LocaleLoader.getString("Commands.mcrank.Unranked") : n));
    }

    public void displayBoard() {
        if (this.sender.getName().equalsIgnoreCase(this.playerName)) {
            ScoreboardManager.showPlayerRankScoreboard((Player)this.sender, this.skills);
        } else {
            ScoreboardManager.showPlayerRankScoreboardOthers((Player)this.sender, this.playerName, this.skills);
        }
    }
}

