/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.backups;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.mcMMO;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.scheduler.BukkitRunnable;

public class CleanBackupsTask
extends BukkitRunnable {
    private static final String BACKUP_DIRECTORY = mcMMO.getMainDirectory() + "backup" + File.separator;
    private static final File BACKUP_DIR = new File(BACKUP_DIRECTORY);

    public void run() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap hashMap = new HashMap();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        int n = 0;
        int n2 = 0;
        if (BACKUP_DIR.listFiles() == null) {
            return;
        }
        for (File file : BACKUP_DIR.listFiles()) {
            if (!file.isFile() || file.isDirectory()) continue;
            ++n;
            String string = file.getName();
            Date date = this.getDate(string.split("[.]")[0]);
            if (!string.contains(".zip") || date == null) {
                mcMMO.p.debug("Could not determine date for file: " + string);
                continue;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n3 = calendar.get(7);
            int n4 = calendar.get(3);
            int n5 = calendar.get(1);
            if (this.isPast24Hours(date) && Config.getInstance().getKeepLast24Hours()) continue;
            if (this.isLastWeek(date) && !arrayList.contains(n3) && Config.getInstance().getKeepDailyLastWeek()) {
                arrayList.add(n3);
                continue;
            }
            ArrayList<Integer> arrayList3 = (ArrayList<Integer>)hashMap.get(n5);
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<Integer>();
                hashMap.put(n5, arrayList3);
            }
            if (!arrayList3.contains(n4) && Config.getInstance().getKeepWeeklyPastMonth()) {
                arrayList3.add(n4);
                continue;
            }
            ++n2;
            arrayList2.add(file);
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        mcMMO.p.getLogger().info("Cleaned backup files. Deleted " + n2 + " of " + n + " files.");
        for (File file : arrayList2) {
            if (!file.delete()) continue;
            mcMMO.p.debug("Deleted: " + file.getName());
        }
    }

    private boolean isPast24Hours(Date date) {
        Date date2 = new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS));
        return date.after(date2);
    }

    private boolean isLastWeek(Date date) {
        Date date2 = new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return date.after(date2);
    }

    private Date getDate(String string) {
        Date date;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return date;
    }
}

