/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.party.ItemWeightConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import java.util.List;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ShareHandler {
    private ShareHandler() {
    }

    public static boolean handleXpShare(float f, McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType, XPGainReason xPGainReason) {
        Party party = mcMMOPlayer.getParty();
        if (party.getXpShareMode() != ShareMode.EQUAL) {
            return false;
        }
        List<Player> list = PartyManager.getNearVisibleMembers(mcMMOPlayer);
        if (list.isEmpty()) {
            return false;
        }
        list.add(mcMMOPlayer.getPlayer());
        int n = list.size();
        double d = Math.min(Config.getInstance().getPartyShareBonusBase() + (double)n * Config.getInstance().getPartyShareBonusIncrease(), Config.getInstance().getPartyShareBonusCap());
        float f2 = (float)((double)(f / (float)n) * d);
        for (Player player : list) {
            if (UserManager.getPlayer(player) == null) continue;
            UserManager.getPlayer(player).beginUnsharedXpGain(primarySkillType, f2, xPGainReason, XPGainSource.PARTY_MEMBERS);
        }
        return true;
    }

    public static boolean handleItemShare(Item item, McMMOPlayer mcMMOPlayer) {
        ItemStack itemStack = item.getItemStack();
        ItemShareType itemShareType = ItemShareType.getShareType(itemStack);
        if (itemShareType == null) {
            return false;
        }
        Party party = mcMMOPlayer.getParty();
        if (!party.sharingDrops(itemShareType)) {
            return false;
        }
        ShareMode shareMode = party.getItemShareMode();
        if (shareMode == ShareMode.NONE) {
            return false;
        }
        List<Player> list = PartyManager.getNearMembers(mcMMOPlayer);
        if (list.isEmpty()) {
            return false;
        }
        Player player = null;
        ItemStack itemStack2 = itemStack.clone();
        list.add(mcMMOPlayer.getPlayer());
        int n = list.size();
        item.remove();
        itemStack2.setAmount(1);
        switch (shareMode) {
            case EQUAL: {
                int n2 = ItemWeightConfig.getInstance().getItemWeight(itemStack.getType());
                for (int i = 0; i < itemStack.getAmount(); ++i) {
                    int n3 = 0;
                    for (Player player2 : list) {
                        McMMOPlayer mcMMOPlayer2 = UserManager.getPlayer(player2);
                        if (UserManager.getPlayer(player2) == null) continue;
                        int n4 = mcMMOPlayer2.getItemShareModifier();
                        int n5 = Misc.getRandom().nextInt(n4);
                        if (n5 <= n3) {
                            mcMMOPlayer2.setItemShareModifier(n4 + n2);
                            continue;
                        }
                        n3 = n5;
                        if (player != null) {
                            McMMOPlayer mcMMOPlayer3 = UserManager.getPlayer(player);
                            mcMMOPlayer3.setItemShareModifier(mcMMOPlayer3.getItemShareModifier() + n2);
                        }
                        player = player2;
                    }
                    McMMOPlayer mcMMOPlayer4 = UserManager.getPlayer(player);
                    mcMMOPlayer4.setItemShareModifier(mcMMOPlayer4.getItemShareModifier() - n2);
                    ShareHandler.awardDrop(player, itemStack2);
                }
                return true;
            }
            case RANDOM: {
                for (int i = 0; i < itemStack.getAmount(); ++i) {
                    player = list.get(Misc.getRandom().nextInt(n));
                    ShareHandler.awardDrop(player, itemStack2);
                }
                return true;
            }
        }
        return false;
    }

    public static XPGainReason getSharedXpGainReason(XPGainReason xPGainReason) {
        if (xPGainReason == XPGainReason.PVE) {
            return XPGainReason.SHARED_PVE;
        }
        if (xPGainReason == XPGainReason.PVP) {
            return XPGainReason.SHARED_PVP;
        }
        return xPGainReason;
    }

    private static void awardDrop(Player player, ItemStack itemStack) {
        if (player.getInventory().addItem(new ItemStack[]{itemStack}).size() != 0) {
            player.getWorld().dropItem(player.getLocation(), itemStack);
        }
        player.updateInventory();
    }
}

