/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.chat.ChatMode;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyLeader;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.events.party.McMMOPartyAllianceChangeEvent;
import com.gmail.nossr50.events.party.McMMOPartyChangeEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;

public final class PartyManager {
    private static String partiesFilePath = mcMMO.getFlatFileDirectory() + "parties.yml";
    private static List<Party> parties = new ArrayList<Party>();
    private static File partyFile = new File(partiesFilePath);

    private PartyManager() {
    }

    public static boolean checkPartyExistence(Player player, String string) {
        if (PartyManager.getParty(string) == null) {
            return false;
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.AlreadyExists", string));
        return true;
    }

    public static boolean isPartyFull(Player player, Party party) {
        return !Permissions.partySizeBypass((Permissible)player) && Config.getInstance().getPartyMaxSize() >= 1 && party.getOnlineMembers().size() >= Config.getInstance().getPartyMaxSize();
    }

    public static boolean changeOrJoinParty(McMMOPlayer mcMMOPlayer, String string) {
        Player player = mcMMOPlayer.getPlayer();
        if (mcMMOPlayer.inParty()) {
            Party party = mcMMOPlayer.getParty();
            if (!PartyManager.handlePartyChangeEvent(player, party.getName(), string, McMMOPartyChangeEvent.EventReason.CHANGED_PARTIES)) {
                return false;
            }
        } else {
            return PartyManager.handlePartyChangeEvent(player, null, string, McMMOPartyChangeEvent.EventReason.JOINED_PARTY);
        }
        PartyManager.removeFromParty(mcMMOPlayer);
        return true;
    }

    public static boolean inSameParty(Player player, Player player2) {
        if (UserManager.getPlayer(player) == null) {
            return false;
        }
        if (UserManager.getPlayer(player2) == null) {
            return false;
        }
        Party party = UserManager.getPlayer(player).getParty();
        Party party2 = UserManager.getPlayer(player2).getParty();
        if (party == null || party2 == null) {
            return false;
        }
        return party.equals(party2);
    }

    public static boolean areAllies(Player player, Player player2) {
        if (UserManager.getPlayer(player) == null) {
            return false;
        }
        if (UserManager.getPlayer(player2) == null) {
            return false;
        }
        Party party = UserManager.getPlayer(player).getParty();
        Party party2 = UserManager.getPlayer(player2).getParty();
        if (party == null || party2 == null || party.getAlly() == null || party2.getAlly() == null) {
            return false;
        }
        return party.equals(party2.getAlly()) && party2.equals(party.getAlly());
    }

    public static List<Player> getNearMembers(McMMOPlayer mcMMOPlayer) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        Party party = mcMMOPlayer.getParty();
        if (party != null) {
            Player player = mcMMOPlayer.getPlayer();
            double d = Config.getInstance().getPartyShareRange();
            for (Player player2 : party.getOnlineMembers()) {
                if (player.equals(player2) || !player2.isValid() || !Misc.isNear(player.getLocation(), player2.getLocation(), d)) continue;
                arrayList.add(player2);
            }
        }
        return arrayList;
    }

    public static List<Player> getNearVisibleMembers(McMMOPlayer mcMMOPlayer) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        Party party = mcMMOPlayer.getParty();
        if (party != null) {
            Player player = mcMMOPlayer.getPlayer();
            double d = Config.getInstance().getPartyShareRange();
            for (Player player2 : party.getVisibleMembers(player)) {
                if (player.equals(player2) || !player2.isValid() || !Misc.isNear(player.getLocation(), player2.getLocation(), d)) continue;
                arrayList.add(player2);
            }
        }
        return arrayList;
    }

    public static LinkedHashMap<UUID, String> getAllMembers(Player player) {
        Party party = PartyManager.getParty(player);
        return party == null ? new LinkedHashMap<UUID, String>() : party.getMembers();
    }

    public static List<Player> getOnlineMembers(String string) {
        return PartyManager.getOnlineMembers(PartyManager.getParty(string));
    }

    public static List<Player> getOnlineMembers(Player player) {
        return PartyManager.getOnlineMembers(PartyManager.getParty(player));
    }

    private static List<Player> getOnlineMembers(Party party) {
        return party == null ? new ArrayList() : party.getOnlineMembers();
    }

    public static Party getParty(String string) {
        for (Party party : parties) {
            if (!party.getName().equalsIgnoreCase(string)) continue;
            return party;
        }
        return null;
    }

    @Deprecated
    public static Party getPlayerParty(String string) {
        for (Party party : parties) {
            if (!party.getMembers().keySet().contains(string)) continue;
            return party;
        }
        return null;
    }

    public static Party getPlayerParty(String string, UUID uUID) {
        for (Party party : parties) {
            LinkedHashMap<UUID, String> linkedHashMap = party.getMembers();
            if (!linkedHashMap.keySet().contains(uUID) && !linkedHashMap.values().contains(string)) continue;
            if (linkedHashMap.get(uUID) == null || !linkedHashMap.get(uUID).equals(string)) {
                linkedHashMap.put(uUID, string);
            }
            return party;
        }
        return null;
    }

    public static Party getParty(Player player) {
        if (UserManager.getPlayer(player) == null) {
            return null;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        return mcMMOPlayer.getParty();
    }

    public static List<Party> getParties() {
        return parties;
    }

    public static void removeFromParty(OfflinePlayer offlinePlayer, Party party) {
        LinkedHashMap<UUID, String> linkedHashMap = party.getMembers();
        String string = offlinePlayer.getName();
        linkedHashMap.remove(offlinePlayer.getUniqueId());
        if (offlinePlayer.isOnline()) {
            party.getOnlineMembers().remove(offlinePlayer.getPlayer());
        }
        if (linkedHashMap.isEmpty()) {
            parties.remove(party);
        } else {
            if (party.getLeader().getUniqueId().equals(offlinePlayer.getUniqueId())) {
                PartyManager.setPartyLeader(linkedHashMap.keySet().iterator().next(), party);
            }
            PartyManager.informPartyMembersQuit(party, string);
        }
    }

    public static void removeFromParty(McMMOPlayer mcMMOPlayer) {
        PartyManager.removeFromParty((OfflinePlayer)mcMMOPlayer.getPlayer(), mcMMOPlayer.getParty());
        PartyManager.processPartyLeaving(mcMMOPlayer);
    }

    public static void disbandParty(Party party) {
        for (Player player : party.getOnlineMembers()) {
            if (UserManager.getPlayer(player) == null) continue;
            PartyManager.processPartyLeaving(UserManager.getPlayer(player));
        }
        if (party.getAlly() != null) {
            party.getAlly().setAlly(null);
        }
        parties.remove(party);
    }

    public static void createParty(McMMOPlayer mcMMOPlayer, String string, String string2) {
        Player player = mcMMOPlayer.getPlayer();
        Party party = new Party(new PartyLeader(player.getUniqueId(), player.getName()), string.replace(".", ""), string2);
        if (string2 != null) {
            player.sendMessage(LocaleLoader.getString("Party.Password.Set", string2));
        }
        parties.add(party);
        player.sendMessage(LocaleLoader.getString("Commands.Party.Create", party.getName()));
        PartyManager.addToParty(mcMMOPlayer, party);
    }

    public static boolean checkPartyPassword(Player player, Party party, String string) {
        if (party.isLocked()) {
            String string2 = party.getPassword();
            if (string2 == null) {
                player.sendMessage(LocaleLoader.getString("Party.Locked"));
                return false;
            }
            if (string == null) {
                player.sendMessage(LocaleLoader.getString("Party.Password.None"));
                return false;
            }
            if (!string.equals(string2)) {
                player.sendMessage(LocaleLoader.getString("Party.Password.Incorrect"));
                return false;
            }
        }
        return true;
    }

    public static void joinInvitedParty(McMMOPlayer mcMMOPlayer) {
        Party party = mcMMOPlayer.getPartyInvite();
        if (!parties.contains(party)) {
            NotificationManager.sendPlayerInformation(mcMMOPlayer.getPlayer(), NotificationType.PARTY_MESSAGE, "Party.Disband");
            return;
        }
        if (Config.getInstance().getPartyMaxSize() > 0 && party.getMembers().size() >= Config.getInstance().getPartyMaxSize()) {
            NotificationManager.sendPlayerInformation(mcMMOPlayer.getPlayer(), NotificationType.PARTY_MESSAGE, "Commands.Party.PartyFull.InviteAccept", party.getName(), String.valueOf(Config.getInstance().getPartyMaxSize()));
            return;
        }
        NotificationManager.sendPlayerInformation(mcMMOPlayer.getPlayer(), NotificationType.PARTY_MESSAGE, "Commands.Party.Invite.Accepted", party.getName());
        mcMMOPlayer.removePartyInvite();
        PartyManager.addToParty(mcMMOPlayer, party);
    }

    public static void acceptAllianceInvite(McMMOPlayer mcMMOPlayer) {
        Party party = mcMMOPlayer.getPartyAllianceInvite();
        Player player = mcMMOPlayer.getPlayer();
        if (!parties.contains(party)) {
            player.sendMessage(LocaleLoader.getString("Party.Disband"));
            return;
        }
        if (!PartyManager.handlePartyChangeAllianceEvent(player, mcMMOPlayer.getParty().getName(), party.getName(), McMMOPartyAllianceChangeEvent.EventReason.FORMED_ALLIANCE)) {
            return;
        }
        player.sendMessage(LocaleLoader.getString("Commands.Party.Alliance.Invite.Accepted", party.getName()));
        mcMMOPlayer.removePartyAllianceInvite();
        PartyManager.createAlliance(mcMMOPlayer.getParty(), party);
    }

    public static void createAlliance(Party party, Party party2) {
        party.setAlly(party2);
        party2.setAlly(party);
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(LocaleLoader.getString("Party.Alliance.Formed", party2.getName()));
        }
        for (Player player : party2.getOnlineMembers()) {
            player.sendMessage(LocaleLoader.getString("Party.Alliance.Formed", party.getName()));
        }
    }

    public static boolean disbandAlliance(Player player, Party party, Party party2) {
        if (!PartyManager.handlePartyChangeAllianceEvent(player, party.getName(), party2.getName(), McMMOPartyAllianceChangeEvent.EventReason.DISBAND_ALLIANCE)) {
            return false;
        }
        PartyManager.disbandAlliance(party, party2);
        return true;
    }

    private static void disbandAlliance(Party party, Party party2) {
        party.setAlly(null);
        party2.setAlly(null);
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(LocaleLoader.getString("Party.Alliance.Disband", party2.getName()));
        }
        for (Player player : party2.getOnlineMembers()) {
            player.sendMessage(LocaleLoader.getString("Party.Alliance.Disband", party.getName()));
        }
    }

    public static void addToParty(McMMOPlayer mcMMOPlayer, Party party) {
        Player player = mcMMOPlayer.getPlayer();
        String string = player.getName();
        PartyManager.informPartyMembersJoin(party, string);
        mcMMOPlayer.setParty(party);
        party.getMembers().put(player.getUniqueId(), player.getName());
        party.getOnlineMembers().add(player);
    }

    public static String getPartyLeaderName(String string) {
        Party party = PartyManager.getParty(string);
        return party == null ? null : party.getLeader().getPlayerName();
    }

    public static void setPartyLeader(UUID uUID, Party party) {
        OfflinePlayer offlinePlayer = mcMMO.p.getServer().getOfflinePlayer(uUID);
        UUID uUID2 = party.getLeader().getUniqueId();
        for (Player player : party.getOnlineMembers()) {
            UUID uUID3 = player.getUniqueId();
            if (uUID3.equals(offlinePlayer.getUniqueId())) {
                player.sendMessage(LocaleLoader.getString("Party.Owner.Player"));
                continue;
            }
            if (uUID3.equals(uUID2)) {
                player.sendMessage(LocaleLoader.getString("Party.Owner.NotLeader"));
                continue;
            }
            player.sendMessage(LocaleLoader.getString("Party.Owner.New", offlinePlayer.getName()));
        }
        party.setLeader(new PartyLeader(offlinePlayer.getUniqueId(), offlinePlayer.getName()));
    }

    public static boolean canInvite(McMMOPlayer mcMMOPlayer) {
        Party party = mcMMOPlayer.getParty();
        return !party.isLocked() || party.getLeader().getUniqueId().equals(mcMMOPlayer.getPlayer().getUniqueId());
    }

    public static void loadParties() {
        if (!partyFile.exists()) {
            return;
        }
        if (mcMMO.getUpgradeManager().shouldUpgrade(UpgradeType.ADD_UUIDS_PARTY)) {
            PartyManager.loadAndUpgradeParties();
            return;
        }
        try {
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)partyFile);
            ArrayList<Party> arrayList = new ArrayList<Party>();
            for (String object : yamlConfiguration.getConfigurationSection("").getKeys(false)) {
                Party party = new Party(object);
                String[] stringArray = yamlConfiguration.getString(object + ".Leader").split("[|]");
                party.setLeader(new PartyLeader(UUID.fromString(stringArray[0]), stringArray[1]));
                party.setPassword(yamlConfiguration.getString(object + ".Password"));
                party.setLocked(yamlConfiguration.getBoolean(object + ".Locked"));
                party.setLevel(yamlConfiguration.getInt(object + ".Level"));
                party.setXp(yamlConfiguration.getInt(object + ".Xp"));
                if (yamlConfiguration.getString(object + ".Ally") != null) {
                    arrayList.add(party);
                }
                party.setXpShareMode(ShareMode.getShareMode(yamlConfiguration.getString(object + ".ExpShareMode", "NONE")));
                party.setItemShareMode(ShareMode.getShareMode(yamlConfiguration.getString(object + ".ItemShareMode", "NONE")));
                for (ItemShareType itemShareType : ItemShareType.values()) {
                    party.setSharingDrops(itemShareType, yamlConfiguration.getBoolean(object + ".ItemShareType." + itemShareType.toString(), true));
                }
                LinkedHashMap<UUID, String> linkedHashMap = party.getMembers();
                for (String string : yamlConfiguration.getStringList(object + ".Members")) {
                    String[] stringArray2 = string.split("[|]");
                    linkedHashMap.put(UUID.fromString(stringArray2[0]), stringArray2[1]);
                }
                parties.add(party);
            }
            mcMMO.p.debug("Loaded (" + parties.size() + ") Parties...");
            for (Party party : arrayList) {
                party.setAlly(PartyManager.getParty(yamlConfiguration.getString(party.getName() + ".Ally")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void saveParties() {
        if (partyFile.exists() && !partyFile.delete()) {
            mcMMO.p.getLogger().warning("Could not delete party file. Party saving failed!");
            return;
        }
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        mcMMO.p.debug("Saving Parties... (" + parties.size() + ")");
        for (Party party : parties) {
            String string = party.getName();
            PartyLeader partyLeader = party.getLeader();
            yamlConfiguration.set(string + ".Leader", (Object)(partyLeader.getUniqueId().toString() + "|" + partyLeader.getPlayerName()));
            yamlConfiguration.set(string + ".Password", (Object)party.getPassword());
            yamlConfiguration.set(string + ".Locked", (Object)party.isLocked());
            yamlConfiguration.set(string + ".Level", (Object)party.getLevel());
            yamlConfiguration.set(string + ".Xp", (Object)((int)party.getXp()));
            yamlConfiguration.set(string + ".Ally", (Object)(party.getAlly() != null ? party.getAlly().getName() : ""));
            yamlConfiguration.set(string + ".ExpShareMode", (Object)party.getXpShareMode().toString());
            yamlConfiguration.set(string + ".ItemShareMode", (Object)party.getItemShareMode().toString());
            for (Object object : ItemShareType.values()) {
                yamlConfiguration.set(string + ".ItemShareType." + object.toString(), (Object)party.sharingDrops((ItemShareType)((Object)object)));
            }
            ArrayList arrayList = new ArrayList();
            for (Map.Entry<UUID, String> entry : party.getMembers().entrySet()) {
                Object object;
                Object object2 = object = entry.getKey() == null ? "" : entry.getKey().toString();
                String string2 = entry.getValue();
                if (arrayList.contains(string2)) continue;
                arrayList.add((String)object + "|" + string2);
            }
            yamlConfiguration.set(string + ".Members", (Object)arrayList);
        }
        try {
            yamlConfiguration.save(partyFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void loadAndUpgradeParties() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)partyFile);
        if (!partyFile.renameTo(new File(mcMMO.getFlatFileDirectory() + "parties.yml.converted"))) {
            mcMMO.p.getLogger().severe("Could not rename parties.yml to parties.yml.converted!");
            return;
        }
        ArrayList<Party> arrayList = new ArrayList<Party>();
        for (String object : yamlConfiguration.getConfigurationSection("").getKeys(false)) {
            Party party = new Party(object);
            String string = yamlConfiguration.getString(object + ".Leader");
            PlayerProfile playerProfile = mcMMO.getDatabaseManager().loadPlayerProfile(string, false);
            if (!playerProfile.isLoaded()) {
                mcMMO.p.getLogger().warning("Could not find UUID in database for party leader " + string + " in party " + object);
                continue;
            }
            UUID uUID = playerProfile.getUniqueId();
            party.setLeader(new PartyLeader(uUID, string));
            party.setPassword(yamlConfiguration.getString(object + ".Password"));
            party.setLocked(yamlConfiguration.getBoolean(object + ".Locked"));
            party.setLevel(yamlConfiguration.getInt(object + ".Level"));
            party.setXp(yamlConfiguration.getInt(object + ".Xp"));
            if (yamlConfiguration.getString(object + ".Ally") != null) {
                arrayList.add(party);
            }
            party.setXpShareMode(ShareMode.getShareMode(yamlConfiguration.getString(object + ".ExpShareMode", "NONE")));
            party.setItemShareMode(ShareMode.getShareMode(yamlConfiguration.getString(object + ".ItemShareMode", "NONE")));
            for (ItemShareType itemShareType : ItemShareType.values()) {
                party.setSharingDrops(itemShareType, yamlConfiguration.getBoolean(object + ".ItemShareType." + itemShareType.toString(), true));
            }
            LinkedHashMap<UUID, String> linkedHashMap = party.getMembers();
            for (String string2 : yamlConfiguration.getStringList(object + ".Members")) {
                PlayerProfile playerProfile2 = mcMMO.getDatabaseManager().loadPlayerProfile(string2, false);
                if (!playerProfile2.isLoaded()) {
                    mcMMO.p.getLogger().warning("Could not find UUID in database for party member " + string2 + " in party " + object);
                    continue;
                }
                UUID uUID2 = playerProfile2.getUniqueId();
                linkedHashMap.put(uUID2, string2);
            }
            parties.add(party);
        }
        mcMMO.p.debug("Loaded (" + parties.size() + ") Parties...");
        for (Party party : arrayList) {
            party.setAlly(PartyManager.getParty(yamlConfiguration.getString(party.getName() + ".Ally")));
        }
        mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_UUIDS_PARTY);
    }

    public static boolean handlePartyChangeEvent(Player player, String string, String string2, McMMOPartyChangeEvent.EventReason eventReason) {
        McMMOPartyChangeEvent mcMMOPartyChangeEvent = new McMMOPartyChangeEvent(player, string, string2, eventReason);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPartyChangeEvent);
        return !mcMMOPartyChangeEvent.isCancelled();
    }

    public static boolean handlePartyChangeAllianceEvent(Player player, String string, String string2, McMMOPartyAllianceChangeEvent.EventReason eventReason) {
        McMMOPartyAllianceChangeEvent mcMMOPartyAllianceChangeEvent = new McMMOPartyAllianceChangeEvent(player, string, string2, eventReason);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)mcMMOPartyAllianceChangeEvent);
        return !mcMMOPartyAllianceChangeEvent.isCancelled();
    }

    public static void processPartyLeaving(McMMOPlayer mcMMOPlayer) {
        mcMMOPlayer.removeParty();
        mcMMOPlayer.disableChat(ChatMode.PARTY);
        mcMMOPlayer.setItemShareModifier(10);
    }

    public static void informPartyMembersLevelUp(Party party, int n, int n2) {
        boolean bl = Config.getInstance().getLevelUpSoundsEnabled();
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(LocaleLoader.getString("Party.LevelUp", n, n2));
            if (!bl) continue;
            SoundManager.sendSound(player, player.getLocation(), SoundType.LEVEL_UP);
        }
    }

    private static void informPartyMembersJoin(Party party, String string) {
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(LocaleLoader.getString("Party.InformedOnJoin", string));
        }
    }

    private static void informPartyMembersQuit(Party party, String string) {
        for (Player player : party.getOnlineMembers()) {
            player.sendMessage(LocaleLoader.getString("Party.InformedOnQuit", string));
        }
    }
}

