/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.bstat.bukkit;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Metrics {
    public static final int B_STATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/bukkit";
    private boolean enabled;
    private static boolean logFailedRequests;
    private static boolean logSentData;
    private static boolean logResponseStatusText;
    private static String serverUUID;
    private final Plugin plugin;
    private final List<CustomChart> charts = new ArrayList<CustomChart>();

    public Metrics(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null!");
        }
        this.plugin = plugin;
        File file = new File(plugin.getDataFolder().getParentFile(), "bStats");
        File file2 = new File(file, "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
        if (!yamlConfiguration.isSet("serverUuid")) {
            yamlConfiguration.addDefault("enabled", (Object)true);
            yamlConfiguration.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            yamlConfiguration.addDefault("logFailedRequests", (Object)false);
            yamlConfiguration.addDefault("logSentData", (Object)false);
            yamlConfiguration.addDefault("logResponseStatusText", (Object)false);
            yamlConfiguration.options().header("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)").copyDefaults(true);
            try {
                yamlConfiguration.save(file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.enabled = yamlConfiguration.getBoolean("enabled", true);
        serverUUID = yamlConfiguration.getString("serverUuid");
        logFailedRequests = yamlConfiguration.getBoolean("logFailedRequests", false);
        logSentData = yamlConfiguration.getBoolean("logSentData", false);
        logResponseStatusText = yamlConfiguration.getBoolean("logResponseStatusText", false);
        if (this.enabled) {
            boolean bl = false;
            for (Class clazz : Bukkit.getServicesManager().getKnownServices()) {
                try {
                    clazz.getField("B_STATS_VERSION");
                    bl = true;
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            Bukkit.getServicesManager().register(Metrics.class, (Object)this, plugin, ServicePriority.Normal);
            if (!bl) {
                this.startSubmitting();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addCustomChart(CustomChart customChart) {
        if (customChart == null) {
            throw new IllegalArgumentException("Chart cannot be null!");
        }
        this.charts.add(customChart);
    }

    private void startSubmitting() {
        final Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!Metrics.this.plugin.isEnabled()) {
                    timer.cancel();
                    return;
                }
                Bukkit.getScheduler().runTask(Metrics.this.plugin, () -> Metrics.this.submitData());
            }
        }, 300000L, 1800000L);
    }

    public JSONObject getPluginData() {
        JSONObject jSONObject = new JSONObject();
        String string = this.plugin.getDescription().getName();
        String string2 = this.plugin.getDescription().getVersion();
        jSONObject.put((Object)"pluginName", (Object)string);
        jSONObject.put((Object)"pluginVersion", (Object)string2);
        JSONArray jSONArray = new JSONArray();
        for (CustomChart customChart : this.charts) {
            JSONObject jSONObject2 = customChart.getRequestJsonObject();
            if (jSONObject2 == null) continue;
            jSONArray.add((Object)jSONObject2);
        }
        jSONObject.put((Object)"customCharts", (Object)jSONArray);
        return jSONObject;
    }

    private JSONObject getServerData() {
        int n;
        try {
            Method method = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
            n = method.getReturnType().equals(Collection.class) ? ((Collection)method.invoke((Object)Bukkit.getServer(), new Object[0])).size() : ((Player[])method.invoke((Object)Bukkit.getServer(), new Object[0])).length;
        }
        catch (Exception exception) {
            n = Bukkit.getOnlinePlayers().size();
        }
        int n2 = Bukkit.getOnlineMode() ? 1 : 0;
        String string = Bukkit.getVersion();
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("os.name");
        String string4 = System.getProperty("os.arch");
        String string5 = System.getProperty("os.version");
        int n3 = Runtime.getRuntime().availableProcessors();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"serverUUID", (Object)serverUUID);
        jSONObject.put((Object)"playerAmount", (Object)n);
        jSONObject.put((Object)"onlineMode", (Object)n2);
        jSONObject.put((Object)"bukkitVersion", (Object)string);
        jSONObject.put((Object)"javaVersion", (Object)string2);
        jSONObject.put((Object)"osName", (Object)string3);
        jSONObject.put((Object)"osArch", (Object)string4);
        jSONObject.put((Object)"osVersion", (Object)string5);
        jSONObject.put((Object)"coreCount", (Object)n3);
        return jSONObject;
    }

    private void submitData() {
        final JSONObject jSONObject = this.getServerData();
        JSONArray jSONArray = new JSONArray();
        for (Class clazz : Bukkit.getServicesManager().getKnownServices()) {
            try {
                clazz.getField("B_STATS_VERSION");
                for (RegisteredServiceProvider registeredServiceProvider : Bukkit.getServicesManager().getRegistrations(clazz)) {
                    try {
                        jSONArray.add(registeredServiceProvider.getService().getMethod("getPluginData", new Class[0]).invoke(registeredServiceProvider.getProvider(), new Object[0]));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {}
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        jSONObject.put((Object)"plugins", (Object)jSONArray);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        Metrics.sendData(Metrics.this.plugin, jSONObject);
                    }
                    catch (Exception exception) {
                        if (!logFailedRequests) break block2;
                        Metrics.this.plugin.getLogger().log(Level.WARNING, "Could not submit plugin stats of " + Metrics.this.plugin.getName(), exception);
                    }
                }
            }
        }).start();
    }

    private static void sendData(Plugin plugin, JSONObject jSONObject) {
        String string;
        if (jSONObject == null) {
            throw new IllegalArgumentException("Data cannot be null!");
        }
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalAccessException("This method must not be called from the main thread!");
        }
        if (logSentData) {
            plugin.getLogger().info("Sending data to bStats: " + jSONObject.toString());
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] byArray = Metrics.compress(jSONObject.toString());
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.addRequestProperty("Accept", "application/json");
        httpsURLConnection.addRequestProperty("Connection", "close");
        httpsURLConnection.addRequestProperty("Content-Encoding", "gzip");
        httpsURLConnection.addRequestProperty("Content-Length", String.valueOf(byArray.length));
        httpsURLConnection.setRequestProperty("Content-Type", "application/json");
        httpsURLConnection.setRequestProperty("User-Agent", "MC-Server/1");
        httpsURLConnection.setDoOutput(true);
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        dataOutputStream.close();
        InputStream inputStream = httpsURLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        if (logResponseStatusText) {
            plugin.getLogger().info("Sent data to bStats and received response: " + stringBuilder.toString());
        }
    }

    private static byte[] compress(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    static {
        if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
            String string = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115, 46, 98, 117, 107, 107, 105, 116});
            String string2 = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
            if (Metrics.class.getPackage().getName().equals(string) || Metrics.class.getPackage().getName().equals(string2)) {
                throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
            }
        }
    }

    public static class AdvancedBarChart
    extends CustomChart {
        private final Callable<Map<String, int[]>> callable;

        public AdvancedBarChart(String string, Callable<Map<String, int[]>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            Map<String, int[]> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                bl = false;
                JSONArray jSONArray = new JSONArray();
                for (int n : entry.getValue()) {
                    jSONArray.add((Object)n);
                }
                jSONObject2.put((Object)entry.getKey(), (Object)jSONArray);
            }
            if (bl) {
                return null;
            }
            jSONObject.put((Object)"values", (Object)jSONObject2);
            return jSONObject;
        }
    }

    public static class SimpleBarChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public SimpleBarChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.add((Object)entry.getValue());
                jSONObject2.put((Object)entry.getKey(), (Object)jSONArray);
            }
            jSONObject.put((Object)"values", (Object)jSONObject2);
            return jSONObject;
        }
    }

    public static class MultiLineChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public MultiLineChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                jSONObject2.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            if (bl) {
                return null;
            }
            jSONObject.put((Object)"values", (Object)jSONObject2);
            return jSONObject;
        }
    }

    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(String string, Callable<Integer> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() {
            JSONObject jSONObject = new JSONObject();
            int n = this.callable.call();
            if (n == 0) {
                return null;
            }
            jSONObject.put((Object)"value", (Object)n);
            return jSONObject;
        }
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String string, Callable<Map<String, Map<String, Integer>>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        public JSONObject getChartData() {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Map<String, Integer>> entry : map.entrySet()) {
                JSONObject jSONObject3 = new JSONObject();
                boolean bl2 = true;
                for (Map.Entry<String, Integer> entry2 : map.get(entry.getKey()).entrySet()) {
                    jSONObject3.put((Object)entry2.getKey(), (Object)entry2.getValue());
                    bl2 = false;
                }
                if (bl2) continue;
                bl = false;
                jSONObject2.put((Object)entry.getKey(), (Object)jSONObject3);
            }
            if (bl) {
                return null;
            }
            jSONObject.put((Object)"values", (Object)jSONObject2);
            return jSONObject;
        }
    }

    public static class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                jSONObject2.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            if (bl) {
                return null;
            }
            jSONObject.put((Object)"values", (Object)jSONObject2);
            return jSONObject;
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String string, Callable<String> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JSONObject getChartData() {
            JSONObject jSONObject = new JSONObject();
            String string = this.callable.call();
            if (string == null || string.isEmpty()) {
                return null;
            }
            jSONObject.put((Object)"value", (Object)string);
            return jSONObject;
        }
    }

    public static abstract class CustomChart {
        final String chartId;

        CustomChart(String string) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = string;
        }

        private JSONObject getRequestJsonObject() {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"chartId", (Object)this.chartId);
            try {
                JSONObject jSONObject2 = this.getChartData();
                if (jSONObject2 == null) {
                    return null;
                }
                jSONObject.put((Object)"data", (Object)jSONObject2);
            }
            catch (Throwable throwable) {
                if (logFailedRequests) {
                    Bukkit.getLogger().log(Level.WARNING, "Failed to get data for custom chart with id " + this.chartId, throwable);
                }
                return null;
            }
            return jSONObject;
        }

        protected abstract JSONObject getChartData();
    }
}

