/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.CoreSkillsConfig;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.config.RankConfig;
import com.gmail.nossr50.config.SoundConfig;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.mods.ArmorConfigManager;
import com.gmail.nossr50.config.mods.BlockConfigManager;
import com.gmail.nossr50.config.mods.EntityConfigManager;
import com.gmail.nossr50.config.mods.ToolConfigManager;
import com.gmail.nossr50.config.skills.alchemy.PotionConfig;
import com.gmail.nossr50.config.skills.repair.RepairConfigManager;
import com.gmail.nossr50.config.skills.salvage.SalvageConfigManager;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.database.DatabaseManagerFactory;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.subskills.acrobatics.Roll;
import com.gmail.nossr50.listeners.BlockListener;
import com.gmail.nossr50.listeners.EntityListener;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.listeners.InventoryListener;
import com.gmail.nossr50.listeners.PlayerListener;
import com.gmail.nossr50.listeners.SelfListener;
import com.gmail.nossr50.listeners.WorldListener;
import com.gmail.nossr50.metrics.bstat.bukkit.Metrics;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.runnables.CheckDateTask;
import com.gmail.nossr50.runnables.SaveTimerTask;
import com.gmail.nossr50.runnables.backups.CleanBackupsTask;
import com.gmail.nossr50.runnables.commands.NotifySquelchReminderTask;
import com.gmail.nossr50.runnables.database.UserPurgeTask;
import com.gmail.nossr50.runnables.party.PartyAutoKickTask;
import com.gmail.nossr50.runnables.player.ClearRegisteredXPGainTask;
import com.gmail.nossr50.runnables.player.PlayerProfileLoadingTask;
import com.gmail.nossr50.runnables.player.PowerLevelUpdatingTask;
import com.gmail.nossr50.runnables.skills.BleedTimerTask;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.child.ChildConfig;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import com.gmail.nossr50.skills.repair.repairables.RepairableManager;
import com.gmail.nossr50.skills.repair.repairables.SimpleRepairableManager;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import com.gmail.nossr50.skills.salvage.salvageables.SalvageableManager;
import com.gmail.nossr50.skills.salvage.salvageables.SimpleSalvageableManager;
import com.gmail.nossr50.util.ChimaeraWing;
import com.gmail.nossr50.util.HolidayManager;
import com.gmail.nossr50.util.LogFilter;
import com.gmail.nossr50.util.MaterialMapStore;
import com.gmail.nossr50.util.ModManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.blockmeta.chunkmeta.ChunkManager;
import com.gmail.nossr50.util.blockmeta.chunkmeta.ChunkManagerFactory;
import com.gmail.nossr50.util.commands.CommandRegistrationManager;
import com.gmail.nossr50.util.experience.FormulaManager;
import com.gmail.nossr50.util.player.PlayerLevelUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.upgrade.UpgradeManager;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import net.shatteredlands.shatt.backup.ZipLibrary;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Recipe;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class mcMMO
extends JavaPlugin {
    private static ChunkManager placeStore;
    private static RepairableManager repairableManager;
    private static SalvageableManager salvageableManager;
    private static ModManager modManager;
    private static DatabaseManager databaseManager;
    private static FormulaManager formulaManager;
    private static HolidayManager holidayManager;
    private static UpgradeManager upgradeManager;
    private static MaterialMapStore materialMapStore;
    private static PlayerLevelUtils playerLevelUtils;
    private static WorldBlacklist worldBlacklist;
    private static String mainDirectory;
    private static String localesDirectory;
    private static String flatFileDirectory;
    private static String usersFile;
    private static String modDirectory;
    public static mcMMO p;
    public static File mcmmo;
    private static boolean healthBarPluginEnabled;
    private static boolean serverAPIOutdated;
    public boolean noErrorsInConfigFiles = true;
    private boolean xpEventEnabled;
    private static boolean isRetroModeEnabled;
    public static final String FISH_HOOK_REF_METAKEY = "mcMMO: Fish Hook Tracker";
    public static final String CUSTOM_DAMAGE_METAKEY = "mcMMO: Custom Damage";
    public static final String COTW_TEMPORARY_SUMMON = "mcMMO: COTW Entity";
    public static final String entityMetadataKey = "mcMMO: Spawned Entity";
    public static final String blockMetadataKey = "mcMMO: Piston Tracking";
    public static final String furnaceMetadataKey = "mcMMO: Tracked Furnace";
    public static final String tntMetadataKey = "mcMMO: Tracked TNT";
    public static final String funfettiMetadataKey = "mcMMO: Funfetti";
    public static final String tntsafeMetadataKey = "mcMMO: Safe TNT";
    public static final String customNameKey = "mcMMO: Custom Name";
    public static final String customVisibleKey = "mcMMO: Name Visibility";
    public static final String droppedItemKey = "mcMMO: Tracked Item";
    public static final String infiniteArrowKey = "mcMMO: Infinite Arrow";
    public static final String trackedArrow = "mcMMO: Tracked Arrow";
    public static final String bowForceKey = "mcMMO: Bow Force";
    public static final String arrowDistanceKey = "mcMMO: Arrow Distance";
    public static final String BONUS_DROPS_METAKEY = "mcMMO: Double Drops";
    public static final String disarmedItemKey = "mcMMO: Disarmed Item";
    public static final String playerDataKey = "mcMMO: Player Data";
    public static final String greenThumbDataKey = "mcMMO: Green Thumb";
    public static final String databaseCommandKey = "mcMMO: Processing Database Command";
    public static final String bredMetadataKey = "mcMMO: Bred Animal";
    public static FixedMetadataValue metadataValue;

    public void onEnable() {
        mcMMO.loadConfig0();
        try {
            p = this;
            this.getLogger().setFilter(new LogFilter(this));
            metadataValue = new FixedMetadataValue((Plugin)this, (Object)true);
            PluginManager pluginManager = this.getServer().getPluginManager();
            healthBarPluginEnabled = pluginManager.getPlugin("HealthBar") != null;
            upgradeManager = new UpgradeManager();
            this.setupFilePaths();
            modManager = new ModManager();
            this.loadConfigFiles();
            if (!this.noErrorsInConfigFiles) {
                return;
            }
            isRetroModeEnabled = Config.getInstance().getIsRetroMode();
            if (this.getServer().getName().equals("Cauldron") || this.getServer().getName().equals("MCPC+")) {
                this.checkModConfigs();
            }
            if (healthBarPluginEnabled) {
                this.getLogger().info("HealthBar plugin found, mcMMO's healthbars are automatically disabled.");
            }
            if (pluginManager.getPlugin("NoCheatPlus") != null && pluginManager.getPlugin("CompatNoCheatPlus") == null) {
                this.getLogger().warning("NoCheatPlus plugin found, but CompatNoCheatPlus was not found!");
                this.getLogger().warning("mcMMO will not work properly alongside NoCheatPlus without CompatNoCheatPlus");
            }
            databaseManager = DatabaseManagerFactory.getDatabaseManager();
            this.checkForOutdatedAPI();
            if (serverAPIOutdated) {
                Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> this.getLogger().severe("You are running an outdated version of " + (Object)((Object)this.getServerSoftware()) + ", mcMMO will not work unless you update to a newer version!"), 20L, 36000L);
                if (this.getServerSoftware() == ServerSoftwareType.CRAFTBUKKIT) {
                    Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> this.getLogger().severe("We have detected you are using incompatible server software, our best guess is that you are using CraftBukkit. mcMMO requires Spigot or Paper, if you are not using CraftBukkit, you will still need to update your custom server software before mcMMO will work."), 20L, 36000L);
                }
            } else {
                this.registerEvents();
                this.registerCoreSkills();
                this.registerCustomRecipes();
                PartyManager.loadParties();
                formulaManager = new FormulaManager();
                holidayManager = new HolidayManager();
                for (Player player : this.getServer().getOnlinePlayers()) {
                    new PlayerProfileLoadingTask(player).runTaskLaterAsynchronously((Plugin)p, 1L);
                }
                this.debug("Version " + this.getDescription().getVersion() + " is enabled!");
                this.scheduleTasks();
                CommandRegistrationManager.registerCommands();
                placeStore = ChunkManagerFactory.getChunkManager();
                if (Config.getInstance().getPTPCommandWorldPermissions()) {
                    Permissions.generateWorldTeleportPermissions();
                }
                RankUtils.populateRanks();
            }
            if (Config.getInstance().getIsMetricsEnabled()) {
                Metrics metrics = new Metrics((Plugin)this);
                metrics.addCustomChart(new Metrics.SimplePie("version", () -> this.getDescription().getVersion()));
                if (Config.getInstance().getIsRetroMode()) {
                    metrics.addCustomChart(new Metrics.SimplePie("scaling", () -> "Standard"));
                } else {
                    metrics.addCustomChart(new Metrics.SimplePie("scaling", () -> "Retro"));
                }
            }
        }
        catch (Throwable throwable) {
            this.getLogger().severe("There was an error while enabling mcMMO!");
            if (!(throwable instanceof ExceptionInInitializerError)) {
                throwable.printStackTrace();
            } else {
                this.getLogger().info("Please do not replace the mcMMO jar while the server is running.");
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        materialMapStore = new MaterialMapStore();
        playerLevelUtils = new PlayerLevelUtils();
        worldBlacklist = new WorldBlacklist(this);
    }

    public static PlayerLevelUtils getPlayerLevelUtils() {
        return playerLevelUtils;
    }

    public static MaterialMapStore getMaterialMapStore() {
        return materialMapStore;
    }

    private void checkForOutdatedAPI() {
        try {
            Class<?> clazz = Class.forName("org.bukkit.event.block.BlockDropItemEvent");
            Method method = clazz.getMethod("getItems", new Class[0]);
            Class<?> clazz2 = Class.forName("net.md_5.bungee.api.chat.BaseComponent");
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            serverAPIOutdated = true;
            String string = this.getServerSoftwareStr();
            this.getLogger().severe("You are running an older version of " + string + " that is not compatible with mcMMO, update your server software!");
        }
    }

    private ServerSoftwareType getServerSoftware() {
        if (Bukkit.getVersion().toLowerCase().contains("paper")) {
            return ServerSoftwareType.PAPER;
        }
        if (Bukkit.getVersion().toLowerCase().contains("spigot")) {
            return ServerSoftwareType.SPIGOT;
        }
        return ServerSoftwareType.CRAFTBUKKIT;
    }

    private String getServerSoftwareStr() {
        switch (this.getServerSoftware()) {
            case PAPER: {
                return "Paper";
            }
            case SPIGOT: {
                return "Spigot";
            }
        }
        return "CraftBukkit";
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            WorldGuardManager.getInstance().registerFlags();
        }
    }

    public void onDisable() {
        try {
            UserManager.saveAll();
            UserManager.clearAll();
            Alchemy.finishAllBrews();
            PartyManager.saveParties();
            if (Config.getInstance().getScoreboardsEnabled()) {
                ScoreboardManager.teardownAll();
            }
            formulaManager.saveFormula();
            holidayManager.saveAnniversaryFiles();
            placeStore.saveAll();
            placeStore.cleanUp();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debug("Canceling all tasks...");
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.debug("Unregister all events...");
        HandlerList.unregisterAll((Plugin)this);
        if (Config.getInstance().getBackupsEnabled()) {
            try {
                ZipLibrary.mcMMOBackup();
            }
            catch (IOException iOException) {
                this.getLogger().severe(iOException.toString());
            }
            catch (Throwable throwable) {
                if (throwable instanceof NoClassDefFoundError) {
                    this.getLogger().severe("Backup class not found!");
                    this.getLogger().info("Please do not replace the mcMMO jar while the server is running.");
                }
                this.getLogger().severe(throwable.toString());
            }
        }
        databaseManager.onDisable();
        this.debug("Was disabled.");
    }

    public static String getMainDirectory() {
        return mainDirectory;
    }

    public static String getLocalesDirectory() {
        return localesDirectory;
    }

    public static String getFlatFileDirectory() {
        return flatFileDirectory;
    }

    public static String getUsersFilePath() {
        return usersFile;
    }

    public static String getModDirectory() {
        return modDirectory;
    }

    public boolean isXPEventEnabled() {
        return this.xpEventEnabled;
    }

    public void setXPEventEnabled(boolean bl) {
        this.xpEventEnabled = bl;
    }

    public void toggleXpEventEnabled() {
        this.xpEventEnabled = !this.xpEventEnabled;
    }

    public void debug(String string) {
        this.getLogger().info("[Debug] " + string);
    }

    public static FormulaManager getFormulaManager() {
        return formulaManager;
    }

    public static HolidayManager getHolidayManager() {
        return holidayManager;
    }

    public static ChunkManager getPlaceStore() {
        return placeStore;
    }

    public static RepairableManager getRepairableManager() {
        return repairableManager;
    }

    public static SalvageableManager getSalvageableManager() {
        return salvageableManager;
    }

    public static DatabaseManager getDatabaseManager() {
        return databaseManager;
    }

    public static ModManager getModManager() {
        return modManager;
    }

    public static UpgradeManager getUpgradeManager() {
        return upgradeManager;
    }

    @Deprecated
    public static void setDatabaseManager(DatabaseManager databaseManager) {
        mcMMO.databaseManager = databaseManager;
    }

    public static boolean isHealthBarPluginEnabled() {
        return healthBarPluginEnabled;
    }

    private void setupFilePaths() {
        mcmmo = this.getFile();
        mainDirectory = this.getDataFolder().getPath() + File.separator;
        localesDirectory = mainDirectory + "locales" + File.separator;
        flatFileDirectory = mainDirectory + "flatfile" + File.separator;
        usersFile = flatFileDirectory + "mcmmo.users";
        modDirectory = mainDirectory + "mods" + File.separator;
        this.fixFilePaths();
    }

    private void fixFilePaths() {
        File file = new File(mainDirectory + "FlatFileStuff" + File.separator);
        File file2 = new File(mainDirectory + "ModConfigs" + File.separator);
        if (file.exists() && !file.renameTo(new File(flatFileDirectory))) {
            this.getLogger().warning("Failed to rename FlatFileStuff to flatfile!");
        }
        if (file2.exists() && !file2.renameTo(new File(modDirectory))) {
            this.getLogger().warning("Failed to rename ModConfigs to mods!");
        }
        File file3 = new File(modDirectory + "armor.yml");
        File file4 = new File(modDirectory + "blocks.yml");
        File file5 = new File(modDirectory + "entities.yml");
        File file6 = new File(modDirectory + "tools.yml");
        if (file3.exists() && !file3.renameTo(new File(modDirectory + "armor.default.yml"))) {
            this.getLogger().warning("Failed to rename armor.yml to armor.default.yml!");
        }
        if (file4.exists() && !file4.renameTo(new File(modDirectory + "blocks.default.yml"))) {
            this.getLogger().warning("Failed to rename blocks.yml to blocks.default.yml!");
        }
        if (file5.exists() && !file5.renameTo(new File(modDirectory + "entities.default.yml"))) {
            this.getLogger().warning("Failed to rename entities.yml to entities.default.yml!");
        }
        if (file6.exists() && !file6.renameTo(new File(modDirectory + "tools.default.yml"))) {
            this.getLogger().warning("Failed to rename tools.yml to tools.default.yml!");
        }
        File file7 = new File(flatFileDirectory);
        file7.mkdirs();
        File file8 = new File(localesDirectory);
        file8.mkdirs();
    }

    private void loadConfigFiles() {
        TreasureConfig.getInstance();
        HiddenConfig.getInstance();
        AdvancedConfig.getInstance();
        PotionConfig.getInstance();
        CoreSkillsConfig.getInstance();
        SoundConfig.getInstance();
        RankConfig.getInstance();
        new ChildConfig();
        ArrayList<Repairable> arrayList = new ArrayList<Repairable>();
        ArrayList<Salvageable> arrayList2 = new ArrayList<Salvageable>();
        if (Config.getInstance().getToolModsEnabled()) {
            new ToolConfigManager(this);
        }
        if (Config.getInstance().getArmorModsEnabled()) {
            new ArmorConfigManager(this);
        }
        if (Config.getInstance().getBlockModsEnabled()) {
            new BlockConfigManager(this);
        }
        if (Config.getInstance().getEntityModsEnabled()) {
            new EntityConfigManager(this);
        }
        arrayList.addAll(new RepairConfigManager(this).getLoadedRepairables());
        arrayList.addAll(modManager.getLoadedRepairables());
        repairableManager = new SimpleRepairableManager(arrayList.size());
        repairableManager.registerRepairables(arrayList);
        SalvageConfigManager salvageConfigManager = new SalvageConfigManager(this);
        arrayList2.addAll(salvageConfigManager.getLoadedSalvageables());
        salvageableManager = new SimpleSalvageableManager(arrayList2.size());
        salvageableManager.registerSalvageables(arrayList2);
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new BlockListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new SelfListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldListener(this), (Plugin)this);
    }

    private void registerCoreSkills() {
        InteractionManager.initMaps();
        if (CoreSkillsConfig.getInstance().isPrimarySkillEnabled(PrimarySkillType.ACROBATICS)) {
            System.out.println("[mcMMO] enabling Acrobatics Skills");
            Roll roll = new Roll();
            CoreSkillsConfig.getInstance().isSkillEnabled(roll);
            InteractionManager.registerSubSkill(new Roll());
        }
    }

    private void registerCustomRecipes() {
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            if (Config.getInstance().getChimaeraEnabled()) {
                this.getServer().addRecipe((Recipe)ChimaeraWing.getChimaeraWingRecipe());
            }
        }, 40L);
    }

    private void scheduleTasks() {
        long l = Config.getInstance().getSaveInterval() * 1200;
        new SaveTimerTask().runTaskTimer((Plugin)this, l, l);
        new CleanBackupsTask().runTaskAsynchronously((Plugin)p);
        new BleedTimerTask().runTaskTimer((Plugin)this, 20L, 10L);
        long l2 = (long)Config.getInstance().getPurgeInterval() * 60L * 60L * 20L;
        if (l2 == 0L) {
            new UserPurgeTask().runTaskLaterAsynchronously((Plugin)this, 40L);
        } else if (l2 > 0L) {
            new UserPurgeTask().runTaskTimerAsynchronously((Plugin)this, l2, l2);
        }
        long l3 = (long)Config.getInstance().getAutoPartyKickInterval() * 60L * 60L * 20L;
        if (l3 == 0L) {
            new PartyAutoKickTask().runTaskLater((Plugin)this, 40L);
        } else if (l3 > 0L) {
            new PartyAutoKickTask().runTaskTimer((Plugin)this, l3, l3);
        }
        new PowerLevelUpdatingTask().runTaskTimer((Plugin)this, 40L, 40L);
        if (mcMMO.getHolidayManager().nearingAprilFirst()) {
            new CheckDateTask().runTaskTimer((Plugin)this, 200L, 72000L);
        }
        if (ExperienceConfig.getInstance().getDiminishedReturnsEnabled()) {
            new ClearRegisteredXPGainTask().runTaskTimer((Plugin)this, 60L, 60L);
        }
        if (AdvancedConfig.getInstance().allowPlayerTips()) {
            new NotifySquelchReminderTask().runTaskTimer((Plugin)this, 60L, 72000L);
        }
    }

    private void checkModConfigs() {
        if (!Config.getInstance().getToolModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom tool config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Tool_Mods_Enabled to TRUE in config.yml.");
        }
        if (!Config.getInstance().getArmorModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom armor config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Armor_Mods_Enabled to TRUE in config.yml.");
        }
        if (!Config.getInstance().getBlockModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom block config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Block_Mods_Enabled to TRUE in config.yml.");
        }
        if (!Config.getInstance().getEntityModsEnabled()) {
            this.getLogger().warning("Cauldron implementation found, but the custom entity config for mcMMO is disabled!");
            this.getLogger().info("To enable, set Mods.Entity_Mods_Enabled to TRUE in config.yml.");
        }
    }

    public InputStreamReader getResourceAsReader(String string) {
        InputStream inputStream = this.getResource(string);
        return inputStream == null ? null : new InputStreamReader(inputStream, Charsets.UTF_8);
    }

    public static boolean isRetroModeEnabled() {
        return isRetroModeEnabled;
    }

    public static WorldBlacklist getWorldBlacklist() {
        return worldBlacklist;
    }

    static {
        serverAPIOutdated = false;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=661359&resource_id=64348&nonce=-1970411186").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static enum ServerSoftwareType {
        PAPER,
        SPIGOT,
        CRAFTBUKKIT;

    }
}

