/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.locale;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.mcMMO;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.bukkit.ChatColor;

public final class LocaleLoader {
    private static final String BUNDLE_ROOT = "com.gmail.nossr50.locale.locale";
    private static Map<String, String> bundleCache = new HashMap<String, String>();
    private static ResourceBundle bundle = null;
    private static ResourceBundle filesystemBundle = null;
    private static ResourceBundle enBundle = null;

    private LocaleLoader() {
    }

    public static String getString(String string) {
        return LocaleLoader.getString(string, null);
    }

    public static String getString(String string, Object ... objectArray) {
        if (bundle == null) {
            LocaleLoader.initialize();
        }
        String string2 = bundleCache.computeIfAbsent(string, LocaleLoader::getRawString);
        return LocaleLoader.formatString(string2, objectArray);
    }

    public static void reloadLocale() {
        bundle = null;
        filesystemBundle = null;
        enBundle = null;
        bundleCache = new HashMap<String, String>();
        LocaleLoader.initialize();
    }

    private static String getRawString(String string) {
        if (filesystemBundle != null) {
            try {
                return filesystemBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            return bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return enBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                if (!string.contains("Guides")) {
                    mcMMO.p.getLogger().warning("Could not find locale string: " + string);
                }
                return '!' + string + '!';
            }
        }
    }

    public static String formatString(String string, Object ... objectArray) {
        if (objectArray != null) {
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.applyPattern(string.replace("'", "''"));
            string = messageFormat.format(objectArray);
        }
        string = LocaleLoader.addColors(string);
        return string;
    }

    public static Locale getCurrentLocale() {
        if (bundle == null) {
            LocaleLoader.initialize();
        }
        return bundle.getLocale();
    }

    private static void initialize() {
        if (bundle == null) {
            Locale.setDefault(new Locale("en", "US"));
            Locale locale = null;
            String[] stringArray = Config.getInstance().getLocale().split("[-_ ]");
            if (stringArray.length == 1) {
                locale = new Locale(stringArray[0]);
            } else if (stringArray.length >= 2) {
                locale = new Locale(stringArray[0], stringArray[1]);
            }
            if (locale == null) {
                throw new IllegalStateException("Failed to parse locale string '" + Config.getInstance().getLocale() + "'");
            }
            Path path = Paths.get(mcMMO.getLocalesDirectory() + "locale_" + locale.toString() + ".properties", new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
                try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                    mcMMO.p.getLogger().log(Level.INFO, "Loading locale from {0}", path);
                    filesystemBundle = new PropertyResourceBundle(bufferedReader);
                }
                catch (IOException iOException) {
                    mcMMO.p.getLogger().log(Level.WARNING, "Failed to load locale from " + path, iOException);
                }
            }
            bundle = ResourceBundle.getBundle(BUNDLE_ROOT, locale);
            enBundle = ResourceBundle.getBundle(BUNDLE_ROOT, Locale.US);
        }
    }

    private static String addColors(String string) {
        string = string.replaceAll("\\Q[[BLACK]]\\E", ChatColor.BLACK.toString());
        string = string.replaceAll("\\Q[[DARK_BLUE]]\\E", ChatColor.DARK_BLUE.toString());
        string = string.replaceAll("\\Q[[DARK_GREEN]]\\E", ChatColor.DARK_GREEN.toString());
        string = string.replaceAll("\\Q[[DARK_AQUA]]\\E", ChatColor.DARK_AQUA.toString());
        string = string.replaceAll("\\Q[[DARK_RED]]\\E", ChatColor.DARK_RED.toString());
        string = string.replaceAll("\\Q[[DARK_PURPLE]]\\E", ChatColor.DARK_PURPLE.toString());
        string = string.replaceAll("\\Q[[GOLD]]\\E", ChatColor.GOLD.toString());
        string = string.replaceAll("\\Q[[GRAY]]\\E", ChatColor.GRAY.toString());
        string = string.replaceAll("\\Q[[DARK_GRAY]]\\E", ChatColor.DARK_GRAY.toString());
        string = string.replaceAll("\\Q[[BLUE]]\\E", ChatColor.BLUE.toString());
        string = string.replaceAll("\\Q[[GREEN]]\\E", ChatColor.GREEN.toString());
        string = string.replaceAll("\\Q[[AQUA]]\\E", ChatColor.AQUA.toString());
        string = string.replaceAll("\\Q[[RED]]\\E", ChatColor.RED.toString());
        string = string.replaceAll("\\Q[[LIGHT_PURPLE]]\\E", ChatColor.LIGHT_PURPLE.toString());
        string = string.replaceAll("\\Q[[YELLOW]]\\E", ChatColor.YELLOW.toString());
        string = string.replaceAll("\\Q[[WHITE]]\\E", ChatColor.WHITE.toString());
        string = string.replaceAll("\\Q[[BOLD]]\\E", ChatColor.BOLD.toString());
        string = string.replaceAll("\\Q[[UNDERLINE]]\\E", ChatColor.UNDERLINE.toString());
        string = string.replaceAll("\\Q[[ITALIC]]\\E", ChatColor.ITALIC.toString());
        string = string.replaceAll("\\Q[[STRIKE]]\\E", ChatColor.STRIKETHROUGH.toString());
        string = string.replaceAll("\\Q[[MAGIC]]\\E", ChatColor.MAGIC.toString());
        string = string.replaceAll("\\Q[[RESET]]\\E", ChatColor.RESET.toString());
        string = string.replaceAll("\\Q&0\\E", ChatColor.BLACK.toString());
        string = string.replaceAll("\\Q&1\\E", ChatColor.DARK_BLUE.toString());
        string = string.replaceAll("\\Q&2\\E", ChatColor.DARK_GREEN.toString());
        string = string.replaceAll("\\Q&3\\E", ChatColor.DARK_AQUA.toString());
        string = string.replaceAll("\\Q&4\\E", ChatColor.DARK_RED.toString());
        string = string.replaceAll("\\Q&5\\E", ChatColor.DARK_PURPLE.toString());
        string = string.replaceAll("\\Q&6\\E", ChatColor.GOLD.toString());
        string = string.replaceAll("\\Q&7\\E", ChatColor.GRAY.toString());
        string = string.replaceAll("\\Q&8\\E", ChatColor.DARK_GRAY.toString());
        string = string.replaceAll("\\Q&9\\E", ChatColor.BLUE.toString());
        string = string.replaceAll("\\Q&a\\E", ChatColor.GREEN.toString());
        string = string.replaceAll("\\Q&b\\E", ChatColor.AQUA.toString());
        string = string.replaceAll("\\Q&c\\E", ChatColor.RED.toString());
        string = string.replaceAll("\\Q&d\\E", ChatColor.LIGHT_PURPLE.toString());
        string = string.replaceAll("\\Q&e\\E", ChatColor.YELLOW.toString());
        string = string.replaceAll("\\Q&f\\E", ChatColor.WHITE.toString());
        string = string.replaceAll("\\Q&l\\E", ChatColor.BOLD.toString());
        string = string.replaceAll("\\Q&n\\E", ChatColor.UNDERLINE.toString());
        string = string.replaceAll("\\Q&o\\E", ChatColor.ITALIC.toString());
        string = string.replaceAll("\\Q&m\\E", ChatColor.STRIKETHROUGH.toString());
        string = string.replaceAll("\\Q&?\\E", ChatColor.MAGIC.toString());
        string = string.replaceAll("\\Q&r\\E", ChatColor.RESET.toString());
        return string;
    }
}

